/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.gui;

import java.awt.EventQueue;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTextArea;

public class ConsoleFrame
extends OutputStream
implements Runnable {
    private static final String EOL1 = "\n";
    private static final String EOL2 = System.getProperty("line.separator", "\n");
    private final JTextArea textArea;
    private final int maxNumLines;
    private final LinkedList<Integer> lineLengths;
    private final List<String> lines;
    private int curLength = 0;
    private boolean queue = true;
    private byte[] oneByte = new byte[1];

    public ConsoleFrame(JTextArea txtArea, int maxLines) {
        if (maxLines < 1) {
            throw new IllegalArgumentException("TextAreaOutputStream maximum lines must be positive (value=" + maxLines + ")");
        }
        this.textArea = txtArea;
        this.maxNumLines = maxLines;
        this.lineLengths = new LinkedList();
        this.lines = new ArrayList<String>();
    }

    public synchronized void clear() {
        if (this.lines != null) {
            this.curLength = 0;
            this.lineLengths.clear();
            this.lines.clear();
            if (this.queue) {
                this.queue = false;
                EventQueue.invokeLater(this);
            }
        }
    }

    @Override
    public synchronized void close() {
        this.clear();
    }

    @Override
    public synchronized void flush() {
    }

    @Override
    public synchronized void write(int val) {
        this.oneByte[0] = (byte)val;
        this.write(this.oneByte, 0, 1);
    }

    @Override
    public synchronized void write(byte[] ba, int offset, int len) {
        if (this.lineLengths != null && this.lines != null) {
            String str = "";
            try {
                str = new String(ba, offset, len, "UTF-8");
            }
            catch (UnsupportedEncodingException thr) {
                str = new String(ba, offset, len);
            }
            this.append(str);
        }
    }

    synchronized void append(String val) {
        this.lines.add(val);
        if (this.queue) {
            this.queue = false;
            EventQueue.invokeLater(this);
        }
    }

    @Override
    public synchronized void run() {
        if (this.lines.size() == 0) {
            this.textArea.setText("");
        }
        for (String val : this.lines) {
            this.curLength += val.length();
            if (val.endsWith(EOL1) || val.endsWith(EOL2)) {
                if (this.lineLengths.size() >= this.maxNumLines) {
                    this.textArea.replaceRange("", 0, this.lineLengths.removeFirst());
                }
                this.lineLengths.addLast(this.curLength);
                this.curLength = 0;
            }
            this.textArea.append(val);
        }
        this.lines.clear();
        this.queue = true;
    }
}

