/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.gui;

import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.time.TimeScale;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DateFormatter;
import javax.swing.text.MaskFormatter;

public class DatePanel
extends JPanel {
    public static final String FORMAT_CHARS = " /:";
    public static final String FORMAT_STRING = "yyyy / MM / dd   HH:mm";
    public static final int TOTAL_DIGITS_IN_DATE = DatePanel.getTotalDateDigits();
    public static final int[] YEAR = new int[2];
    public static final int[] MONTH = new int[2];
    public static final int[] DAY = new int[2];
    public static final int[] HOUR = new int[2];
    public static final int[] MINUTE = new int[2];
    private DateFormat format = new SimpleDateFormat("yyyy / MM / dd   HH:mm");
    private DateFormatter formatter = new DateFormatter(this.format);
    private JFormattedTextField df;
    private TimeScale date;
    private String old = "";
    private int posPressed = 0;

    static {
        int i = 0;
        while (i < FORMAT_STRING.length()) {
            DatePanel.YEAR[0] = FORMAT_STRING.indexOf(121);
            DatePanel.MONTH[0] = FORMAT_STRING.indexOf(77);
            DatePanel.DAY[0] = FORMAT_STRING.indexOf(100);
            DatePanel.HOUR[0] = FORMAT_STRING.indexOf(72);
            DatePanel.MINUTE[0] = FORMAT_STRING.indexOf(109);
            DatePanel.YEAR[1] = FORMAT_STRING.lastIndexOf(121);
            DatePanel.MONTH[1] = FORMAT_STRING.lastIndexOf(77);
            DatePanel.DAY[1] = FORMAT_STRING.lastIndexOf(100);
            DatePanel.HOUR[1] = FORMAT_STRING.lastIndexOf(72);
            DatePanel.MINUTE[1] = FORMAT_STRING.lastIndexOf(109);
            ++i;
        }
        i = 0;
        while (i < FORMAT_STRING.length()) {
            if (!Character.isLetter(FORMAT_STRING.charAt(i)) && !FORMAT_CHARS.contains(String.valueOf(FORMAT_STRING.charAt(i)))) {
                throw new IllegalArgumentException("Check you date fromat. Fields must be separated witn chars from FORMAT_CHARS");
            }
            ++i;
        }
    }

    private static MaskFormatter createMask() {
        String mask = "";
        int i = 0;
        while (i < FORMAT_STRING.length()) {
            mask = Character.isLetter(FORMAT_STRING.charAt(i)) ? String.valueOf(mask) + "#" : String.valueOf(mask) + FORMAT_STRING.charAt(i);
            ++i;
        }
        try {
            return new MaskFormatter(mask);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static int getTotalDateDigits() {
        int count = 0;
        int i = 0;
        while (i < FORMAT_STRING.length()) {
            if (Character.isLetter(FORMAT_STRING.charAt(i))) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public DatePanel() {
        this(new TimeScale());
    }

    public DatePanel(TimeScale time) {
        this.date = new TimeScale(time.getTimeInMillis());
        this.format.setTimeZone(this.date.getTimeZone());
        this.df = new JFormattedTextField(DatePanel.createMask());
        try {
            this.df.setText(this.formatter.valueToString(this.date.getTime()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.old = this.df.getText();
        this.df.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                int p = DatePanel.this.df.getCaretPosition();
                DatePanel.this.posPressed = p;
                if (e.getKeyCode() == 8 && (p == YEAR[0] || p == MONTH[0] || p == DAY[0] || p == HOUR[0] || p == MINUTE[0])) {
                    if (p == YEAR[0]) {
                        DatePanel.this.df.setCaretPosition(YEAR[0]);
                    } else if (p == MONTH[0]) {
                        DatePanel.this.df.setCaretPosition(YEAR[1] + 1);
                    } else if (p == DAY[0]) {
                        DatePanel.this.df.setCaretPosition(MONTH[1] + 1);
                    } else if (p == HOUR[0]) {
                        DatePanel.this.df.setCaretPosition(DAY[1] + 1);
                    } else if (p == MINUTE[0]) {
                        DatePanel.this.df.setCaretPosition(HOUR[1] + 1);
                    }
                    SwingUtilities.invokeLater(DatePanel.this.getEmptyFieldsFixer(DatePanel.this.df.getText(), DatePanel.this.df.getCaretPosition()));
                    e.consume();
                }
                if (e.getKeyCode() == 127 && (p == YEAR[1] || p == MONTH[1] || p == DAY[1] || p == HOUR[1] || p == MINUTE[1])) {
                    int p1 = DatePanel.this.df.getCaretPosition();
                    if (p == YEAR[1]) {
                        p1 = MONTH[0];
                    } else if (p == MONTH[1]) {
                        p1 = DAY[0];
                    } else if (p == DAY[1]) {
                        p1 = HOUR[0];
                    } else if (p == HOUR[1]) {
                        p1 = MINUTE[0];
                    } else if (p == MINUTE[1]) {
                        p1 = MINUTE[1] + 1;
                    }
                    SwingUtilities.invokeLater(DatePanel.this.getEmptyFieldsFixer_del(p1));
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                SwingUtilities.invokeLater(DatePanel.this.getEmptyFieldsFixer(DatePanel.this.df.getText(), DatePanel.this.df.getCaretPosition()));
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.df.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SwingUtilities.invokeLater(DatePanel.this.getEmptyFieldsFixer(DatePanel.this.df.getText(), DatePanel.this.df.getCaretPosition()));
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.df.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.doUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.doUpdate();
            }

            private void doUpdate() {
                final String text = DatePanel.this.df.getText();
                if (!DatePanel.this.isEnoughDigits(text)) {
                    return;
                }
                if (DatePanel.this.checkFieldsOK(text)) {
                    DatePanel.this.updateDate(DatePanel.this.old);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!DatePanel.this.checkFieldsOK(text)) {
                            DatePanel.this.df.setText(DatePanel.this.old);
                            DatePanel.this.df.setCaretPosition(DatePanel.this.posPressed);
                        }
                    }
                });
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }
        });
        this.add(this.df);
    }

    private Runnable getEmptyFieldsFixer(final String text, final int pos) {
        return new Runnable(){

            @Override
            public void run() {
                DatePanel.this.fixEmptyFields(text, pos);
            }
        };
    }

    private Runnable getEmptyFieldsFixer_del(final int pos) {
        return new Runnable(){

            @Override
            public void run() {
                DatePanel.this.fixEmptyFields(DatePanel.this.df.getText(), pos);
            }
        };
    }

    private void fixEmptyFields(String text, int pos) {
        this.fill(text, YEAR, pos, "2000");
        this.fill(text, MONTH, pos, "01");
        this.fill(text, DAY, pos, "01");
        this.fill(text, HOUR, pos, "00");
        this.fill(text, MINUTE, pos, "00");
        this.df.setCaretPosition(pos);
    }

    private void fill(String text, int[] range, int position, String def) {
        if (this.digitsAtField(text, range) == 0 && (position < range[0] || position > range[1])) {
            this.df.setText(this.replaceSubstring(text, def, range[0]));
        } else if (this.digitsAtField(text, range) < range[1] - range[0] + 1 && (position < range[0] || position > range[1])) {
            int val;
            int n = val = this.getFiledAt(range) == 1 ? this.getVal_year(text, range) : this.getVal(text, range);
            if (this.isValueValid(val, range, this.date)) {
                this.df.setText(this.replaceSubstring(text, FC.IntegerToString(val, range[1] - range[0] + 1, '0'), range[0]));
            } else if (val == 0) {
                this.df.setText(this.replaceSubstring(text, def, range[0]));
            } else {
                this.df.setText(this.old);
            }
        }
    }

    private String replaceSubstring(String text, String sub, int start) {
        return String.valueOf(text.substring(0, start)) + sub + text.substring(start + sub.length(), text.length());
    }

    private void updateDate(String oldVal) {
        try {
            this.date.setTime((Date)this.formatter.stringToValue(this.df.getText()));
            this.old = new String(this.formatter.valueToString(this.date.getTime()));
        }
        catch (ParseException e1) {
            this.df.setText(oldVal);
        }
    }

    private boolean isEnoughDigits(String text) {
        int[] nArray = new int[2];
        nArray[1] = text.length() - 1;
        int count = this.digitsAtField(text, nArray);
        if (count > TOTAL_DIGITS_IN_DATE) {
            throw new RuntimeException("Something went wrong during date input - input date is of the wrong format.Must be yyyy / MM / dd   HH:mm");
        }
        return count == TOTAL_DIGITS_IN_DATE;
    }

    private int digitsAtField(String text, int[] range) {
        int count = 0;
        int i = range[0];
        while (i <= range[1]) {
            count += Character.isDigit(text.charAt(i)) ? 1 : 0;
            ++i;
        }
        return count;
    }

    private boolean checkFieldsOK(String text) {
        if (!this.isEnoughDigits(text)) {
            return false;
        }
        boolean year = this.isValueValid(this.getVal(text, YEAR), YEAR, this.date);
        boolean month = this.isValueValid(this.getVal(text, MONTH), MONTH, this.date);
        boolean day = this.isValueValid(this.getVal(text, DAY), DAY, this.date);
        boolean hour = this.isValueValid(this.getVal(text, HOUR), HOUR, this.date);
        boolean minute = this.isValueValid(this.getVal(text, MINUTE), MINUTE, this.date);
        return year && month && day && hour && minute;
    }

    private boolean isValueValid(int val, int[] range, TimeScale date) {
        int min;
        int field = this.getFiledAt(range);
        int v = this.getFiledAt(range) == 2 ? val - 1 : val;
        int n = min = this.getFiledAt(range) == 1 ? 2000 : date.getActualMinimum(field);
        return v >= min && v <= date.getActualMaximum(field);
    }

    private int getFiledAt(int[] range) {
        if (range[0] == YEAR[0] && range[1] == YEAR[1]) {
            return 1;
        }
        if (range[0] == MONTH[0] && range[1] == MONTH[1]) {
            return 2;
        }
        if (range[0] == DAY[0] && range[1] == DAY[1]) {
            return 5;
        }
        if (range[0] == HOUR[0] && range[1] == HOUR[1]) {
            return 11;
        }
        if (range[0] == MINUTE[0] && range[1] == MINUTE[1]) {
            return 12;
        }
        throw new IllegalArgumentException("This range does not correspond to any field. " + range[0] + " to " + range[1]);
    }

    private int getVal_year(String text, int[] range) {
        return Integer.parseInt(text.substring(range[0], range[1] + 1).replace(' ', '0'));
    }

    private int getVal(String text, int[] range) {
        return Integer.parseInt(text.substring(range[0], range[1] + 1).trim());
    }

    public TimeScale getDate() {
        return new TimeScale(this.date.getTimeInMillis());
    }

    public void setDate(TimeScale date) {
        this.date.setTimeInMillis(date.getTimeInMillis());
        try {
            this.df.setText(this.formatter.valueToString(date.getTime()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public boolean checkOK() {
        if (this.checkFieldsOK(this.df.getText())) {
            this.updateDate(this.old);
            return true;
        }
        return false;
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.setEnabled(flag);
            ++n2;
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.setFont(font);
            ++n2;
        }
    }

    public static void main(String[] args) {
        DatePanel mdf = new DatePanel(new TimeScale());
        JFrame frame = new JFrame();
        frame.add(mdf);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }
}

