/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class SitesSelectFrame
extends JDialog {
    public static final int ROW_NUM = 20;
    public static final int COL_WIDTH = 90;
    public static final int ROW_HEIGHT = 28;
    public static final int FRAME_ADD_HEIGHT = 40;
    public static final int FRAME_ADD_WIDTH = 20;

    public SitesSelectFrame(final String[] ursis, final Boolean[] check, int xloc, int yloc) {
        int colNum = ursis.length / 20 + 1 > 1 ? ursis.length / 20 + 1 : 2;
        int frameWidth = 90 * colNum + 20;
        int frameHeight = 628;
        JPanel panel = new JPanel();
        final SitesSelectFrame frame = this;
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[colNum];
        int i = 0;
        while (i < colNum) {
            gridBagLayout.columnWidths[i] = 90;
            ++i;
        }
        gridBagLayout.rowHeights = new int[21];
        i = 0;
        while (i < 20) {
            gridBagLayout.rowHeights[i] = 28;
            ++i;
        }
        panel.setLayout(gridBagLayout);
        final JCheckBox[] chkSite = new JCheckBox[ursis.length];
        int i2 = 0;
        while (i2 < ursis.length) {
            chkSite[i2] = new JCheckBox(ursis[i2]);
            panel.add((Component)chkSite[i2], this.getGBC(i2 / 20, i2 % 20));
            ++i2;
        }
        JButton btnOk = new JButton("Ok");
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int i = 0;
                while (i < ursis.length) {
                    check[i] = chkSite[i].isSelected();
                    ++i;
                }
                frame.dispose();
            }
        });
        panel.add((Component)btnOk, this.getGBC(colNum - 2, 21));
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int i = 0;
                while (i < ursis.length) {
                    check[i] = null;
                    ++i;
                }
                frame.dispose();
            }
        });
        panel.add((Component)btnCancel, this.getGBC(colNum - 1, 21));
        this.add(panel);
        this.setTitle("Time interval");
        this.setSize(frameWidth, 628);
        this.setLocation(xloc, yloc);
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setVisible(true);
    }

    private GridBagConstraints getGBC(int gridx, int gridy) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 5);
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        return gbc;
    }

    public static boolean[] getSitesChecking(String[] ursis) {
        Boolean[] check = new Boolean[ursis.length];
        boolean[] checkR = new boolean[ursis.length];
        SitesSelectFrame frame = new SitesSelectFrame(ursis, check, MouseInfo.getPointerInfo().getLocation().x, MouseInfo.getPointerInfo().getLocation().y);
        frame.setDefaultCloseOperation(2);
        int i = 0;
        while (i < check.length) {
            if (check[i] == null) {
                return null;
            }
            checkR[i] = check[i];
            ++i;
        }
        return checkR;
    }

    public static String[] getCheckedSites(String[] ursis) {
        boolean[] check = SitesSelectFrame.getSitesChecking(ursis);
        if (check == null) {
            return null;
        }
        if (check.length != ursis.length) {
            throw new RuntimeException("Check sites checking frame.");
        }
        int count = 0;
        boolean[] blArray = check;
        int n = check.length;
        int n2 = 0;
        while (n2 < n) {
            boolean c = blArray[n2];
            count = c ? count + 1 : count;
            ++n2;
        }
        String[] checkedUrsis = new String[count];
        count = 0;
        int i = 0;
        while (i < check.length) {
            if (check[i]) {
                checkedUrsis[count] = ursis[i];
                ++count;
            }
            ++i;
        }
        return checkedUrsis;
    }
}

