/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.reports;

import edu.uml.giro.gambit.core.Core;
import edu.uml.giro.gambit.core.GambitConstants;
import edu.uml.giro.gambit.core.LocalData;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.format.IonexMap;
import edu.uml.lgdc.format.IonexRecordSet;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.EarthGrid;
import edu.uml.lgdc.geospace.Geomap;
import edu.uml.lgdc.geospace.MapChoice;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

public class MapDataExporter {
    public static final EarthGrid EXPORT_EARTH_GRID = new EarthGrid(73, 72);
    public static final EarthGrid IONEX_EARTH_GRID = new EarthGrid(73, 72);

    public static void outputGridValues(Core core, File fileS, TimeScale buildToDate, int[] latlonN, String application) {
        MapChoice mc = core.getCurrentMapChoice();
        CharChoice cc = mc.getCC();
        String units = mc.isPercentDeltaMap() ? "%" : cc.getUnits();
        boolean rerunIRTAM = core.getGambitCoreSettings().isRerunAssimilation();
        if (!buildToDate.equals(core.getTimeOfValidity()) || rerunIRTAM) {
            core.setTimeOfValidity(buildToDate, 1 + (rerunIRTAM ? 8 : 0), core.VERSIONS);
        }
        double[] outputValues = core.synthesizeCurrentMap_1D(EXPORT_EARTH_GRID, buildToDate, mc);
        MapDataExporter.outputGridValues(outputValues, fileS, buildToDate, latlonN, application, "", core);
    }

    public static void outputGridValues(double[] outputValues, File fileS, TimeScale buildToDate, int[] latlonN, String application, String descriptor, Core core) {
        MapChoice mc = core.getCurrentMapChoice();
        CharChoice cc = mc.getCC();
        String units = mc.isPercentDeltaMap() ? "%" : cc.getUnits();
        try {
            PrintWriter writer = new PrintWriter(fileS.getAbsolutePath());
            writer.write(GambitConstants.EXPORT_START_HEADER);
            writer.write("# GLOBAL IONOSPHERE RADIO OBSERVATORY (G.I.R.O.)\n# giro.uml.edu\n#\n# IRI-based Real-Time Assimilative Model (IRTAM)\n#\n");
            writer.write("# 2D MAP EXPORT generated by " + application + " at " + new TimeScale().toFormatISO8601() + "\n#\n");
            writer.write("# Ionospheric Characteristic : " + cc.getName() + ", " + mc.getDescription() + " " + descriptor + "\n");
            writer.write("# Time of validity           : " + buildToDate.toFormatISO8601() + "\n");
            writer.write("# IRTAM Version              : " + core.VERSIONS.name + "\n");
            writer.write("# Assimilation Algorithm     : " + core.VERSIONS.assimilationName + "\n#\n");
            writer.write("# Excluded input GIRO sites  : " + core.VERSIONS.excludedSites + "\n");
            writer.write("# Control GIRO site          : " + core.VERSIONS.controlSite + "\n");
            writer.write("# Support sites to Control   : " + (core.VERSIONS.supportSites == null ? "" : core.VERSIONS.supportSites.toString()) + "\n#\n");
            writer.write("#-- Lat, deg --- Lon, deg ---  Value, " + units + " --\n#\n");
            writer.write(GambitConstants.EXPORT_END_HEADER);
            int lonNodes = EXPORT_EARTH_GRID.getNumLongitudeNodes();
            int latNodes = EXPORT_EARTH_GRID.getNumLatitudeNodes();
            double latStep = EXPORT_EARTH_GRID.getLatitudeStep();
            double lonStep = EXPORT_EARTH_GRID.getLongitudeStep();
            int i = lonNodes;
            while (i < outputValues.length - lonNodes) {
                double lat_degrees = 90.0 - (double)(i / lonNodes) * latStep;
                double lon_degrees = (double)(i % lonNodes) * lonStep - 180.0;
                writer.write(String.valueOf(FC.DoubleToString(lat_degrees, 10, 2)) + "    " + FC.DoubleToString(lon_degrees, 10, 2) + "    " + FC.doubleToString(outputValues[i], 2, true) + "\n");
                ++i;
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean outputGridValues_ionex(Core core, File fileS, TimeScale buildToDate, int[] latlonN) {
        MapChoice mc = core.getCurrentMapChoice();
        CharChoice cc = mc.getCC();
        boolean rerunIRTAM = core.getGambitCoreSettings().isRerunAssimilation();
        if (!buildToDate.equals(core.getTimeOfValidity()) || rerunIRTAM) {
            core.setTimeOfValidity(buildToDate, 1 + (rerunIRTAM ? 8 : 0), core.VERSIONS);
        }
        Geomap gambitMap = core.synthesizeCurrentMap(IONEX_EARTH_GRID, buildToDate, mc);
        return MapDataExporter.outputOneMap_ionex(fileS, gambitMap, core.getChar((int)cc.getIndex()).localData);
    }

    public static boolean outputOneMap_ionex(File selectedFile, Geomap geomap, LocalData localData) {
        IonexRecordSet recordSet = new IonexRecordSet();
        if (!recordSet.getGrid().set(geomap.getEarthGrid(), 300.0, geomap.getRefTime(), geomap.getRefTime(), 0)) {
            return false;
        }
        if (!recordSet.setGambitMaps(new Geomap[]{geomap})) {
            return false;
        }
        if (!recordSet.setCharChoice(geomap.getMapChoice().getCC())) {
            return false;
        }
        recordSet.setSoftwareVersion("GX.User 1.3E");
        recordSet.setTotalSites(localData.totalLocations);
        if (!recordSet.getComments().containsKey("# OF STATIONS       ")) {
            recordSet.getComments().put("# OF STATIONS       ", "Global Ionosphere Radio Observatory (GIRO): stations used   " + localData.getAllUrsiCodes());
        }
        return IonexMap.write(selectedFile.getAbsolutePath(), recordSet);
    }
}

