/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.reports;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import edu.uml.giro.gambit.core.Core;
import edu.uml.giro.gambit.core.LocalData;
import edu.uml.giro.gambit.core.LocalDataOneSiteAllTimes;
import edu.uml.lgdc.appuserdb.api.UserCredentials;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.EarthGrid;
import edu.uml.lgdc.geospace.MapChoice;
import edu.uml.lgdc.instrument.StationLocation;
import edu.uml.lgdc.time.TimeScale;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Locale;

public class PecasusMUF3000 {
    public static final int PECASUS_NLATS = 36;
    public static final int PECASUS_NLONS = 24;
    public static final int DOWNSAMPLING_AVERAGE = 1;
    public static final int DOWNSAMPLING_EXTREME = 2;
    public static final int MAP_NO_VALUE = -9999;
    public static final int UNKNOWN_CONFIDENCE = -99;
    public static final int MAX_CONFIDENCE = 75;
    private static Object syncNewRecord = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Writer writer, TimeScale targetTime, Core core, UserCredentials userCreds) throws IOException {
        Object object = syncNewRecord;
        synchronized (object) {
            Muf3000Record record = new Muf3000Record(core, targetTime, userCreds);
            PecasusMUF3000.openJsonRecord(writer);
            PecasusMUF3000.writeJsonMetadata(writer, record.metadata);
            writer.write(",\n");
            PecasusMUF3000.writeJson1DIntArray(writer, record.Latitude, "Latitude");
            writer.write(",\n");
            PecasusMUF3000.writeJson1DIntArray(writer, record.Longitude, "Longitude");
            writer.write(",\n");
            PecasusMUF3000.writeJson2DIntArray(writer, record.muf3000delta, "Percentage_Depression");
            writer.write(",\n");
            PecasusMUF3000.writeJson2DIntArray(writer, record.muf3000background, "30-day_median");
            writer.write(",\n");
            PecasusMUF3000.writeJson2DIntArray(writer, record.confidence, "Data_Confidence");
            writer.write(",\n");
            PecasusMUF3000.writeJson2DIntArray(writer, record.muf3000, "MUF(3000)F2");
            writer.write(",\n");
            PecasusMUF3000.writeJson2DIntArray(writer, record.foF2, "foF2");
            writer.write(",\n");
            PecasusMUF3000.writeJson2DIntArray(writer, record.hmF2, "hmF2");
            PecasusMUF3000.closeJsonRecord(writer);
            writer.close();
        }
    }

    private static void openJsonRecord(Writer writer) throws IOException {
        writer.write("{\n");
    }

    private static void writeJsonMetadata(Writer writer, Muf3000Metadata metadata) throws IOException {
        writer.write("\"metadata\":");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        writer.write(gson.toJson((Object)metadata));
    }

    private static void writeJson1DIntArray(Writer writer, int[] array, String name) throws IOException {
        writer.write("\"" + name + "\":");
        writer.write("[");
        writer.write(String.format(Locale.US, "%d", array[0]));
        int i = 1;
        while (i < array.length) {
            writer.write(", " + String.format(Locale.US, "%d", array[i]));
            ++i;
        }
        writer.write("]");
    }

    private static void writeJson2DIntArray(Writer writer, int[][] array, String name) throws IOException {
        writer.write("\"" + name + "\":");
        writer.write("[\n");
        int i = 0;
        while (i < array.length) {
            writer.write("[");
            writer.write(String.format(Locale.US, "%5d", array[i][0]));
            int j = 1;
            while (j < array[0].length) {
                writer.write(", " + String.format(Locale.US, "%5d", array[i][j]));
                ++j;
            }
            writer.write("]");
            if (i < array.length - 1) {
                writer.write(", ");
            }
            writer.write("\n");
            ++i;
        }
        writer.write("]");
    }

    private static void closeJsonRecord(Writer writer) throws IOException {
        writer.write("\n}\n");
    }

    public static void serialize(String filename, TimeScale targetTime, Core core, UserCredentials userCreds) throws IOException {
        Muf3000Record record = new Muf3000Record(core, targetTime, userCreds);
        Gson gson = new GsonBuilder().create();
        BufferedWriter writer = Files.newBufferedWriter(Paths.get(filename, new String[0]), new OpenOption[0]);
        gson.toJson((Object)record, (Appendable)writer);
        ((Writer)writer).close();
    }

    static class ElementMetadataGrid {
        String unit;
        String type_data;
        int length_char;
        double scalefactor;
        String values;
        String coordinate;
        int max;
        int min;
        int delta;
        String type_array;
        int rows;
        int columns;

        ElementMetadataGrid(String unit, String type_data, int length_char, double scalefactor, String values, String coordinate, int max, int min, int delta, String type_array, int rows, int columns) {
            this.unit = unit;
            this.type_data = type_data;
            this.length_char = length_char;
            this.scalefactor = scalefactor;
            this.values = values;
            this.coordinate = coordinate;
            this.max = max;
            this.min = min;
            this.delta = delta;
            this.type_array = type_array;
            this.rows = rows;
            this.columns = columns;
        }
    }

    static class ElementMetadataMap {
        String unit;
        String type_data;
        int length_char;
        double scalefactor;
        String values;
        int missingValue;
        String type_array;
        int rows;
        int columns;

        ElementMetadataMap(String unit, String type_data, int length_char, double scalefactor, String values, int missingValue, String type_array, int rows, int columns) {
            this.unit = unit;
            this.type_data = type_data;
            this.length_char = length_char;
            this.scalefactor = scalefactor;
            this.values = values;
            this.missingValue = missingValue;
            this.type_array = type_array;
            this.rows = rows;
            this.columns = columns;
        }
    }

    static class Muf3000Metadata {
        String Model_Code;
        String Model_Owner;
        String Valid_Time;
        String Analysis_Time;
        String _Measurement_Time;
        String _Requester;
        ElementMetadataGrid Latitude;
        ElementMetadataGrid Longitude;
        ElementMetadataMap Percentage_Depression;
        @SerializedName(value="30-day_median")
        ElementMetadataMap ThirtyDayMedian;
        ElementMetadataMap Data_Confidence;
        @SerializedName(value="MUF(3000)F2")
        ElementMetadataMap MUF3000F2;
        ElementMetadataMap foF2;
        ElementMetadataMap hmF2;

        Muf3000Metadata(Core core, TimeScale targetTime, UserCredentials userCreds) {
            this.Model_Code = core.VERSIONS.name;
            this.Model_Owner = "Lowell GIRO Data Center";
            this.Valid_Time = targetTime.toFormatUT("yyyyMMdd'T'HHmm");
            this._Measurement_Time = core.getTimeOfValidity().toFormatUT("yyyyMMdd'T'HHmm");
            this._Requester = String.valueOf(userCreds.getUserLogin()) + ", " + userCreds.getUserHost();
            TimeScale analysisTime = new TimeScale(core.getTimeOfValidity().getTimeInMillis());
            analysisTime.add(13, 465);
            this.Analysis_Time = analysisTime.toFormatUT("yyyyMMdd'T'HHmm");
            this.Latitude = new ElementMetadataGrid("degrees", "integer", 5, 0.01, "+/-", "geographical", 8750, -8750, 500, "1D", 1, 36);
            this.Longitude = new ElementMetadataGrid("degrees", "integer", 5, 0.01, "+", "geographical", 35250, 750, 1500, "1D", 1, 24);
            this.Percentage_Depression = new ElementMetadataMap("percentage", "integer", 5, 0.01, "+/-", -9999, "2D", 36, 24);
            this.ThirtyDayMedian = new ElementMetadataMap("MHz", "integer", 5, 0.01, "+", -9999, "2D", 36, 24);
            this.Data_Confidence = new ElementMetadataMap("Absolute", "integer", 3, 0.01, "+", -99, "2D", 36, 24);
            this.MUF3000F2 = new ElementMetadataMap("MHz", "integer", 5, 0.01, "+", -9999, "2D", 36, 24);
            this.foF2 = new ElementMetadataMap("MHz", "integer", 5, 0.01, "+", -9999, "2D", 36, 24);
            this.hmF2 = new ElementMetadataMap("km", "integer", 5, 0.1, "+", -9999, "2D", 36, 24);
        }
    }

    static class Muf3000Record {
        Muf3000Metadata metadata;
        int[] Latitude = new int[36];
        int[] Longitude = new int[24];
        int[][] muf3000delta = new int[36][24];
        int[][] muf3000delta_alt = new int[36][24];
        int[][] muf3000background = new int[36][24];
        int[][] confidence = new int[36][24];
        int[][] muf3000 = new int[36][24];
        int[][] foF2 = new int[36][24];
        int[][] foF2_alt = new int[36][24];
        int[][] hmF2 = new int[36][24];
        int[][] hmF2_alt = new int[36][24];

        Muf3000Record(Core core, TimeScale targetTime, UserCredentials userCreds) {
            this.metadata = new Muf3000Metadata(core, targetTime, userCreds);
            this.Latitude[0] = 8750;
            int iLat = 1;
            while (iLat < 36) {
                this.Latitude[iLat] = this.Latitude[iLat - 1] - 500;
                ++iLat;
            }
            this.Longitude[0] = 750;
            int iLon = 1;
            while (iLon < 24) {
                this.Longitude[iLon] = this.Longitude[iLon - 1] + 1500;
                ++iLon;
            }
            EarthGrid fineEarthGrid23 = new EarthGrid(73, 72);
            double[][] mufDeltaMap23 = core.synthesizeCurrentMap(fineEarthGrid23, targetTime, MapChoice.MUF3000_DELTA_PERCENT).getMap();
            iLat = 0;
            while (iLat < 36) {
                iLon = 0;
                while (iLon < 24) {
                    this.muf3000delta[iLat][iLon] = this.downsample32(mufDeltaMap23, iLat, iLon, 2);
                    ++iLon;
                }
                ++iLat;
            }
            double[][] mufClimateMap23 = core.synthesizeCurrentMap(fineEarthGrid23, targetTime, MapChoice.MUF3000_CLIMATE).getMap();
            iLat = 0;
            while (iLat < 36) {
                iLon = 0;
                while (iLon < 24) {
                    this.muf3000background[iLat][iLon] = this.downsample32(mufClimateMap23, iLat, iLon, 1);
                    ++iLon;
                }
                ++iLat;
            }
            double[][] mufMap23 = core.synthesizeCurrentMap(fineEarthGrid23, targetTime, MapChoice.MUF3000_WEATHER).getMap();
            iLat = 0;
            while (iLat < 36) {
                iLon = 0;
                while (iLon < 24) {
                    this.muf3000[iLat][iLon] = this.downsample32(mufMap23, iLat, iLon, 1);
                    ++iLon;
                }
                ++iLat;
            }
            double[][] foF2map23 = core.synthesizeCurrentMap(fineEarthGrid23, targetTime, MapChoice.FOF2_WEATHER).getMap();
            iLat = 0;
            while (iLat < 36) {
                iLon = 0;
                while (iLon < 24) {
                    this.foF2[iLat][iLon] = this.downsample32(foF2map23, iLat, iLon, 1);
                    ++iLon;
                }
                ++iLat;
            }
            double[][] hmF2map23 = core.synthesizeCurrentMap(fineEarthGrid23, targetTime, MapChoice.HMF2_WEATHER).getMap();
            iLat = 0;
            while (iLat < 36) {
                iLon = 0;
                while (iLon < 24) {
                    this.hmF2[iLat][iLon] = this.downsample32(hmF2map23, iLat, iLon, 1);
                    ++iLon;
                }
                ++iLat;
            }
            int totalIrtamLats = 73;
            EarthGrid fineEarthGrid22 = new EarthGrid(73, 48);
            double[][] mufDeltaMap22 = core.synthesizeCurrentMap(fineEarthGrid22, targetTime, MapChoice.MUF3000_DELTA_PERCENT).getMap();
            iLat = 0;
            while (iLat < 36) {
                iLon = 0;
                while (iLon < 24) {
                    this.muf3000delta_alt[iLat][iLon] = this.downsample22(mufDeltaMap22, iLat, iLon);
                    ++iLon;
                }
                ++iLat;
            }
            double[][] foF2map22 = core.synthesizeCurrentMap(fineEarthGrid22, targetTime, MapChoice.FOF2_WEATHER).getMap();
            iLat = 0;
            while (iLat < 36) {
                iLon = 0;
                while (iLon < 24) {
                    this.foF2_alt[iLat][iLon] = this.downsample22(foF2map22, iLat, iLon);
                    ++iLon;
                }
                ++iLat;
            }
            double[][] hmF2map22 = core.synthesizeCurrentMap(fineEarthGrid22, targetTime, MapChoice.HMF2_WEATHER).getMap();
            iLat = 0;
            while (iLat < 36) {
                iLon = 0;
                while (iLon < 24) {
                    this.hmF2_alt[iLat][iLon] = this.downsample22(hmF2map22, iLat, iLon);
                    ++iLon;
                }
                ++iLat;
            }
            iLat = 0;
            while (iLat < 36) {
                iLon = 0;
                while (iLon < 24) {
                    this.confidence[iLat][iLon] = -99;
                    ++iLon;
                }
                ++iLat;
            }
            LocalData localData = core.getLocalData(CharChoice.HMF2);
            LocalDataOneSiteAllTimes[] localDataOneSiteAllTimesArray = localData.sites;
            int n = localData.sites.length;
            int n2 = 0;
            while (n2 < n) {
                LocalDataOneSiteAllTimes site = localDataOneSiteAllTimesArray[n2];
                if (!site.isUnused()) {
                    StationLocation loc = site.getLocation();
                    int lat = (int)(loc.getLat() * 100.0);
                    int lon = (int)(loc.getLon() * 100.0);
                    int iLatBest = 0;
                    iLat = 1;
                    while (iLat < 36) {
                        if (Math.abs(this.Latitude[iLat] - lat) < Math.abs(this.Latitude[iLatBest] - lat)) {
                            iLatBest = iLat;
                        }
                        ++iLat;
                    }
                    int iLonBest = 0;
                    iLon = 1;
                    while (iLon < 24) {
                        if (Math.abs(this.Longitude[iLon] - lon) < Math.abs(this.Longitude[iLonBest] - lon)) {
                            iLonBest = iLon;
                        }
                        ++iLon;
                    }
                    this.confidence[iLatBest][iLonBest] = 75;
                    this.extrapolateConfidence(this.confidence, this.decrement(iLatBest, 36), this.decrement(iLonBest, 24), 65);
                    this.extrapolateConfidence(this.confidence, this.decrement(iLatBest, 36), iLonBest, 75);
                    this.extrapolateConfidence(this.confidence, iLatBest, this.decrement(iLonBest, 24), 75);
                    this.extrapolateConfidence(this.confidence, this.increment(iLatBest, 36), this.increment(iLonBest, 24), 65);
                    this.extrapolateConfidence(this.confidence, this.increment(iLatBest, 36), iLonBest, 75);
                    this.extrapolateConfidence(this.confidence, iLatBest, this.increment(iLonBest, 24), 75);
                }
                ++n2;
            }
            iLat = 1;
            while (iLat < 35) {
                iLon = 0;
                while (iLon < 24) {
                    int previous = this.confidence[iLat][iLon];
                    if (previous < 75) {
                        this.extrapolateConfidence(this.confidence, this.decrement(iLat, 36), this.decrement(iLon, 24), previous - 10);
                        this.extrapolateConfidence(this.confidence, this.decrement(iLat, 36), iLon, previous);
                        this.extrapolateConfidence(this.confidence, iLat, this.decrement(iLon, 24), previous);
                        this.extrapolateConfidence(this.confidence, this.increment(iLat, 36), this.increment(iLon, 24), previous - 10);
                        this.extrapolateConfidence(this.confidence, this.increment(iLat, 36), iLon, previous);
                        this.extrapolateConfidence(this.confidence, iLat, this.increment(iLon, 24), previous);
                    }
                    ++iLon;
                }
                ++iLat;
            }
        }

        private int decrement(int value, int max) {
            int output = value - 1;
            if (output < 0) {
                output = max - 1;
            }
            return output;
        }

        private int increment(int value, int max) {
            return (value + 1) % max;
        }

        private void extrapolateConfidence(int[][] c, int i, int j, int base) {
            int previous = c[i][j];
            int attenuated = base / 2;
            if (previous == -99) {
                if (attenuated >= 25) {
                    c[i][j] = attenuated;
                }
                return;
            }
            c[i][j] = previous > attenuated ? Math.min(previous + 2, 75) : Math.min(previous + attenuated / 3, 60);
        }

        private int downsample22(double[][] irtamMap, int iLat, int iLon) {
            int totalIrtamLats = irtamMap.length;
            return (int)(irtamMap[totalIrtamLats - iLat * 2 - 1][iLon * 2 + 1] * 100.0);
        }

        private int downsample32(double[][] irtamMap, int iLat, int iLon, int algorithm) {
            int j;
            int[][] values = new int[3][3];
            int totalIrtamLats = irtamMap.length;
            int i = 0;
            while (i < 3) {
                j = 0;
                while (j < 3) {
                    double val = irtamMap[totalIrtamLats - 1 - iLat * 2 - i][iLon * 3 + j];
                    values[i][j] = val == 9999.0 ? -9999 : (int)(val * 100.0);
                    ++j;
                }
                ++i;
            }
            switch (algorithm) {
                case 1: {
                    long sum = 0L;
                    i = 0;
                    while (i < 3) {
                        j = 0;
                        while (j < 3) {
                            sum += (long)values[i][j];
                            ++j;
                        }
                        ++i;
                    }
                    return (int)(sum / 9L);
                }
                case 2: {
                    int min = Integer.MAX_VALUE;
                    int max = Integer.MIN_VALUE;
                    i = 0;
                    while (i < 3) {
                        j = 0;
                        while (j < 3) {
                            int val = values[i][j];
                            if (val != -9999) {
                                if (val > max) {
                                    max = val;
                                }
                                if (val < min) {
                                    min = val;
                                }
                            }
                            ++j;
                        }
                        ++i;
                    }
                    if (max == Integer.MAX_VALUE) {
                        return -9999;
                    }
                    if (-min > max) {
                        return min;
                    }
                    return max;
                }
            }
            return -9999;
        }
    }
}

