/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.reports;

import edu.uml.giro.gambit.core.GambitConstants;
import edu.uml.giro.gambit.core.LocalData;
import edu.uml.giro.gambit.core.LocalDataOneSiteAllTimes;
import edu.uml.giro.gambit.core.LocalDataType;
import edu.uml.giro.gambit.display.GambitChartSettings;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;

public class SiteDataExporter {
    public static LinkedHashMap<String, Double> items = new LinkedHashMap();

    public static void exportOneTimeOneCharAllSites(LocalData localData, TimeScale toTime, String subfolder, GambitChartSettings settings, boolean localWeatherAvailable) {
        int totalSites = localData.totalLocations;
        int iSite = 0;
        while (iSite < totalSites) {
            items.clear();
            LocalDataOneSiteAllTimes site = localData.sites[iSite];
            SiteDataExporter.putOneDataItem(items, LocalDataType.CONFIDENCE_SCORE, site.getDataCell(toTime).getConfidenceScore());
            SiteDataExporter.putOneDataItem(items, LocalDataType.FLAG, site.getDataCell(toTime).getFlag());
            SiteDataExporter.putOneDataItem(items, LocalDataType.ALL_OBSERVED_RAW, site.getDataCell(toTime).getRawObservation());
            SiteDataExporter.putOneDataItem(items, LocalDataType.ALL_OBSERVED_PROCESSED, site.getDataCell(toTime).getObservation());
            SiteDataExporter.putOneDataItem(items, LocalDataType.CLIMATE, site.getDataCell(toTime).getClimate());
            if (localWeatherAvailable) {
                SiteDataExporter.putOneDataItem(items, LocalDataType.LOCAL_WEATHER, site.getDataCell(toTime).getLocalWeather());
            }
            SiteDataExporter.putOneDataItem(items, LocalDataType.GLOBAL_WEATHER, site.getDataCell(toTime).getGlobalWeather());
            SiteDataExporter.putOneDataItem(items, LocalDataType.O2C_DIFFERENCE, site.getDataCell(toTime).getO2C());
            if (localWeatherAvailable) {
                SiteDataExporter.putOneDataItem(items, LocalDataType.O2LW_DIFFERENCE, site.getDataCell(toTime).getO2LW());
            }
            SiteDataExporter.putOneDataItem(items, LocalDataType.O2GW_DIFFERENCE, site.getDataCell(toTime).getO2GW());
            String filename = String.valueOf(GambitConstants.OUTPUT_FOLDER) + subfolder + File.separator + site.getLocation().getUrsi() + "_" + site.getLocation().getName() + "_" + localData.getCharChoice().getName() + ".dat";
            SiteDataExporter.appendOneItemSet(filename, toTime);
            ++iSite;
        }
        System.out.println(String.valueOf(localData.getCharChoice().getName()) + " export done.");
    }

    private static void putOneDataItem(LinkedHashMap<String, Double> items2, LocalDataType attr, Object value) {
        if (value == null) {
            items2.put(attr.getColumnLabel(), 9999.0);
            return;
        }
        if (value instanceof Integer) {
            double d = ((Integer)value).doubleValue();
            items2.put(attr.getColumnLabel(), d);
        } else {
            items2.put(attr.getColumnLabel(), (Double)value);
        }
    }

    public static void appendOneItemSet(String filename, TimeScale toTime) {
        try (PrintWriter writer = null;){
            try {
                File f = new File(filename);
                boolean newFIle = !f.exists();
                writer = new PrintWriter(new FileOutputStream(f, true));
                if (newFIle) {
                    writer.write("# GLOBAL IONOSPHERE RADIO OBSERVATORY (G.I.R.O.)\n# giro.uml.edu\n#\n# IRI-based Real-Time Assimilative Model (IRTAM)\n#\n");
                    writer.write("# FULL SITE DATA EXPORT to " + filename + "\n# produced by " + "GX.User 1.3E" + " on " + new TimeScale().toFormatISO8601() + "\n#\n");
                    writer.write("# Observed values are commonly accompanied by a confidence score (CS) ranging from 0 (lowest) to 100 (best autoscaled) and 999 (manual scaling)\n");
                    writer.write("# When CS is provided, only high confidence values with CS of 80+ are directly accepted to assimilation; others are considered for replacement with interpolated values\n");
                    writer.write("# Status flag indicators are: \n # +1 observed value accepted as is; +2 interpolated missing value, +4 interpolated poor value, +8 interpolated at boundary, +16 forecast\n#\n");
                    String dataHeader = "yyyyMMdd_HH:mm ";
                    for (String label : items.keySet()) {
                        dataHeader = String.valueOf(dataHeader) + label + " ";
                    }
                    writer.write(String.valueOf(dataHeader) + System.lineSeparator());
                }
                String line = String.valueOf(toTime.toFormatUT("yyyyMMdd_HH:mm")) + " ";
                line = String.valueOf(toTime.toFormatUT("yyyyMMdd_HH:mm")) + " ";
                for (Map.Entry<String, Double> entry : items.entrySet()) {
                    double value = entry.getValue();
                    String label = entry.getKey();
                    int width = label.length();
                    line = label.equals(LocalDataType.CONFIDENCE_SCORE.getColumnLabel()) || label.equals(LocalDataType.FLAG.getColumnLabel()) ? String.valueOf(line) + FC.IntegerToString((int)value, width) + " " : String.valueOf(line) + (value != 9999.0 ? FC.DoubleToString(value, width, 2) : String.valueOf(FC.nC2S(' ', width - 1)) + "0") + " ";
                }
                writer.write(String.valueOf(line) + System.lineSeparator());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    public static void exportLocalWeatherAllSites(LocalData localData, TimeScale toTime, String subfolder, boolean localWeatherAvailable) {
        int totalSites = localData.totalLocations;
        int iSite = 0;
        while (iSite < totalSites) {
            LocalDataOneSiteAllTimes site = localData.sites[iSite];
            double[] weatherCoefs = site.getLocalWeatherCoefs();
            double[] climateCoefs = site.getLocalClimateCoefs();
            if (weatherCoefs == null) {
                Console.showError("Export of local weather coefficients: data not available in this database");
                return;
            }
            String filename = String.valueOf(GambitConstants.OUTPUT_FOLDER) + subfolder + File.separator + site.getLocation().getUrsi() + "_" + site.getLocation().getName() + "_" + localData.getCharChoice().getName() + ".dat";
            SiteDataExporter.appendOneCoefSet(filename, toTime, weatherCoefs, climateCoefs);
            ++iSite;
        }
        System.out.println(String.valueOf(localData.getCharChoice().getName()) + " export done.");
    }

    public static void appendOneCoefSet(String filename, TimeScale toTime, double[] c1, double[] c2) {
        try (PrintWriter writer = null;){
            try {
                int i;
                File f = new File(filename);
                boolean newFIle = !f.exists();
                writer = new PrintWriter(new FileOutputStream(f, true));
                if (newFIle) {
                    writer.write("# GLOBAL IONOSPHERE RADIO OBSERVATORY (G.I.R.O.)\n# giro.uml.edu\n#\n# IRI-based Real-Time Assimilative Model (IRTAM)\n#\n");
                    writer.write("# FULL LOCAL WEATHER EXPORT\n# Output to: " + filename + "\n# produced by " + "GX.User 1.3E" + " on " + new TimeScale().toFormatISO8601() + "\n#\n");
                    String header2 = "";
                    i = 1;
                    while (i <= c1.length) {
                        header2 = String.valueOf(header2) + FC.IntegerToString(i, 2, '0') + "------ ";
                        ++i;
                    }
                    int headerLen = header2.length();
                    String incerpt = "LOCAL-WEATHER";
                    String onearm = new String(new char[headerLen / 2 - incerpt.length() / 2 - 2]).replace("\u0000", "=");
                    String header1 = new String(new char["yyyyMMdd_HH:mm ".length()]).replace("\u0000", " ");
                    header1 = String.valueOf(header1) + onearm + " " + incerpt + " " + onearm + " ";
                    if (c2 != null) {
                        int i2 = 1;
                        while (i2 <= c2.length) {
                            header2 = String.valueOf(header2) + FC.IntegerToString(i2, 2, '0') + "------ ";
                            ++i2;
                        }
                        headerLen = header2.length() - headerLen - 1;
                        incerpt = "LOCAL-CLIMATE";
                        onearm = new String(new char[headerLen / 2 - incerpt.length() / 2 - 2]).replace("\u0000", "=");
                        header1 = String.valueOf(header1) + onearm + " " + incerpt + " " + onearm;
                        writer.write(String.valueOf(header1) + System.lineSeparator());
                    }
                    writer.write("yyyyMMdd_HH:mm " + header2 + System.lineSeparator());
                }
                String line = String.valueOf(toTime.toFormatUT("yyyyMMdd_HH:mm")) + " ";
                line = String.valueOf(toTime.toFormatUT("yyyyMMdd_HH:mm")) + " ";
                i = 0;
                while (i < c1.length) {
                    line = String.valueOf(line) + FC.DoubleToString(c1[i], 8, 4) + " ";
                    ++i;
                }
                if (c2 != null) {
                    i = 0;
                    while (i < c2.length) {
                        line = String.valueOf(line) + FC.DoubleToString(c2[i], 8, 4) + " ";
                        ++i;
                    }
                }
                writer.write(String.valueOf(line) + System.lineSeparator());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }
}

