/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.reports;

import edu.uml.giro.gambit.core.Core;
import edu.uml.giro.gambit.core.GambitConstants;
import edu.uml.giro.gambit.core.GambitCore;
import edu.uml.giro.gambit.core.IonogramScaling;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.Geopack;
import edu.uml.lgdc.geospace.GroundSolar;
import edu.uml.lgdc.geospace.TimeGrid;
import edu.uml.lgdc.time.TimeScale;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import java.util.TreeMap;

public class Statistics {
    public static final int MAX_SITES = 150;
    public static final int TIMESTEPS_BEFORE_RESET = 3;
    public static final int TOTAL_AVER_INDEXES = 8;
    public static final int RTAM_SQRSUM = 0;
    public static final int IRI_SQRSUM = 1;
    public static final int RTAM_ABSSUM = 2;
    public static final int IRI_ABSSUM = 3;
    public static final int RTAM_SUM = 4;
    public static final int IRI_SUM = 5;
    public static final int IRI_TOTAL_POINTS = 6;
    public static final int RTAM_TOTAL_POINTS = 7;
    public static final int TOTAL_COLLECT_INDEXES = 7;
    public static final int LAT = 0;
    public static final int LON = 1;
    public static final int OBS = 2;
    public static final int RTAM = 3;
    public static final int IRI = 4;
    public static final int CONF = 5;
    public static final int PRESENCE = 6;
    public static final int TOTAL_SLIDING_AVER_INDEXES = 4;
    public static final int SUM_24H = 0;
    public static final int LAST_24H = 1;
    public static final int MAX_CURR = 2;
    public static final int MAX_PREV = 3;
    public static final int ERROR_SUM = 0;
    public static final int TOTAL_POINTS = 1;
    public static final int MEAN_IRTAM = 0;
    public static final int MEAN_IRI = 1;
    public static final int SDO_IRTAM = 2;
    public static final int SDO_IRI = 3;
    public static final int BACKCAST_HOURS = 7;
    public static final int POS = 0;
    public static final int NEG = 1;
    public static final int START = 0;
    public static final int END = 1;
    public static final int NUM_LAT_REGIONS = 3;
    public static final int NUM_SEASONS = 4;
    public static final TimeScale[] SEASON = new TimeScale[]{new TimeScale(0, 2, 22, 0, 0, 0), new TimeScale(0, 5, 22, 0, 0, 0), new TimeScale(0, 8, 22, 0, 0, 0), new TimeScale(0, 11, 22, 0, 0, 0)};
    public static final double[] SEASON_MINUTE = new double[]{SEASON[0].getTimeInMinutes(), SEASON[1].getTimeInMinutes(), SEASON[2].getTimeInMinutes(), SEASON[3].getTimeInMinutes()};
    public static final double HALF_SEASON_MINUTES = 65743.65;
    private Geopack gp = new Geopack();
    private TreeMap<String, Integer> locations = new TreeMap();
    private TreeMap<String, double[]> coords = new TreeMap();
    public double[][][][][] averageError;
    public double[][][][][] averageErrorManual;
    public double[][][][][] averageErrorControl;
    public double[][][] errors;
    private int[][][][] histogramIRTAM;
    private int[][][][] histogramIRI;
    private int[][][][] histogramIRTAM_IRI;
    public double[][][][] backcast;
    public double[][][][][] sunset;
    public double[][][][][] sunrise;
    public double[][][][][] sunset_now;
    public double[][][][][] sunrise_now;
    double[][][][][] ltStat;
    double[][][][][] ltStat_regions;
    public double[][][] average24Hours;
    private TimeScale[][][] intervals;
    public TimeScale[][] timeUpdated;
    private int numChars;
    private int errorRangeNumBins;
    private double[] errorRangeSteps;
    private int[] nTimeSteps;
    private int[] timeSteps;
    private static GambitCore gambitCore;

    public Statistics(Core core, int numChars, int errorRangeNumBins, double[] errorRangeSteps, int[] nTimeSteps) {
        this.averageError = new double[numChars][150][7][8][2];
        this.averageErrorManual = new double[numChars][150][7][8][2];
        this.averageErrorControl = new double[numChars][150][7][8][2];
        this.errors = new double[numChars][150][7];
        this.histogramIRTAM = new int[numChars][150][7][errorRangeNumBins];
        this.histogramIRI = new int[numChars][150][7][errorRangeNumBins];
        this.histogramIRTAM_IRI = new int[numChars][150][7][errorRangeNumBins];
        this.backcast = new double[numChars][150][][];
        this.sunset = new double[numChars][150][][][];
        this.sunrise = new double[numChars][150][][][];
        this.sunset_now = new double[numChars][150][][][];
        this.sunrise_now = new double[numChars][150][][][];
        this.ltStat = new double[numChars][150][][][];
        this.ltStat_regions = new double[numChars][3][][][];
        this.average24Hours = new double[numChars][150][4];
        this.intervals = new TimeScale[numChars][150][2];
        this.timeUpdated = new TimeScale[numChars][150];
        this.numChars = numChars;
        this.errorRangeNumBins = errorRangeNumBins;
        if (errorRangeNumBins % 2 != 1) {
            throw new RuntimeException("Check number of bins for IRTAM error range diagram. Should be odd.");
        }
        this.errorRangeSteps = new double[this.numChars];
        this.nTimeSteps = new int[this.numChars];
        this.timeSteps = new int[this.numChars];
        gambitCore = (GambitCore)core;
        int i = 0;
        while (i < numChars) {
            this.errorRangeSteps[i] = errorRangeSteps[i];
            this.nTimeSteps[i] = nTimeSteps[i];
            this.timeSteps[i] = 1440 / this.nTimeSteps[i];
            int j = 0;
            while (j < 150) {
                this.backcast[i][j] = new double[nTimeSteps[i]][2];
                this.sunset[i][j] = new double[nTimeSteps[i]][8][2];
                this.sunrise[i][j] = new double[nTimeSteps[i]][8][2];
                this.sunset_now[i][j] = new double[nTimeSteps[i]][8][2];
                this.sunrise_now[i][j] = new double[nTimeSteps[i]][8][2];
                this.ltStat[i][j] = new double[nTimeSteps[i]][8][2];
                ++j;
            }
            int k = 0;
            while (k < 3) {
                this.ltStat_regions[i][k] = new double[nTimeSteps[i]][8][2];
                ++k;
            }
            ++i;
        }
    }

    public int getSitesInd(String ursi, double lat, double lon, TimeScale ut) {
        if (!this.locations.containsKey(ursi)) {
            if (this.locations.size() == 149) {
                throw new RuntimeException("Increase capacity of statistics arrays");
            }
            this.locations.put(ursi, this.locations.size());
            double[] latlon = new double[]{lat, lon};
            double[] m_latlon = this.gp.getMagneticCoordinates(latlon, ut);
            this.coords.put(ursi, new double[]{latlon[0], latlon[1], m_latlon[0], m_latlon[1]});
        }
        return this.locations.get(ursi);
    }

    public void updateCoords_magnetic(TimeScale ut) {
        for (String ursi : this.coords.keySet()) {
            double[] ll = this.coords.get(ursi);
            double[] latlon = new double[]{ll[0], ll[0]};
            double[] m_latlon = this.gp.getMagneticCoordinates(latlon, ut);
            this.coords.put(ursi, new double[]{latlon[0], latlon[1], m_latlon[0], m_latlon[1]});
        }
    }

    private static void updateAverageErrors(double[][] average, double obs, double irtam, double iri) {
        double eI = obs - iri;
        double eR = obs - irtam;
        int indI = eI > 0.0 ? 0 : 1;
        int indR = eR > 0.0 ? 0 : 1;
        double[] dArray = average[2];
        int n = indR;
        dArray[n] = dArray[n] + Math.abs(eR);
        double[] dArray2 = average[0];
        int n2 = indR;
        dArray2[n2] = dArray2[n2] + Math.pow(eR, 2.0);
        double[] dArray3 = average[4];
        int n3 = indR;
        dArray3[n3] = dArray3[n3] + eR;
        double[] dArray4 = average[7];
        int n4 = indR;
        dArray4[n4] = dArray4[n4] + 1.0;
        double[] dArray5 = average[3];
        int n5 = indI;
        dArray5[n5] = dArray5[n5] + Math.abs(eI);
        double[] dArray6 = average[1];
        int n6 = indI;
        dArray6[n6] = dArray6[n6] + Math.pow(eI, 2.0);
        double[] dArray7 = average[5];
        int n7 = indI;
        dArray7[n7] = dArray7[n7] + eI;
        double[] dArray8 = average[6];
        int n8 = indI;
        dArray8[n8] = dArray8[n8] + 1.0;
    }

    public void updateAverageErrors(double[][][][][] statData, int iChar, int siteIndex, int backcastSteps, double obs, double irtam, double iri) {
        Statistics.updateAverageErrors(statData[iChar][siteIndex][backcastSteps], obs, irtam, iri);
        Statistics.updateAverageErrors(statData[iChar][149][backcastSteps], obs, irtam, iri);
    }

    public void updateLTStat(int iChar, int siteIndex, String ursi, TimeScale ut, double obs, double irtam, double iri) {
        TimeScale lt = TimeScale.getLocalMeanTime(this.coords.get(ursi)[1], ut);
        int timeStep = gambitCore.getLocalData(CharChoice.FOF2).getTimeGrid().getTimeStep_min();
        int phase = (int)(lt.getTimeSinceMidnightIn(12) / (double)timeStep);
        Statistics.updateAverageErrors(this.ltStat[iChar][siteIndex][phase], obs, irtam, iri);
        Statistics.updateAverageErrors(this.ltStat[iChar][149][phase], obs, irtam, iri);
    }

    public void updateLTStat_regions(int iChar, String ursi, TimeScale ut, double obs, double irtam, double iri) {
        int region = 0;
        int MAGNETIC_LAT = 2;
        double mlat = this.coords.get(ursi)[2];
        region = Math.abs(mlat) <= 20.0 ? 0 : (Math.abs(mlat) <= 60.0 ? 1 : 2);
        TimeScale lt = TimeScale.getLocalMeanTime(this.coords.get(ursi)[1], ut);
        int timeStep = gambitCore.getLocalData(CharChoice.FOF2).getTimeGrid().getTimeStep_min();
        int phase = (int)(lt.getTimeSinceMidnightIn(12) / (double)timeStep);
        Statistics.updateAverageErrors(this.ltStat_regions[iChar][region][phase], obs, irtam, iri);
    }

    public void updateData(int iChar, int siteIndex, double iri, double rtam, double obs, double conf, double lat, double lon) {
        this.errors[iChar][siteIndex][0] = lat;
        this.errors[iChar][siteIndex][1] = lon;
        this.errors[iChar][siteIndex][2] = obs;
        this.errors[iChar][siteIndex][4] = iri;
        this.errors[iChar][siteIndex][3] = rtam;
        this.errors[iChar][siteIndex][5] = conf;
        this.errors[iChar][siteIndex][6] = 1.0;
    }

    public void updateHistogram(int iChar, int siteIndex, int i, double obs, double weather, double climate) {
        this.updateHistogram(this.histogramIRTAM, iChar, siteIndex, i, obs - weather);
        this.updateHistogram(this.histogramIRI, iChar, siteIndex, i, obs - climate);
        this.updateHistogram(this.histogramIRTAM_IRI, iChar, siteIndex, i, weather - climate);
    }

    private void updateHistogram(int[][][][] histogram, int iChar, int siteIndex, int i, double val) {
        int iBin = (int)Math.round(val / GambitConstants.ERROR_RANGE_STEP[iChar]);
        if ((iBin += 30) >= 0 && iBin < 61) {
            int[] nArray = histogram[iChar][149][i];
            int n = iBin;
            nArray[n] = nArray[n] + 1;
            int[] nArray2 = histogram[iChar][siteIndex][i];
            int n2 = iBin;
            nArray2[n2] = nArray2[n2] + 1;
        }
    }

    public void updateSlidingAverage(TimeScale time, int charIndex, String ursi, double rtamError, double rtamError24H, double iriError, double rtamValue, double iriValue, int confidence, String subfolder) {
        String folder = String.valueOf(GambitConstants.OUTPUT_FOLDER) + subfolder;
        int siteIndex = this.locations.get(ursi);
        double[] dArray = this.average24Hours[charIndex][siteIndex];
        dArray[0] = dArray[0] + (Math.abs(rtamError) - this.average24Hours[charIndex][siteIndex][1]);
        this.average24Hours[charIndex][siteIndex][1] = Math.abs(rtamError24H);
        this.average24Hours[charIndex][siteIndex][2] = Math.max(this.average24Hours[charIndex][siteIndex][2], Math.abs(rtamError));
        double averageError24H = this.average24Hours[charIndex][siteIndex][0] / (double)this.nTimeSteps[charIndex];
        this.timeUpdated[charIndex][siteIndex] = (TimeScale)time.clone();
        if (averageError24H > GambitConstants.AVERAGE_ERRORS[charIndex]) {
            String filename;
            TimeScale startTime = new TimeScale(time.getTimeInMinutes() - 1440.0);
            if (this.intervals[charIndex][siteIndex][0] == null) {
                this.intervals[charIndex][siteIndex][0] = startTime;
            }
            if (this.average24Hours[charIndex][siteIndex][3] == 0.0) {
                this.average24Hours[charIndex][siteIndex][3] = this.average24Hours[charIndex][siteIndex][2];
            }
            if (this.intervals[charIndex][siteIndex][1] == null) {
                this.intervals[charIndex][siteIndex][1] = (TimeScale)time.clone();
            }
            if (this.intervals[charIndex][siteIndex][1].after(startTime)) {
                this.intervals[charIndex][siteIndex][1] = (TimeScale)time.clone();
                this.average24Hours[charIndex][siteIndex][3] = Math.max(this.average24Hours[charIndex][siteIndex][2], this.average24Hours[charIndex][siteIndex][3]);
                this.average24Hours[charIndex][siteIndex][2] = 0.0;
            } else {
                try {
                    filename = String.valueOf(folder) + "BigErrorsCollector_" + CharChoice.getByIndex(charIndex).getName() + "_" + ursi + ".txt";
                    this.writeSlidingAverage(filename, charIndex, siteIndex, ursi);
                    filename = String.valueOf(folder) + "BigErrorsCollector_" + CharChoice.getByIndex(charIndex).getName() + ".txt";
                    this.writeSlidingAverage(filename, charIndex, siteIndex, ursi);
                    this.intervals[charIndex][siteIndex][0] = startTime;
                    this.intervals[charIndex][siteIndex][1] = (TimeScale)time.clone();
                    this.average24Hours[charIndex][siteIndex][3] = this.average24Hours[charIndex][siteIndex][2];
                    this.average24Hours[charIndex][siteIndex][2] = 0.0;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                filename = String.valueOf(folder) + "BigErrorsTimes_" + CharChoice.getByIndex(charIndex).getName() + "_" + ursi + ".txt";
                this.writeTimes(filename, ursi, time, rtamError, iriError, rtamValue, iriValue, confidence);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.intervals[charIndex][siteIndex][1] != null && (this.intervals[charIndex][siteIndex][1].getTimeInMinutes() - this.intervals[charIndex][siteIndex][0].getTimeInMinutes() > 43200.0 || averageError24H < GambitConstants.AVERAGE_ERRORS[charIndex] && this.intervals[charIndex][siteIndex][1].before(new TimeScale(time.getTimeInMillis() - 86400000L)))) {
            try {
                String filename = String.valueOf(folder) + "BigErrorsCollector_" + CharChoice.getByIndex(charIndex).getName() + "_" + ursi + ".txt";
                this.writeSlidingAverage(filename, charIndex, siteIndex, ursi);
                filename = String.valueOf(folder) + "BigErrorsCollector_" + CharChoice.getByIndex(charIndex).getName() + ".txt";
                this.writeSlidingAverage(filename, charIndex, siteIndex, ursi);
                this.intervals[charIndex][siteIndex][0] = null;
                this.intervals[charIndex][siteIndex][1] = null;
                this.average24Hours[charIndex][siteIndex][3] = 0.0;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateBackcastStatistic(double[] rtamErrors, int nowPhase, int charIndex, int siteIndexStat) {
        int numTimes = rtamErrors.length;
        int iTime = 0;
        while (iTime < numTimes) {
            int backcastIndex = nowPhase - iTime;
            backcastIndex = (backcastIndex + numTimes) % numTimes;
            double[] dArray = this.backcast[charIndex][149][backcastIndex];
            dArray[0] = dArray[0] + Math.abs(rtamErrors[iTime]);
            double[] dArray2 = this.backcast[charIndex][siteIndexStat][backcastIndex];
            dArray2[0] = dArray2[0] + Math.abs(rtamErrors[iTime]);
            double[] dArray3 = this.backcast[charIndex][149][backcastIndex];
            dArray3[1] = dArray3[1] + 1.0;
            double[] dArray4 = this.backcast[charIndex][siteIndexStat][backcastIndex];
            dArray4[1] = dArray4[1] + 1.0;
            ++iTime;
        }
    }

    public void updateSunsetSunrise(double[][][][][] sunset_sunrise, int iChar, int iSite, int iOffest, double obs, double irtam, double iri) {
        Statistics.updateAverageErrors(sunset_sunrise[iChar][iSite][iOffest], obs, irtam, iri);
        Statistics.updateAverageErrors(sunset_sunrise[iChar][149][iOffest], obs, irtam, iri);
    }

    public void writeStatistics2File(CharChoice cc, TimeScale startTime, TimeScale endTime, String subfolder) {
        int charIndex = cc.getIndex();
        String filename = "";
        String header = "";
        this.recordAverageError(this.averageError, charIndex, startTime, endTime, subfolder);
        this.recordAverageError(this.averageErrorManual, charIndex, startTime, endTime, subfolder);
        this.recordAverageError(this.averageErrorControl, charIndex, startTime, endTime, subfolder);
        this.recordLTStat_regions(charIndex, subfolder);
        this.recordLTStat(charIndex, subfolder);
        this.recordHistogram(charIndex, startTime, endTime, subfolder);
        String folder = String.valueOf(GambitConstants.OUTPUT_FOLDER) + subfolder;
        try {
            filename = String.valueOf(folder) + "BackcastDiagram_" + cc.getName() + ".txt";
            header = "Backcast error diagram from " + startTime.toHumanUT() + " to " + endTime.toHumanUT();
            this.writeBackcastStatistics(filename, header, charIndex);
        }
        catch (IOException ex) {
            System.out.println(" Problem opening/closing file " + filename);
            ex.printStackTrace();
        }
        this.recordSunsetSinriseStatistics(this.sunset, charIndex, startTime, endTime, subfolder);
        this.recordSunsetSinriseStatistics(this.sunrise, charIndex, startTime, endTime, subfolder);
        this.recordSunsetSinriseStatistics(this.sunset_now, charIndex, startTime, endTime, subfolder);
        this.recordSunsetSinriseStatistics(this.sunrise_now, charIndex, startTime, endTime, subfolder);
    }

    private void recordAverageError(double[][][][][] average, int charIndex, TimeScale startTime, TimeScale endTime, String subfolder) {
        String filename = "";
        String header = "";
        String pref = "";
        Set<String> keys = this.locations.keySet();
        if (average == this.averageError) {
            pref = "AverageErrors_";
        } else if (average == this.averageErrorManual) {
            pref = "ManualAverageErrors_";
        } else if (average == this.averageErrorControl) {
            pref = "ControlAverageErrors_";
        } else {
            throw new RuntimeException("Unknown average error array.");
        }
        String folder = String.valueOf(GambitConstants.OUTPUT_FOLDER) + subfolder;
        try {
            int i = 0;
            while (i < 7) {
                filename = String.valueOf(folder) + pref + CharChoice.getByIndex(charIndex).getName() + "_bc" + i + ".txt";
                header = "Statistics for period from " + startTime.toHumanUT() + " to " + endTime.toHumanUT() + " and " + i + " backcast hours" + "\nAll errors (E) are assumed average for all stations for whole period";
                Statistics.writeAverageError(average[charIndex][149][i], filename, header);
                for (String ursi : keys) {
                    int siteIndex = this.locations.get(ursi);
                    filename = String.valueOf(folder) + pref + CharChoice.getByIndex(charIndex).getName() + "_" + ursi + "_bc" + i + ".txt";
                    header = "Statistics for period from " + startTime.toHumanUT() + " to " + endTime.toHumanUT() + " for site " + ursi + " and " + i + " backcast hours" + "\nAll errors (E) are assumed average for all stations for whole period";
                    Statistics.writeAverageError(average[charIndex][siteIndex][i], filename, header);
                }
                ++i;
            }
        }
        catch (IOException ex) {
            System.out.println(" Problem opening/closing file " + filename);
            ex.printStackTrace();
        }
        try {
            int i = 0;
            while (i < 7) {
                filename = String.valueOf(folder) + pref + "AllSites_" + CharChoice.getByIndex(charIndex).getName() + "_bc" + i + ".txt";
                header = "Statistics for period from " + startTime.toHumanUT() + " to " + endTime.toHumanUT() + " and " + i + " backcast hours" + "\nAll errors (E) are assumed average for all stations for whole period";
                this.writeAllStationsOneFile(average, filename, header, charIndex, i);
                ++i;
            }
        }
        catch (IOException ex) {
            System.out.println(" Problem opening/closing file " + filename);
            ex.printStackTrace();
        }
    }

    private static void writeAverageError(double[][] average, String filename, String header) throws IOException {
        if (average[6][0] + average[6][1] != average[7][0] + average[7][1]) {
            throw new RuntimeException("Check average error total points");
        }
        PrintWriter writer = new PrintWriter(filename);
        writer.write(String.valueOf(header) + "\n");
        double IRIAbsSum = average[3][0] + average[3][1];
        double IRISqrSum = average[1][0] + average[1][1];
        double RTAMAbsSum = average[2][0] + average[2][1];
        double RTAMSqrSum = average[0][0] + average[0][1];
        double totalPoints = average[7][0] + average[7][1];
        double IRISum = average[5][0] + average[5][1];
        double RTAMSum = average[4][0] + average[4][1];
        writer.write("abs: Eiri = " + FC.DoubleToString(IRIAbsSum / totalPoints, 10, 4) + "    Ertam = " + FC.DoubleToString(RTAMAbsSum / totalPoints, 10, 4) + "\n");
        writer.write("sqr: Eiri = " + FC.DoubleToString(IRISqrSum / totalPoints, 10, 4) + "    Ertam = " + FC.DoubleToString(RTAMSqrSum / totalPoints, 10, 4) + "\n");
        writer.write("Total data point into analysis: " + FC.IntegerToString((int)totalPoints, 9) + "\n");
        writer.write("abs: (Eiri-Ertam)/Ertam = " + FC.DoubleToString((IRIAbsSum - RTAMAbsSum) / RTAMAbsSum, 7, 4) + "\n");
        writer.write("abs: (Eiri-Ertam)/Eiri = " + FC.DoubleToString((IRIAbsSum - RTAMAbsSum) / IRIAbsSum, 7, 4) + "\n");
        writer.write("abs: (Eiri-Ertam)/(0.5(Eiri+Ertam)) = " + FC.DoubleToString(2.0 * (IRIAbsSum - RTAMAbsSum) / (IRIAbsSum + RTAMAbsSum), 7, 4) + "\n");
        writer.write("abs: (Eiri/Ertam) = " + FC.DoubleToString(IRIAbsSum / RTAMAbsSum, 7, 4) + "\n");
        writer.write("sqr: (Eiri-Ertam)/Ertam = " + FC.DoubleToString((IRISqrSum - RTAMSqrSum) / RTAMSqrSum, 7, 4) + "\n");
        writer.write("sqr: (Eiri-Ertam)/Eiri = " + FC.DoubleToString((IRISqrSum - RTAMSqrSum) / IRISqrSum, 7, 4) + "\n");
        writer.write("sqr: (Eiri-Ertam)/(0.5(Eiri+Ertam)) = " + FC.DoubleToString(2.0 * (IRISqrSum - RTAMSqrSum) / (IRISqrSum + RTAMSqrSum), 7, 4) + "\n");
        writer.write("sqr: SQRT(Eiri/Ertam) = " + FC.DoubleToString(Math.sqrt(IRISqrSum / RTAMSqrSum), 7, 4) + "\n");
        writer.write("mean: Eiri = " + FC.DoubleToString(IRISum / totalPoints, 16, 4) + "\n");
        writer.write("mean: Ertam = " + FC.DoubleToString(RTAMSum / totalPoints, 16, 4) + "\n");
        writer.close();
    }

    private void recordLTStat_regions(int charIndex, String subfolder) {
        int r = 0;
        while (r < 3) {
            try {
                this.writeLTStat(this.ltStat_regions[charIndex], CharChoice.getByIndex(charIndex).getName(), null, subfolder, r, -1);
                this.writeLTStat(this.ltStat_regions[charIndex], CharChoice.getByIndex(charIndex).getName(), null, subfolder, r, 0);
                this.writeLTStat(this.ltStat_regions[charIndex], CharChoice.getByIndex(charIndex).getName(), null, subfolder, r, 1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++r;
        }
    }

    private void recordLTStat(int charIndex, String subfolder) {
        String chName = CharChoice.getByIndex(charIndex).getName();
        try {
            for (String ursi : this.locations.keySet()) {
                int siteIndex = this.locations.get(ursi);
                this.writeLTStat(this.ltStat[charIndex], chName, ursi, subfolder, siteIndex, -1, 4, 5);
            }
            this.writeLTStat(this.ltStat[charIndex], chName, "", subfolder, 149, -1, 4, 5);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeLTStat(double[][][][] ltStat, String charName, String ursi, String subfolder, int ind, int pos_neg) throws IOException {
        this.writeLTStat(ltStat, charName, ursi, subfolder, ind, pos_neg, 2, 3);
    }

    private void writeLTStat(double[][][][] ltStat, String charName, String ursi, String subfolder, int ind, int pos_neg, int statTypeIRTAM, int statTypeIRI) throws IOException {
        boolean pf = false;
        boolean nf = false;
        String pref = "LT_";
        if (pos_neg == 0) {
            pref = String.valueOf(pref) + "pos";
            pf = true;
        } else if (pos_neg == 1) {
            pref = String.valueOf(pref) + "neg";
            nf = true;
        } else {
            pref = String.valueOf(pref) + "total";
            pf = true;
            nf = true;
        }
        pref = String.valueOf(pref) + "_" + charName;
        pref = ursi == null ? String.valueOf(pref) + "_" + (ind == -1 ? "" : "" + ind) : String.valueOf(pref) + (ursi.equals("") ? "" : "_" + ursi);
        String folder = String.valueOf(GambitConstants.OUTPUT_FOLDER) + subfolder;
        PrintWriter writer = new PrintWriter(String.valueOf(folder) + pref + ".txt");
        writer.write("Phase          IRTAM            IRI         pIRTAM           pIRI\n");
        int totalDiurnalSteps = gambitCore.getLocalData(CharChoice.FOF2).getTimeGrid().getNumDiurnalSteps();
        int ph = 0;
        while (ph < totalDiurnalSteps) {
            double weather = (double)pf * ltStat[ind][ph][statTypeIRTAM][0] + (double)nf * ltStat[ind][ph][statTypeIRTAM][1];
            double climate = (double)pf * ltStat[ind][ph][statTypeIRI][0] + (double)nf * ltStat[ind][ph][statTypeIRI][1];
            writer.write(String.valueOf(FC.DoubleToString(ph, 5, 2)) + " " + FC.DoubleToString(weather, 14, 2) + " " + FC.DoubleToString(climate, 14, 2) + " " + FC.DoubleToString((double)pf * ltStat[ind][ph][7][0] + (double)nf * ltStat[ind][ph][7][1], 14, 0) + " " + FC.DoubleToString((double)pf * ltStat[ind][ph][6][0] + (double)nf * ltStat[ind][ph][6][1], 14, 0) + "\n");
            ++ph;
        }
        writer.close();
    }

    private void writeAllStationsOneFile(double[][][][][] average, String filename, String header, int charIndex, int i) throws IOException {
        PrintWriter writer = new PrintWriter(filename);
        writer.write(String.valueOf(header) + "\n");
        writer.write("URSI_code num eIRI_abs eRTAM_abs eIRI_sqr eRTAM_sqr Ratio_abs Ratio_sqr TotalPoints\n");
        Set<String> keys = this.locations.keySet();
        int totalSites = 0;
        for (String ursi : keys) {
            ++totalSites;
            int siteIndex = this.locations.get(ursi);
            double IRIAbsSum = average[charIndex][siteIndex][i][3][0] + average[charIndex][siteIndex][i][3][1];
            double IRISqrSum = average[charIndex][siteIndex][i][1][0] + average[charIndex][siteIndex][i][1][1];
            double RTAMAbsSum = average[charIndex][siteIndex][i][2][0] + average[charIndex][siteIndex][i][2][1];
            double RTAMSqrSum = average[charIndex][siteIndex][i][0][0] + average[charIndex][siteIndex][i][0][1];
            double totalPoints = average[charIndex][siteIndex][i][7][0] + average[charIndex][siteIndex][i][7][1];
            writer.write(String.valueOf(ursi) + "    " + " " + FC.IntegerToString(totalSites, 3) + " " + FC.DoubleToString(IRIAbsSum / totalPoints, 8, 2) + " " + " " + FC.DoubleToString(RTAMAbsSum / totalPoints, 8, 2) + " " + FC.DoubleToString(IRISqrSum / totalPoints, 8, 2) + " " + " " + FC.DoubleToString(RTAMSqrSum / totalPoints, 8, 2) + " " + " " + FC.DoubleToString(IRIAbsSum / RTAMAbsSum, 8, 2) + " " + " " + FC.DoubleToString(IRISqrSum / RTAMSqrSum, 8, 2) + " " + FC.DoubleToString(totalPoints, 11, 2) + "\n");
        }
        writer.close();
    }

    public void writeData(TimeScale time, String filename, int charIndex, String subfolder) throws IOException {
        boolean writeTitle = new File(filename).exists();
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(filename, true)));
        Set<String> keys = this.locations.keySet();
        if (writeTitle) {
            writer.write("                 UT  URSI_code    Lat    Lon      obs     rtam      iri  conf\n");
        }
        for (String ursi : keys) {
            int siteIndex = this.locations.get(ursi);
            if (this.errors[charIndex][siteIndex][6] == 1.0) {
                writer.write(String.valueOf(time.toHumanUT()) + "      " + ursi + " " + FC.DoubleToString(this.errors[charIndex][siteIndex][0], 6, 2) + " " + FC.DoubleToString(this.errors[charIndex][siteIndex][1], 6, 2) + " " + FC.DoubleToString(this.errors[charIndex][siteIndex][2], 8, 2) + " " + FC.DoubleToString(this.errors[charIndex][siteIndex][3], 8, 2) + " " + FC.DoubleToString(this.errors[charIndex][siteIndex][4], 8, 2) + " " + FC.DoubleToString(this.errors[charIndex][siteIndex][5], 5, 1) + "\n");
            }
            this.errors[charIndex][siteIndex][0] = 0.0;
            this.errors[charIndex][siteIndex][1] = 0.0;
            this.errors[charIndex][siteIndex][2] = 0.0;
            this.errors[charIndex][siteIndex][3] = 0.0;
            this.errors[charIndex][siteIndex][4] = 0.0;
            this.errors[charIndex][siteIndex][5] = 0.0;
            this.errors[charIndex][siteIndex][6] = 0.0;
        }
        writer.close();
    }

    private void recordHistogram(int charIndex, TimeScale startTime, TimeScale endTime, String subfolder) {
        String folder = String.valueOf(GambitConstants.OUTPUT_FOLDER) + subfolder;
        try {
            int i = 0;
            while (i < 7) {
                String filename = String.valueOf(folder) + "Histogram_" + CharChoice.getByIndex(charIndex).getName() + "_bc" + i + ".txt";
                String header = "Error range diagram from " + startTime.toHumanUT() + " to " + endTime.toHumanUT();
                this.writeHistogram(filename, header, charIndex, 149, i);
                ++i;
            }
            Set<String> keys = this.locations.keySet();
            for (String ursi : keys) {
                int siteIndex = this.locations.get(ursi);
                int i2 = 0;
                while (i2 < 7) {
                    String filename = String.valueOf(folder) + "Histogram_" + CharChoice.getByIndex(charIndex).getName() + "_" + ursi + "_bc" + i2 + ".txt";
                    String header = "Error range diagram for " + ursi + " from " + startTime.toHumanUT() + " to " + endTime.toHumanUT();
                    this.writeHistogram(filename, header, charIndex, siteIndex, i2);
                    ++i2;
                }
            }
        }
        catch (IOException ex) {
            System.out.println(" Problem opening/closing file ");
            ex.printStackTrace();
        }
    }

    private void writeHistogram(String filename, String header, int charIndex, int siteIndex, int i) throws IOException {
        PrintWriter writer = new PrintWriter(filename);
        writer.write(String.valueOf(header) + "\n");
        writer.write("  From     To Center  Count_Obs-IRTAM  Count_Obs-IRI Count_IRTAM-IRI\n");
        int iBin = 0;
        while (iBin < 61) {
            double centralValue = (double)(iBin - this.errorRangeNumBins / 2) * this.errorRangeSteps[charIndex];
            writer.write(String.valueOf(FC.DoubleToString(centralValue - this.errorRangeSteps[charIndex] / 2.0, 6, 2)) + " " + FC.DoubleToString(centralValue + this.errorRangeSteps[charIndex] / 2.0, 6, 2) + " " + FC.DoubleToString(centralValue, 6, 2) + "        " + FC.IntegerToString(this.histogramIRTAM[charIndex][siteIndex][i][iBin], 9) + "      " + FC.IntegerToString(this.histogramIRI[charIndex][siteIndex][i][iBin], 9) + "       " + FC.IntegerToString(this.histogramIRTAM_IRI[charIndex][siteIndex][i][iBin], 9) + "\n");
            ++iBin;
        }
        writer.close();
    }

    private void writeSlidingAverage(String filename, int charIndex, int siteIndex, String ursi) throws IOException {
        boolean writeTitle = new File(filename).exists();
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(filename, true)));
        if (writeTitle) {
            writer.write("URSI_code          start_time            end_time  num_days max_error\n");
        }
        double days = (this.intervals[charIndex][siteIndex][1].getTimeInMinutes() - this.intervals[charIndex][siteIndex][0].getTimeInMinutes()) / 60.0;
        writer.write(String.valueOf(ursi) + "     " + this.intervals[charIndex][siteIndex][0].toHumanUT() + " " + this.intervals[charIndex][siteIndex][1].toHumanUT() + " " + FC.DoubleToString(days, 9, 2) + " " + FC.DoubleToString(this.average24Hours[charIndex][siteIndex][3], 9, 2) + "\n");
        writer.close();
    }

    private void writeTimes(String filename, String ursi, TimeScale time, double rtamError, double iriError, double rtamValue, double iriValue, int confidence) throws IOException {
        boolean writeTitle = new File(filename).exists();
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(filename, true)));
        if (writeTitle) {
            writer.write("URSI_code                time rtam_error  iri_error rtam_value  iri_value conf\n");
        }
        writer.write(String.valueOf(ursi) + "     " + time.toHumanUT() + " " + FC.DoubleToString(rtamError, 10, 2) + " " + FC.DoubleToString(iriError, 10, 2) + " " + FC.DoubleToString(rtamValue, 10, 2) + " " + FC.DoubleToString(iriValue, 10, 2) + " " + FC.IntegerToString(confidence, 4) + "\n");
        writer.close();
    }

    private void writeBackcastStatistics(String filename, String header, int charIndex) throws IOException {
        PrintWriter writer = new PrintWriter(filename);
        writer.write(String.valueOf(header) + "\n");
        writer.write("backcast_time   hours     error\n");
        int iOffset = 0;
        while (iOffset < this.nTimeSteps[charIndex]) {
            int hour = iOffset * this.timeSteps[charIndex] / 60;
            int min = iOffset * this.timeSteps[charIndex] - hour * 60;
            writer.write("        " + FC.IntegerToString(hour, 2) + ":" + FC.IntegerToString(min, 2) + "  " + FC.DoubleToString((double)(-iOffset * this.timeSteps[charIndex]) / 60.0, 6, 2) + "        " + FC.DoubleToString(this.backcast[charIndex][149][iOffset][0] / this.backcast[charIndex][149][iOffset][1], 9, 4) + "\n");
            ++iOffset;
        }
        writer.close();
    }

    private void recordSunsetSinriseStatistics(double[][][][][] sunset_rise, int charIndex, TimeScale startTime, TimeScale endTime, String subfolder) {
        String filename = "";
        String header = "";
        String pref = "";
        Set<String> keys = this.locations.keySet();
        if (sunset_rise == this.sunrise) {
            pref = "Sunrise_";
        }
        if (sunset_rise == this.sunset) {
            pref = "Sunset_";
        }
        if (sunset_rise == this.sunrise_now) {
            pref = "SunriseNow_";
        }
        if (sunset_rise == this.sunset_now) {
            pref = "SunsetNow_";
        }
        try {
            filename = String.valueOf(GambitConstants.OUTPUT_FOLDER) + subfolder + pref + CharChoice.getByIndex(charIndex).getName() + ".txt";
            header = String.valueOf(pref) + "offset error diagram from " + startTime.toHumanUT() + " to " + endTime.toHumanUT();
            this.writeSunsetSinriseStatistics(sunset_rise, filename, header, charIndex, 149);
            for (String ursi : keys) {
                filename = String.valueOf(GambitConstants.OUTPUT_FOLDER) + subfolder + pref + CharChoice.getByIndex(charIndex).getName() + "_" + ursi + ".txt";
                header = String.valueOf(pref) + "offset error diagram from " + startTime.toHumanUT() + " to " + endTime.toHumanUT() + " for site " + ursi;
                this.writeSunsetSinriseStatistics(sunset_rise, filename, header, charIndex, this.locations.get(ursi));
            }
        }
        catch (IOException ex) {
            System.out.println(" Problem opening/closing file " + filename);
            ex.printStackTrace();
        }
    }

    private void writeSunsetSinriseStatistics(double[][][][][] sunset_rise, String filename, String header, int charIndex, int siteIndex) throws IOException {
        PrintWriter writer = new PrintWriter(filename);
        writer.write(String.valueOf(header) + "\n");
        writer.write("Time_after Steps_after rtamError+ iriError+ rtamError- iriError- rtamCount+ iriCount+ rtamCount- iriCount-\n");
        int iOffset = 0;
        while (iOffset < this.nTimeSteps[charIndex]) {
            int hour = iOffset * this.timeSteps[charIndex] / 60;
            int min = iOffset * this.timeSteps[charIndex] - hour * 60;
            double countPosIri = sunset_rise[charIndex][siteIndex][iOffset][6][0];
            double countNegIri = sunset_rise[charIndex][siteIndex][iOffset][6][1];
            double countPosRtam = sunset_rise[charIndex][siteIndex][iOffset][7][0];
            double countNegRtam = sunset_rise[charIndex][siteIndex][iOffset][7][1];
            writer.write("       " + FC.IntegerToString(iOffset, 3) + " " + FC.DoubleToString((double)hour + (double)min / 60.0, 11, 2) + " " + " " + FC.DoubleToString(sunset_rise[charIndex][siteIndex][iOffset][2][0] / countPosRtam, 9, 2) + " " + FC.DoubleToString(sunset_rise[charIndex][siteIndex][iOffset][3][0] / countPosIri, 9, 2) + " " + " " + FC.DoubleToString(-sunset_rise[charIndex][siteIndex][iOffset][2][1] / countNegRtam, 9, 2) + " " + FC.DoubleToString(-sunset_rise[charIndex][siteIndex][iOffset][3][1] / countNegIri, 9, 2) + " " + " " + FC.DoubleToString(countPosRtam, 9, 2) + " " + FC.DoubleToString(countPosIri, 9, 2) + " " + " " + FC.DoubleToString(countNegRtam, 9, 2) + " " + FC.DoubleToString(countNegIri, 9, 2) + "\n");
            ++iOffset;
        }
        writer.close();
    }

    public static void calculateMeanSDStat_file(String fileName, CharChoice cc, String subfolder) {
        File checkDir = new File(String.valueOf(GambitConstants.OUTPUT_FOLDER) + subfolder);
        if (!checkDir.exists()) {
            checkDir.mkdir();
        }
        double[] mean_sdo = new double[5];
        double[] data = new double[6];
        String line = null;
        try {
            int iter = 0;
            while (iter < 2) {
                BufferedReader br = new BufferedReader(new FileReader(fileName));
                br.readLine();
                line = br.readLine();
                String[] strs = line.trim().split(" ");
                TimeScale ut = new TimeScale(String.valueOf(strs[0]) + strs[1]);
                int month = ut.get(2);
                while (line != null) {
                    strs = line.trim().split(" ");
                    ut = new TimeScale(String.valueOf(strs[0]) + " " + strs[1]);
                    Statistics.parseLine(strs, data);
                    if (month != ut.get(2)) {
                        System.out.println(ut.toHumanUT());
                        month = ut.get(2);
                    }
                    if (iter == 0) {
                        mean_sdo[0] = mean_sdo[0] + (data[2] - data[3]);
                        mean_sdo[1] = mean_sdo[1] + (data[2] - data[4]);
                        mean_sdo[4] = mean_sdo[4] + 1.0;
                    } else if (iter == 1) {
                        mean_sdo[2] = mean_sdo[2] + Math.pow(mean_sdo[0] / mean_sdo[4] - (data[2] - data[3]), 2.0);
                        mean_sdo[3] = mean_sdo[3] + Math.pow(mean_sdo[1] / mean_sdo[4] - (data[2] - data[4]), 2.0);
                    }
                    line = br.readLine();
                }
                br.close();
                ++iter;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            PrintWriter writer = new PrintWriter(String.valueOf(GambitConstants.OUTPUT_FOLDER) + subfolder + cc.getName() + "_stat.txt");
            writer.write("MEAN IRTAM   " + FC.DoubleToString(mean_sdo[0] / mean_sdo[4], 14, 2) + "\n");
            writer.write("MEAN IRI     " + FC.DoubleToString(mean_sdo[1] / mean_sdo[4], 14, 2) + "\n");
            writer.write("SDO  IRTAM   " + FC.DoubleToString(Math.sqrt(mean_sdo[2] / mean_sdo[4]), 14, 2) + "\n");
            writer.write("SDO  IRI     " + FC.DoubleToString(Math.sqrt(mean_sdo[3] / mean_sdo[4]), 14, 2) + "\n");
            writer.write("Total points " + FC.DoubleToString(mean_sdo[4], 14, 2) + "\n");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void calculateStat_file(GambitCore gambitCore, String fileName, TimeScale[][] seTime, CharChoice cc, String subfolder) {
        File checkDir = new File(String.valueOf(GambitConstants.OUTPUT_FOLDER) + subfolder);
        if (!checkDir.exists()) {
            checkDir.mkdir();
        }
        TimeScale.checkTimeIntervals(seTime);
        String line = null;
        double[] data = new double[6];
        TimeGrid timeGrid = gambitCore.getLocalData(cc).getTimeGrid();
        int[] timeSteps = new int[]{timeGrid.getTimeStep_min(), timeGrid.getNumDiurnalSteps()};
        Statistics stat = new Statistics(gambitCore, CharChoice.SIZE, 61, GambitConstants.ERROR_RANGE_STEP, timeSteps);
        double[][] cycleStat = new double[8][2];
        double[][][] seasonStat = new double[4][8][2];
        try {
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            br.readLine();
            line = br.readLine();
            String[] strs = line.trim().split(" ");
            TimeScale ut = new TimeScale(String.valueOf(strs[0]) + strs[1]);
            TimeScale current_ut = null;
            TimeScale startTime = new TimeScale(String.valueOf(strs[0]) + strs[1]);
            int month = ut.get(2);
            boolean match = false;
            int timePeriod = 0;
            while (line != null) {
                strs = line.trim().split(" ");
                ut = new TimeScale(String.valueOf(strs[0]) + " " + strs[1]);
                if (current_ut == null || ut.equals(current_ut)) {
                    match = Statistics.isUTinPeriods(ut, seTime, timePeriod);
                }
                current_ut = (TimeScale)ut.clone();
                if (!match) {
                    line = br.readLine();
                    continue;
                }
                String ursi = Statistics.parseLine(strs, data);
                stat = Statistics.reportStatisticsPeriod(stat, cc, ut, ursi, data, timeSteps[0], timeSteps[1]);
                Statistics.updateAverageErrors(cycleStat, data[2], data[3], data[4]);
                Statistics.updateSeasonStat(seasonStat, ut, data[2], data[3], data[4]);
                line = br.readLine();
                if (month == ut.get(2) && line != null) continue;
                System.out.println(ut.toHumanUT());
                month = ut.get(2);
                stat.writeStatistics2File(cc, startTime, ut, subfolder);
                Statistics.writeSeasonStat(seasonStat, cc.getName(), subfolder);
                Statistics.writeSolarCycleStat(cycleStat, ut, cc.getName(), subfolder);
                int i = 0;
                while (i < cycleStat.length) {
                    int j = 0;
                    while (j < cycleStat[i].length) {
                        cycleStat[i][j] = 0.0;
                        ++j;
                    }
                    ++i;
                }
                stat.updateCoords_magnetic(ut);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Statistics reportStatisticsPeriod(Statistics stat, CharChoice cc, TimeScale ut, String ursi, double[] data, int timeStep, int numTimes) {
        int charIndex = cc.getIndex();
        int siteIndexStat = stat.getSitesInd(ursi, data[0], data[1], ut);
        TimeGrid timeGrid = gambitCore.getLocalData(cc).getTimeGrid();
        int nowPhase = timeGrid.findClosestTimeStep(ut);
        if (!IonogramScaling.isPoorQuality((int)data[5])) {
            stat.updateAverageErrors(stat.averageError, charIndex, siteIndexStat, 0, data[2], data[3], data[4]);
            stat.updateLTStat(charIndex, siteIndexStat, ursi, ut, data[2], data[3], data[4]);
            stat.updateLTStat_regions(charIndex, ursi, ut, data[2], data[3], data[4]);
        }
        if (IonogramScaling.isManual((int)data[5])) {
            stat.updateAverageErrors(stat.averageErrorManual, charIndex, siteIndexStat, 0, data[2], data[3], data[4]);
        }
        if (IonogramScaling.isManual((int)data[5])) {
            stat.updateHistogram(charIndex, siteIndexStat, 0, data[2], data[3], data[4]);
        }
        GroundSolar gs = new GroundSolar(data[0], data[1], 300.0, ut);
        TimeScale sunrise = gs.getSunriseTimeUT();
        TimeScale sunset = gs.getSunsetTimeUT();
        int sunsetPhase = 0;
        int sunrisePhase = 0;
        if (sunrise != null && sunset != null) {
            sunsetPhase = timeGrid.findClosestTimeStep(sunset);
            sunrisePhase = timeGrid.findClosestTimeStep(sunrise);
        }
        if (sunrise != null && sunset != null && Math.abs(sunrise.getTimeInMinutes() - sunset.getTimeInMinutes()) > 60.0) {
            int timeIndexSunset = nowPhase - sunsetPhase;
            timeIndexSunset = (timeIndexSunset + numTimes) % numTimes;
            int timeIndexSunrise = nowPhase - sunrisePhase;
            timeIndexSunrise = (timeIndexSunrise + numTimes) % numTimes;
            stat.updateSunsetSunrise(stat.sunset_now, charIndex, siteIndexStat, timeIndexSunset, data[2], data[3], data[4]);
            stat.updateSunsetSunrise(stat.sunrise_now, charIndex, siteIndexStat, timeIndexSunrise, data[2], data[3], data[4]);
        }
        return stat;
    }

    private static void updateSeasonStat(double[][][] seasonStat, TimeScale ut, double obs, double irtam, double iri) {
        TimeScale temp = (TimeScale)ut.clone();
        temp.set(1, 0);
        double minute = temp.getTimeInMinutes();
        double MINUTE_IN_YEAR = 525949.2;
        int season = -1;
        if (minute > SEASON_MINUTE[0] - 65743.65 && minute < SEASON_MINUTE[0] + 65743.65) {
            season = 0;
        } else if (minute > SEASON_MINUTE[1] - 65743.65 && minute < SEASON_MINUTE[1] + 65743.65) {
            season = 1;
        } else if (minute > SEASON_MINUTE[2] - 65743.65 && minute < SEASON_MINUTE[2] + 65743.65) {
            season = 2;
        } else if (minute > SEASON_MINUTE[3] - 65743.65 || minute < SEASON_MINUTE[3] + 65743.65 - 525949.2) {
            season = 3;
        }
        if (season == -1) {
            return;
        }
        Statistics.updateAverageErrors(seasonStat[season], obs, irtam, iri);
    }

    private static String parseLine(String[] strs, double[] data) {
        String ursi = null;
        int count = -1;
        int i = 2;
        while (i < strs.length) {
            if (!strs[i].isEmpty()) {
                if (++count == 0) {
                    ursi = strs[i];
                } else {
                    data[count - 1] = Double.parseDouble(strs[i]);
                }
            }
            ++i;
        }
        return ursi;
    }

    private static boolean isUTinPeriods(TimeScale ut, TimeScale[][] seTime, int iPeriod) {
        boolean match = false;
        if (ut.after(seTime[iPeriod][0]) && ut.before(seTime[iPeriod][1])) {
            match = true;
        } else if (ut.before(seTime[0][0]) || ut.after(seTime[seTime.length - 1][1])) {
            match = false;
        } else if (iPeriod + 1 < seTime.length && ut.after(seTime[iPeriod][1]) && ut.before(seTime[iPeriod + 1][0])) {
            match = false;
        } else {
            match = false;
            int iTime = 0;
            while (iTime < seTime.length) {
                if (ut.after(seTime[iTime][0]) && ut.before(seTime[iTime][1])) {
                    match = true;
                    iPeriod = iTime;
                    break;
                }
                ++iTime;
            }
        }
        return match;
    }

    private static void writeSolarCycleStat(double[][] cycleStat, TimeScale endTime, String charName, String subfolder) {
        String folder = String.valueOf(GambitConstants.OUTPUT_FOLDER) + subfolder;
        try {
            File file = new File(String.valueOf(folder) + "SolarCycle_" + charName + ".txt");
            boolean writeTitle = file.exists();
            PrintWriter writer = new PrintWriter(file.getAbsolutePath());
            if (writeTitle) {
                writer.write("         End_time    IRTAM      IRI   pIRTAM     pIRI\n");
            }
            double irtam = (cycleStat[2][0] + cycleStat[2][1]) / (cycleStat[7][1] + cycleStat[7][1]);
            double iri = (cycleStat[3][0] + cycleStat[3][1]) / (cycleStat[6][1] + cycleStat[6][1]);
            writer.write(String.valueOf(endTime.toFormatUT("yyyyMMdd_HH:mm:ss")) + " " + FC.DoubleToString(irtam, 8, 2) + " " + FC.DoubleToString(iri, 8, 2) + " " + FC.DoubleToString(cycleStat[7][0] + cycleStat[7][1], 8, 0) + " " + FC.DoubleToString(cycleStat[6][0] + cycleStat[6][1], 8, 0) + "\n");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeSeasonStat(double[][][] seasonStat, String charName, String subfolder) {
        String folder = String.valueOf(GambitConstants.OUTPUT_FOLDER) + subfolder;
        try {
            Statistics.writeAverageError(seasonStat[0], String.valueOf(folder) + "Season_Spring_" + charName + ".txt", "");
            Statistics.writeAverageError(seasonStat[1], String.valueOf(folder) + "Season_Summer_" + charName + ".txt", "");
            Statistics.writeAverageError(seasonStat[2], String.valueOf(folder) + "Season_Fall_" + charName + ".txt", "");
            Statistics.writeAverageError(seasonStat[3], String.valueOf(folder) + "Season_Winter_" + charName + ".txt", "");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

