/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.synthesizers;

import edu.uml.giro.gambit.coefficients.Coefficients;
import edu.uml.giro.gambit.expansions.ExpansionBasis;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.geospace.EarthGrid;
import edu.uml.lgdc.geospace.TimeGrid;

public abstract class Synthesizer {
    public CharChoice cc;
    protected ExpansionBasis basis;
    protected Coefficients<?> coeffs;
    protected int irtamVersionIdent;
    protected String assimilationMethodName;

    public void setAssimilationMethodName(String name) {
        this.assimilationMethodName = name;
    }

    public void setIrtamVersionIdent(int id) {
        this.irtamVersionIdent = id;
    }

    public int getIrtamVersionIdent() {
        return this.irtamVersionIdent;
    }

    public String getAssimilationMethodName() {
        return this.assimilationMethodName;
    }

    public Synthesizer(CharChoice cc, ExpansionBasis basis, Coefficients<?> coeffs) {
        this.cc = cc;
        this.basis = basis;
        this.coeffs = coeffs;
    }

    public void setEarthGrid(EarthGrid earthGrid) {
        this.basis.setEarthGrid(earthGrid);
    }

    public void setTimeGrid(TimeGrid timeGrid) {
        this.basis.setTimeGrid(timeGrid);
    }

    public void setBasis(ExpansionBasis basis) {
        this.basis = basis;
    }

    public ExpansionBasis getExpansionBasis() {
        return this.basis;
    }

    public Coefficients<?> getCoefficients() {
        return this.coeffs;
    }

    public EarthGrid getEarthGrid() {
        return this.basis.getEarthGrid();
    }

    public TimeGrid getTimeGrid() {
        return this.basis.getTimeGrid();
    }

    public void reset() {
        if (this.coeffs != null) {
            this.coeffs.reset();
        }
    }

    public abstract double synthesizeValue(double var1, double var3, int var5);

    public abstract double synthesizeTrend(double var1, double var3, int var5);

    public abstract double[] synthesizeValueSeries(int var1, int var2);

    public double[] synthesizeValueSeries(double lat, double lon) {
        return this.synthesizeValueSeries(this.basis.getEarthGrid().getGridLatIndex(lat), this.basis.getEarthGrid().getGridLonIndex(lon));
    }

    public abstract double[][] synthesizeValueMap(int var1);
}

