/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.synthesizers;

import edu.uml.giro.gambit.coefficients.Coefficients;
import edu.uml.giro.gambit.expansions.ExpansionBasis;
import edu.uml.giro.gambit.expansions.ExpansionBasis_SphericalCapHarmonicsK6;
import edu.uml.giro.gambit.synthesizers.GeoSynthesizer;
import edu.uml.lgdc.geospace.CharChoice;
import edu.uml.lgdc.time.TimeScale;

public class SynthesizerSCH
extends GeoSynthesizer {
    public SynthesizerSCH(CharChoice cc, ExpansionBasis basis, Coefficients<?> coeffs) {
        super(cc, basis, coeffs, null);
    }

    @Override
    public double synthesizeValue(double latitude_deg, double longitude_deg, int iTime) {
        ExpansionBasis_SphericalCapHarmonicsK6 basisSCH = (ExpansionBasis_SphericalCapHarmonicsK6)this.basis;
        TimeScale ut = this.basis.getTimeGrid().getUTs()[iTime];
        double hoursSince00z = ut.getTimeSinceMidnightIn(11);
        double timeAdjustedLongitude = (int)(longitude_deg + 15.0 * hoursSince00z);
        if (timeAdjustedLongitude > 360.0) {
            timeAdjustedLongitude -= 360.0;
        }
        int iLon = basisSCH.getEarthGrid().getGridLonIndex(timeAdjustedLongitude);
        double referenceModip = basisSCH.getModip(latitude_deg, longitude_deg);
        int iLat = basisSCH.findModipIndex(referenceModip, iLon);
        double value = 0.0;
        int k = 0;
        while (k < basisSCH.getCompactSpatialBasisLength()) {
            double c = ((double[][])this.coeffs.get())[k / 2][k % 2];
            int[] odt = basisSCH.compactToOrderDegreeTerm(k);
            double basis = basisSCH.getSpatialBasisFunctionValue(k, iLat, iLon);
            value += c * basis;
            ++k;
        }
        return value;
    }

    @Override
    public double[] synthesizeValueSeries(int iLat, int iLon) {
        double[] valueSeries = new double[this.basis.getTimeGrid().getNumDiurnalSteps()];
        double latitude_deg = this.basis.getEarthGrid().getGridLatDegree(iLat);
        double longitude_deg = this.basis.getEarthGrid().getGridLonDegree(iLon);
        int iTime = 0;
        while (iTime < this.basis.getTimeGrid().getNumDiurnalSteps()) {
            valueSeries[iTime] = this.synthesizeValue(latitude_deg, longitude_deg, iTime);
            ++iTime;
        }
        return valueSeries;
    }

    @Override
    public double[][] synthesizeValueMap(int iTime) {
        double[][] valueGrid = new double[this.basis.getEarthGrid().getNumLatitudeNodes()][this.basis.getEarthGrid().getNumLongitudeNodes()];
        int iLat = 0;
        while (iLat < this.basis.getEarthGrid().getNumLatitudeNodes()) {
            double latitude_deg = this.basis.getEarthGrid().getGridLatDegree(iLat);
            int iLon = 0;
            while (iLon < this.basis.getEarthGrid().getNumLongitudeNodes()) {
                double longitude_deg = this.basis.getEarthGrid().getGridLonDegree(iLon);
                double[] dArray = valueGrid[iLat];
                int n = iLon++;
                dArray[n] = dArray[n] + this.synthesizeValue(latitude_deg, longitude_deg, iTime);
            }
            ++iLat;
        }
        return valueGrid;
    }
}

