/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.giro.gambit.test;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfacePolyline;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;

public class LineBackground
extends ApplicationTemplate {
    public static void main(String[] args) {
        ApplicationTemplate.start((String)"World Wind Line Backgrounds", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            try {
                BasicShapeAttributes foregroundAttrs = new BasicShapeAttributes();
                foregroundAttrs.setOutlineMaterial(new Material(Color.BLUE));
                foregroundAttrs.setOutlineStipplePattern((short)-21846);
                foregroundAttrs.setOutlineStippleFactor(8);
                BasicShapeAttributes backgroundAttrs = new BasicShapeAttributes();
                backgroundAttrs.setOutlineMaterial(new Material(Color.WHITE));
                backgroundAttrs.setOutlineOpacity(0.1);
                backgroundAttrs.setOutlineWidth(foregroundAttrs.getOutlineWidth() + 2.0);
                SurfacePolyline si1 = new SurfacePolyline(new ArrayList<LatLon>(Arrays.asList(LatLon.fromDegrees((double)33.7, (double)119.6), LatLon.fromDegrees((double)33.5, (double)125.0), LatLon.fromDegrees((double)35.1, (double)129.1), LatLon.fromDegrees((double)35.8, (double)127.1))));
                si1.setClosed(true);
                si1.setAttributes((ShapeAttributes)foregroundAttrs);
                SurfacePolyline si2 = new SurfacePolyline(si1.getLocations());
                si2.setClosed(true);
                si2.setAttributes((ShapeAttributes)backgroundAttrs);
                ArrayList<LatLon> plPoints = new ArrayList<LatLon>();
                for (LatLon ll : si1.getLocations()) {
                    plPoints.add(ll.add(LatLon.fromDegrees((double)2.0, (double)0.0)));
                }
                Polyline pl1 = new Polyline(plPoints, 0.0);
                pl1.setFollowTerrain(true);
                pl1.setClosed(true);
                pl1.setPathType(2);
                pl1.setColor(foregroundAttrs.getOutlineMaterial().getDiffuse());
                pl1.setLineWidth(foregroundAttrs.getOutlineWidth());
                pl1.setStipplePattern(foregroundAttrs.getOutlineStipplePattern());
                pl1.setStippleFactor(foregroundAttrs.getOutlineStippleFactor());
                Polyline pl2 = new Polyline(plPoints, 0.0);
                pl2.setFollowTerrain(true);
                pl2.setClosed(true);
                pl2.setPathType(2);
                float[] c = backgroundAttrs.getOutlineMaterial().getDiffuse().getColorComponents(new float[3]);
                pl2.setColor(new Color(c[0], c[1], c[2], (float)backgroundAttrs.getOutlineOpacity()));
                pl2.setLineWidth(backgroundAttrs.getOutlineWidth());
                pl2.setStipplePattern(backgroundAttrs.getOutlineStipplePattern());
                pl2.setStippleFactor(backgroundAttrs.getOutlineStippleFactor());
                RenderableLayer layer = new RenderableLayer();
                layer.setName("Lines");
                layer.setPickEnabled(false);
                layer.addRenderable((Renderable)si2);
                layer.addRenderable((Renderable)si1);
                layer.addRenderable((Renderable)pl1);
                layer.addRenderable((Renderable)pl2);
                LineBackground.insertBeforeCompass((WorldWindow)this.getWwd(), (Layer)layer);
                View view = this.getWwd().getView();
                view.setEyePosition(Position.fromDegrees((double)35.3, (double)124.6, (double)1500000.0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

