/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.aoa;

import edu.uml.lgdc.aoa.AoACalcIx;
import edu.uml.lgdc.aoa.AoACalcResultIx;
import edu.uml.lgdc.aoa.AoAOneCalcResultIx;
import edu.uml.lgdc.datatype.geom.R2;
import edu.uml.lgdc.datatype.geom.R3;
import edu.uml.lgdc.math.Complex;
import edu.uml.lgdc.math.Search;
import edu.uml.lgdc.math.Sort;
import edu.uml.lgdc.time.TimeScale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AngleOfArrivalCalc
implements AoACalcIx {
    public static final int MAJOR_VERSION = 5;
    public static final int MINOR_VERSION = 1;
    public static final Result NOT_CALCULABLE = new Result(new MainResult(0.0, 0.0, -1.0), null);
    private static final double DEFAULT_PHASE_PRECISION_DEG = 5.0;
    private static final double SMALL_EPSILON = 1.0E-8;
    private static final int X = 0;
    private static final int Y = 1;
    private static final int Z = 2;
    private static final double FULL_PERIOD_DEG = 360.0;
    private R3[] antCoord;
    private double maxZenith_deg = 90.0;
    private double freq_kHz = -1.0;
    private double speedOfLight_km_s = 299792.458;
    private double phasePrecision_deg = 5.0;
    private double[][] zenithRanges_deg;
    private double trueMaxZenith_deg = this.maxZenith_deg;
    private double[][] distances_m;
    private double maxDist_m;
    private double[][] distances_deg;
    private double maxDist_deg;
    private double maxDistPlusEps_deg;
    private int numberOfAntennas;
    private boolean sourceKnown;
    private double sourceZenith;
    private double sourceZenithDelta;
    private double[][] sourceAzimuthRanges;
    private int numOfAntBut1;
    private int numOfTerms;
    private double[] dx;
    private double[] dy;
    private double dX;
    private double dY;
    private double dXY;
    private double det;
    private double absOf_k;
    private double absOf_k_sq;

    public AngleOfArrivalCalc(double[] ant1Coord, double[] ant2Coord, double[] ant3Coord, double[] ant4Coord) {
        this.setAntennas(new double[][]{ant1Coord, ant2Coord, ant3Coord, ant4Coord});
    }

    public AngleOfArrivalCalc(double[][] antCoords) {
        this.setAntennas(antCoords);
    }

    @Override
    public int getMinNumberOfAntennas() {
        return 4;
    }

    private void setAntennas(double[][] coords) {
        String errMsg = this.checkCoords(coords);
        if (errMsg != null) {
            throw new IllegalArgumentException(errMsg);
        }
        this.antCoord = new R3[coords.length];
        int i = 0;
        while (i < coords.length) {
            this.antCoord[i] = new R3(coords[i]);
            ++i;
        }
        this.numOfAntBut1 = this.numberOfAntennas - 1;
        this.numOfTerms = this.numberOfAntennas * this.numOfAntBut1 / 2;
        this.calcDistances_m();
        this.calcCoefficients();
    }

    @Override
    public void setFreq_kHz(double freq_kHz) {
        if (freq_kHz <= 0.0) {
            throw new IllegalArgumentException("illegal freq_kHz, " + freq_kHz);
        }
        this.freq_kHz = freq_kHz;
        this.calcMaxDist_deg();
        this.absOf_k = 360.0 * freq_kHz / this.speedOfLight_km_s;
        this.absOf_k_sq = this.absOf_k * this.absOf_k;
    }

    public double getMaxZenith_deg() {
        return this.maxZenith_deg;
    }

    @Override
    public void setMaxZenith_deg(double maxZenith_deg) {
        if (maxZenith_deg <= 0.0 || maxZenith_deg > 90.0) {
            throw new IllegalArgumentException("illegal maxZenith_deg, " + maxZenith_deg);
        }
        this.maxZenith_deg = maxZenith_deg;
        this.setTrueMaxZenith_deg();
        this.calcMaxDist_deg();
    }

    @Override
    public void setTime(TimeScale time) {
    }

    public void setZenithRanges_deg(double[][] zenithRanges_deg) {
        if (zenithRanges_deg == null || zenithRanges_deg.length == 0) {
            this.zenithRanges_deg = null;
        } else if (!this.sourceKnown) {
            this.checkZenithRanges(zenithRanges_deg);
            this.zenithRanges_deg = zenithRanges_deg;
        } else {
            throw new RuntimeException("*zenith ranges* and *known source* modes are incompatible");
        }
        this.setTrueMaxZenith_deg();
        this.calcMaxDist_deg();
    }

    @Override
    public void setKnownSource(double sourceZenith, double sourceAzimuth, double sourceZenithDelta, double sourceAzimuthDelta) {
        if (this.zenithRanges_deg != null) {
            throw new RuntimeException("*zenith ranges* and *known source* modes are incompatible");
        }
        this.sourceZenith = sourceZenith;
        this.sourceZenithDelta = sourceZenithDelta;
        this.sourceAzimuthRanges = sourceAzimuth - sourceAzimuthDelta < 0.0 || sourceAzimuth + sourceAzimuthDelta > 360.0 ? (sourceAzimuth - sourceAzimuthDelta < 0.0 ? (Object)new double[][]{{0.0, sourceAzimuth + sourceAzimuthDelta}, {360.0 + sourceAzimuth - sourceAzimuthDelta, 360.0}} : (double[][])new double[][]{{sourceAzimuth - sourceAzimuthDelta, 360.0}, {0.0, sourceAzimuth + sourceAzimuthDelta - 360.0}}) : (double[][])new double[][]{{sourceAzimuth - sourceAzimuthDelta, sourceAzimuth + sourceAzimuthDelta}};
        this.sourceKnown = true;
    }

    @Override
    public void setUnknownSource() {
        this.sourceKnown = false;
    }

    public void setRoundedSpeedOfLight() {
        this.speedOfLight_km_s = 300000.0;
    }

    @Override
    public Result calc(Complex[] quadratures) {
        double[] phases = new double[quadratures.length];
        int i = 0;
        while (i < quadratures.length) {
            phases[i] = Math.toDegrees(quadratures[i].getPhase());
            ++i;
        }
        return this.calc(phases);
    }

    @Override
    public Result calc(double[] phases) {
        double bestRMSErrorSoFar = Double.MAX_VALUE;
        MainResult mainResult = null;
        double[][] possiblePhaseSets = this.getPossibleAntPhaseSets(phases);
        MainResult[] allResults = new MainResult[possiblePhaseSets.length];
        int bestIndex = -1;
        int i = 0;
        while (i < possiblePhaseSets.length) {
            MainResult currResult;
            allResults[i] = currResult = this.calc1(possiblePhaseSets[i]);
            if (currResult.getFitErrorDeg() >= 0.0 && this.isZenithEligible(currResult.getZenithDeg(), currResult.getAzimuthDeg()) && currResult.getFitErrorDeg() < bestRMSErrorSoFar) {
                bestIndex = i;
                bestRMSErrorSoFar = currResult.getFitErrorDeg();
                mainResult = currResult;
            }
            ++i;
        }
        if (bestIndex >= 0) {
            return new Result(mainResult, new AuxResult(possiblePhaseSets[bestIndex], possiblePhaseSets, allResults));
        }
        return NOT_CALCULABLE;
    }

    private MainResult calc1(double[] phases) {
        if (this.freq_kHz < 0.0) {
            throw new RuntimeException("Frequency was not set");
        }
        MainResult result = new MainResult(0.0, 0.0, -1.0);
        if (Math.abs(this.det) < 1.0E-14) {
            return result;
        }
        double[] dPhi = new double[this.numOfTerms];
        int k = 0;
        int i = 0;
        while (i < this.numOfAntBut1) {
            int j = i + 1;
            while (j < this.numberOfAntennas) {
                dPhi[k++] = phases[j] - phases[i];
                ++j;
            }
            ++i;
        }
        double dXPhi = 0.0;
        double dYPhi = 0.0;
        int i2 = 0;
        while (i2 < this.numOfTerms) {
            dXPhi -= this.dx[i2] * dPhi[i2];
            dYPhi -= this.dy[i2] * dPhi[i2];
            ++i2;
        }
        double kx = (dXPhi * this.dY - dYPhi * this.dXY) / this.det;
        double kx_s = kx * kx;
        double ky = (this.dX * dYPhi - this.dXY * dXPhi) / this.det;
        double ky_s = ky * ky;
        double kzp2 = this.absOf_k_sq - kx_s - ky_s;
        if (kzp2 < -1.0E-8) {
            return result;
        }
        double kz = kzp2 > 0.0 ? -Math.sqrt(kzp2) : 0.0;
        double zenithDeg = Math.toDegrees(Math.acos(-kz / this.absOf_k));
        if (zenithDeg > this.trueMaxZenith_deg) {
            return result;
        }
        double azimuthDeg = Math.toDegrees(R2.phaseAngle(-kx, -ky));
        if (azimuthDeg >= 360.0) {
            azimuthDeg = 0.0;
        }
        double rmsErrorDeg = kx_s * this.dX + ky_s * this.dY + 2.0 * kx * ky * this.dXY - 2.0 * kx * dXPhi - 2.0 * ky * dYPhi;
        int i3 = 0;
        while (i3 < this.numOfTerms) {
            rmsErrorDeg += dPhi[i3] * dPhi[i3];
            ++i3;
        }
        if ((rmsErrorDeg /= (double)this.numOfTerms) < 0.0) {
            rmsErrorDeg = 0.0;
        }
        rmsErrorDeg = Math.sqrt(rmsErrorDeg);
        return new MainResult(zenithDeg, azimuthDeg, rmsErrorDeg);
    }

    private void calcDistances_m() {
        this.distances_m = new double[this.numberOfAntennas][this.numberOfAntennas];
        this.maxDist_m = 0.0;
        int i = 0;
        while (i < this.numOfAntBut1) {
            int j = i + 1;
            while (j < this.numberOfAntennas) {
                this.distances_m[i][j] = this.antCoord[i].dist(this.antCoord[j]);
                this.distances_m[j][i] = this.distances_m[i][j];
                if (this.maxDist_m < this.distances_m[i][j]) {
                    this.maxDist_m = this.distances_m[i][j];
                }
                ++j;
            }
            ++i;
        }
    }

    private void calcCoefficients() {
        this.dx = new double[this.numOfTerms];
        this.dy = new double[this.numOfTerms];
        int k = 0;
        int i = 0;
        while (i < this.numOfAntBut1) {
            int j = i + 1;
            while (j < this.numberOfAntennas) {
                this.dx[k] = this.antCoord[j].getX() - this.antCoord[i].getX();
                this.dy[k] = this.antCoord[j].getY() - this.antCoord[i].getY();
                ++k;
                ++j;
            }
            ++i;
        }
        this.dX = 0.0;
        this.dY = 0.0;
        this.dXY = 0.0;
        i = 0;
        while (i < this.numOfTerms) {
            this.dX += this.dx[i] * this.dx[i];
            this.dY += this.dy[i] * this.dy[i];
            this.dXY += this.dx[i] * this.dy[i];
            ++i;
        }
        this.det = this.dX * this.dY - this.dXY * this.dXY;
    }

    private void calcMaxDist_deg() {
        if (this.freq_kHz > 0.0) {
            this.distances_deg = new double[this.numberOfAntennas][this.numberOfAntennas];
            this.maxDist_deg = 0.0;
            int i = 0;
            while (i < this.numOfAntBut1) {
                int j = i + 1;
                while (j < this.numberOfAntennas) {
                    this.distances_deg[i][j] = 360.0 * this.freq_kHz * (this.distances_m[i][j] / this.speedOfLight_km_s) * Math.sin(Math.toRadians(this.trueMaxZenith_deg));
                    this.distances_deg[j][i] = this.distances_deg[i][j];
                    if (this.maxDist_deg < this.distances_deg[i][j]) {
                        this.maxDist_deg = this.distances_deg[i][j];
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.maxDistPlusEps_deg = this.maxDist_deg + 1.0E-8;
    }

    private String checkCoords(double[][] coords) {
        if (coords == null) {
            return "coords is null";
        }
        if (coords.length < 2) {
            return "at least 2 antennas needed for calculation";
        }
        this.numberOfAntennas = coords.length;
        int i = 0;
        while (i < this.numberOfAntennas) {
            if (coords[i] == null) {
                return "one of the antenna's coordinates array is null";
            }
            ++i;
        }
        i = 0;
        while (i < this.numberOfAntennas) {
            if (coords[i].length != 3) {
                return "one of the antenna's coordinates array is not 3-dimensional";
            }
            ++i;
        }
        i = 0;
        while (i < this.numberOfAntennas) {
            if (coords[i][2] != 0.0) {
                return "one of the antenna's Z-coordinates is not zero";
            }
            ++i;
        }
        i = 0;
        while (i < this.numberOfAntennas) {
            if (coords[0][0] != 0.0 || coords[0][1] != 0.0 || coords[0][2] != 0.0) {
                return "all coordinates of the antenna 1 should be 0";
            }
            ++i;
        }
        if (AngleOfArrivalCalc.isDuplicated(coords)) {
            return "antennas with the same coordinates were found";
        }
        return null;
    }

    private double[][] getPossibleAntPhaseSets(double[] phases) {
        if (this.freq_kHz < 0.0) {
            throw new RuntimeException("Frequency was not set");
        }
        if (phases == null) {
            throw new IllegalArgumentException("phases is null");
        }
        if (phases.length != this.numberOfAntennas) {
            throw new IllegalArgumentException("length of array phases, " + phases.length + ", not equals to number of antennas, " + this.numberOfAntennas);
        }
        int i = 0;
        while (i < this.numberOfAntennas) {
            if (phases[i] < 0.0 || phases[i] >= 360.0) {
                throw new RuntimeException("at least one of the phases is illegal, " + phases[i] + " (<0 or >=360)");
            }
            ++i;
        }
        int[] ant = new int[this.numberOfAntennas];
        boolean[] canAdd2PI = new boolean[this.numberOfAntennas];
        int i2 = 0;
        while (i2 < this.numberOfAntennas) {
            ant[i2] = i2 + 1;
            canAdd2PI[i2] = true;
            ++i2;
        }
        phases = (double[])phases.clone();
        Sort.qsort(phases, 0, this.numberOfAntennas - 1, ant);
        ArrayList<double[]> sets = new ArrayList<double[]>();
        this.addPossibleAntPhaseSets(phases, ant, canAdd2PI, sets);
        return (double[][])sets.toArray((T[])new double[0][]);
    }

    private void addPossibleAntPhaseSets(double[] phases, int[] antNumbers, boolean[] canAdd2PI, List<double[]> sets) {
        int last = this.numberOfAntennas - 1;
        boolean moveFirst = false;
        if (phases[last] - phases[0] > this.maxDistPlusEps_deg) {
            if (!canAdd2PI[0]) {
                return;
            }
            moveFirst = true;
        }
        int antNumberAt1stPos = antNumbers[0];
        boolean canMoveAll = true;
        int maxNumberToMove = 0;
        int i = 0;
        while (i < this.numberOfAntennas) {
            if (canAdd2PI[i]) {
                ++maxNumberToMove;
            }
            ++i;
        }
        if (maxNumberToMove == 0) {
            if (this.isLegal(phases, antNumbers)) {
                this.addThisPhases(phases, antNumbers, sets);
            }
            return;
        }
        if (maxNumberToMove == this.numberOfAntennas) {
            canMoveAll = false;
        }
        int[] antIndexesToMove = new int[maxNumberToMove];
        maxNumberToMove = 0;
        int i2 = 0;
        while (i2 < this.numberOfAntennas) {
            if (canAdd2PI[i2]) {
                antIndexesToMove[maxNumberToMove++] = i2;
            }
            ++i2;
        }
        double[] ph = (double[])phases.clone();
        int[] ants = (int[])antNumbers.clone();
        boolean[] canAdd = new boolean[this.numberOfAntennas];
        if (moveFirst) {
            ph[0] = ph[0] + 360.0;
            Sort.qsort(ph, 0, last, ants);
            antIndexesToMove = Arrays.copyOfRange(antIndexesToMove, 1, 1 + --maxNumberToMove);
            int tmpInd = Search.scan(ants, antNumberAt1stPos);
            canAdd[tmpInd] = true;
            int i3 = 0;
            while (i3 < maxNumberToMove) {
                if (antIndexesToMove[i3] <= tmpInd) {
                    int n = i3;
                    antIndexesToMove[n] = antIndexesToMove[n] - 1;
                }
                ++i3;
            }
        }
        IntValuesSetEnum setEnum = new IntValuesSetEnum(antIndexesToMove);
        while (setEnum.hasMore()) {
            int[] nextIndexesToMove = setEnum.next();
            if (nextIndexesToMove.length >= maxNumberToMove && !canMoveAll) continue;
            double[] phCopy = (double[])ph.clone();
            boolean[] canAddCopy = (boolean[])canAdd.clone();
            int i4 = 0;
            while (i4 < nextIndexesToMove.length) {
                int n = nextIndexesToMove[i4];
                phCopy[n] = phCopy[n] + 360.0;
                canAddCopy[nextIndexesToMove[i4]] = true;
                ++i4;
            }
            Sort sort = new Sort(phCopy);
            int[] antsCopy = sort.doSort(ants);
            canAddCopy = sort.doSort(canAddCopy);
            this.addPossibleAntPhaseSets(phCopy, antsCopy, canAddCopy, sets);
        }
    }

    private boolean isLegal(double[] phases, int[] antNumbers) {
        int last = this.numberOfAntennas - 1;
        return (antNumbers[0] != 1 || phases[1] - phases[0] < this.phasePrecision_deg) && (antNumbers[last] != 1 || phases[last] - phases[last - 1] < this.phasePrecision_deg);
    }

    private void addThisPhases(double[] phases, int[] antNumbers, List<double[]> sets) {
        double shift = 0.0;
        if (phases[0] > 0.0) {
            shift = -360 * (int)(phases[0] / 360.0);
        } else if (phases[0] < 0.0) {
            int q = (int)(-phases[0] / 360.0);
            if ((double)(q * 360) != -phases[0]) {
                ++q;
            }
            shift = 360 * q;
        }
        Sort sort = new Sort((int[])antNumbers.clone());
        double[] ph = sort.doSort(phases);
        if (shift != 0.0) {
            int i = 0;
            while (i < ph.length) {
                int n = i++;
                ph[n] = ph[n] + shift;
            }
        }
        sets.add(ph);
    }

    private boolean isZenithEligible(double zenith_deg, double azimuth_deg) {
        if (this.sourceKnown) {
            return this.closeToKnownSource(zenith_deg, azimuth_deg);
        }
        if (zenith_deg > this.trueMaxZenith_deg) {
            return false;
        }
        if (this.zenithRanges_deg == null) {
            return true;
        }
        return this.inside(this.zenithRanges_deg, zenith_deg);
    }

    private boolean closeToKnownSource(double zenith_deg, double azimuth_deg) {
        return zenith_deg >= this.sourceZenith - this.sourceZenithDelta && zenith_deg <= this.sourceZenith + this.sourceZenithDelta && (zenith_deg == 0.0 || this.closeToKnownAzimuth(azimuth_deg));
    }

    private boolean closeToKnownAzimuth(double azimuth_deg) {
        double[][] dArray = this.sourceAzimuthRanges;
        int n = this.sourceAzimuthRanges.length;
        int n2 = 0;
        while (n2 < n) {
            double[] range_deg = dArray[n2];
            if (azimuth_deg >= range_deg[0] && azimuth_deg <= range_deg[1]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void setTrueMaxZenith_deg() {
        if (this.zenithRanges_deg == null || this.inside(this.zenithRanges_deg, this.maxZenith_deg)) {
            this.trueMaxZenith_deg = this.maxZenith_deg;
        } else {
            double[] rightValues = new double[this.zenithRanges_deg.length];
            int i = 0;
            while (i < this.zenithRanges_deg.length) {
                rightValues[i] = this.zenithRanges_deg[i][1];
                ++i;
            }
            Arrays.sort(rightValues);
            int index = Search.leftNearest(rightValues, this.maxZenith_deg);
            this.trueMaxZenith_deg = index >= 0 ? rightValues[index] : this.maxZenith_deg;
        }
    }

    private boolean inside(double[][] intervals, double value) {
        int i = 0;
        while (i < intervals.length) {
            if (value >= intervals[i][0] && value <= intervals[i][1]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void checkZenithRanges(double[][] zenithRanges_deg) {
        String errMsg = null;
        int i = 0;
        while (i < zenithRanges_deg.length) {
            if (zenithRanges_deg[i] == null) {
                errMsg = "interval with index " + i + " is null";
                break;
            }
            if (zenithRanges_deg[i].length != 2) {
                errMsg = "interval with index " + i + " has length " + zenithRanges_deg[i].length + ", different from 2, ";
                break;
            }
            if (zenithRanges_deg[i][0] < 0.0 || zenithRanges_deg[i][0] > 90.0 || zenithRanges_deg[i][1] < 0.0 || zenithRanges_deg[i][1] > 90.0) {
                errMsg = "interval with index " + i + ": illegal zenith values, " + "should be >= 0 and <= 90 degrees";
                break;
            }
            if (zenithRanges_deg[i][0] > zenithRanges_deg[i][1]) {
                errMsg = "interval with index " + i + ": start is greater than end";
                break;
            }
            ++i;
        }
        if (errMsg != null) {
            throw new IllegalArgumentException(errMsg);
        }
    }

    private static boolean isDuplicated(double[][] sets) {
        if (sets.length <= 1) {
            return false;
        }
        int i = 0;
        while (i < sets.length - 1) {
            int j = i + 1;
            while (j < sets.length) {
                if (Arrays.equals(sets[i], sets[j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static final class AuxResult {
        private final double[] effectivePhases;
        private final double[][] possiblePhases;
        private final MainResult[] allResults;

        public AuxResult(double[] effectivePhases, double[][] possiblePhases, MainResult[] allResults) {
            this.effectivePhases = effectivePhases;
            this.possiblePhases = possiblePhases;
            this.allResults = allResults;
        }

        public double[] getEffectivePhases() {
            return this.effectivePhases;
        }

        public double[][] getPossiblePhases() {
            return this.possiblePhases;
        }

        public MainResult[] getAllResults() {
            return this.allResults;
        }
    }

    private static class IntValuesSetEnum {
        private final int[] set;
        private final int maxNumberOfElements;
        private boolean hasMore = true;
        private int nextNumberOfElements = 0;
        private int[] nextSet = new int[0];

        IntValuesSetEnum(int[] set) {
            if (set == null) {
                throw new IllegalArgumentException("set is null");
            }
            this.set = set;
            this.maxNumberOfElements = set.length;
        }

        boolean hasMore() {
            return this.hasMore;
        }

        int[] next() {
            if (!this.hasMore) {
                throw new RuntimeException("attemp to get next element after iteration is completed");
            }
            int[] next = new int[this.nextNumberOfElements];
            int i = 0;
            while (i < this.nextNumberOfElements) {
                next[i] = this.set[this.nextSet[i]];
                ++i;
            }
            this.hasMore = false;
            i = this.nextNumberOfElements - 1;
            while (i >= 0) {
                int diff = i > 0 ? this.nextSet[i] - this.nextSet[i - 1] - 1 : this.nextSet[i];
                if (diff > 0) {
                    this.hasMore = true;
                    int n = i;
                    this.nextSet[n] = this.nextSet[n] - 1;
                    int k = i + 1;
                    while (k < this.nextNumberOfElements) {
                        this.nextSet[k] = k + this.maxNumberOfElements - this.nextNumberOfElements;
                        ++k;
                    }
                    break;
                }
                --i;
            }
            if (!this.hasMore && this.nextNumberOfElements < this.maxNumberOfElements) {
                this.hasMore = true;
                ++this.nextNumberOfElements;
                this.nextSet = new int[this.nextNumberOfElements];
                i = 0;
                while (i < this.nextNumberOfElements) {
                    this.nextSet[i] = i + this.maxNumberOfElements - this.nextNumberOfElements;
                    ++i;
                }
            }
            return next;
        }
    }

    public static final class MainResult
    implements AoAOneCalcResultIx {
        private final double zenithDeg;
        private final double azimuthDeg;
        private final double rmsErrorDeg;

        public MainResult(double zenithDeg, double azimuthDeg, double rmsErrorDeg) {
            this.zenithDeg = zenithDeg;
            this.azimuthDeg = azimuthDeg;
            this.rmsErrorDeg = rmsErrorDeg;
        }

        @Override
        public boolean isCalculable() {
            return this.rmsErrorDeg != -1.0;
        }

        @Override
        public double getZenithDeg() {
            return this.zenithDeg;
        }

        @Override
        public double getAzimuthDeg() {
            return this.azimuthDeg;
        }

        @Override
        public double getFitErrorDeg() {
            return this.rmsErrorDeg;
        }
    }

    public static final class Result
    implements AoACalcResultIx {
        private final MainResult main;
        private final AuxResult aux;

        public Result(MainResult main, AuxResult aux) {
            this.main = main;
            this.aux = aux;
        }

        public MainResult getMain() {
            return this.main;
        }

        public AuxResult getAux() {
            return this.aux;
        }

        @Override
        public boolean isCalculable() {
            return this != NOT_CALCULABLE;
        }

        @Override
        public double getZenithDeg() {
            return this.main.getZenithDeg();
        }

        @Override
        public double getAzimuthDeg() {
            return this.main.getAzimuthDeg();
        }

        @Override
        public double getFitErrorDeg() {
            return this.main.getFitErrorDeg();
        }

        @Override
        public AoAOneCalcResultIx getBestResult() {
            return this.main;
        }

        @Override
        public AoAOneCalcResultIx[] getAllresults() {
            return this.aux.getAllResults();
        }
    }
}

