/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.appuserdb;

import edu.uml.lgdc.project.settings.ContentType;
import edu.uml.lgdc.project.settings.OptionDesc;
import edu.uml.lgdc.project.settings.OptionsIO;
import edu.uml.lgdc.project.settings.SectionDescriptor;
import edu.uml.lgdc.security.UserPassRole;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class UserDbConnectSettings
extends SectionDescriptor<UserDbConnectSettings> {
    public static final String SECTION_NAME = "User Database Connect";
    private static final String PAR_URL = "URL";
    private static final String PAR_DRIVER = "Driver";
    private static final String PAR_REGISTRAR = "Registrar";
    private static final String PAR_ADMINISTRATOR = "Admin";
    private String url;
    private UserPassRole registrar;
    private UserPassRole administrator;
    private String driver;
    private final Map<String, OptionDesc> descriptor = new HashMap<String, OptionDesc>();

    public UserDbConnectSettings() {
        this.setDefaults();
        this.fillDescriptor();
    }

    public void setDefaults() {
        this.url = "";
        this.driver = "org.firebirdsql.jdbc.FBDriver";
        this.registrar = UserPassRole.getEmptyInstance();
        this.administrator = UserPassRole.getEmptyInstance();
    }

    @Override
    public UserDbConnectSettings getThis() {
        return this;
    }

    @Override
    public String getName() {
        return SECTION_NAME;
    }

    @Override
    public Map<String, OptionDesc> getOptionsDescriptor() {
        return this.descriptor;
    }

    @Override
    public String[] optionRenameHook(String unknowmParamName, String valueOfUnknownParamName) {
        return null;
    }

    @Override
    protected void fillDescriptor() {
        this.descriptor.put(PAR_URL, new OptionDesc((Object)this.url, ContentType.DBSPEC));
        this.descriptor.put(PAR_DRIVER, new OptionDesc((Object)this.url, ContentType.DBSPEC));
        this.descriptor.put(PAR_REGISTRAR, new OptionDesc((Object)this.registrar, ContentType.DBSPEC));
        this.descriptor.put(PAR_ADMINISTRATOR, new OptionDesc((Object)this.administrator, ContentType.DBSPEC));
    }

    @Override
    public void getFrom(OptionsIO paramsIO) {
        String strVal = paramsIO.get(SECTION_NAME, PAR_URL);
        this.url = strVal != null ? strVal : "";
        strVal = paramsIO.get(SECTION_NAME, PAR_DRIVER);
        this.driver = strVal != null ? strVal : "";
        strVal = paramsIO.get(SECTION_NAME, PAR_REGISTRAR);
        this.registrar = strVal != null ? UserPassRole.parse(strVal) : UserPassRole.getEmptyInstance();
        strVal = paramsIO.get(SECTION_NAME, PAR_ADMINISTRATOR);
        this.administrator = strVal != null ? UserPassRole.parse(strVal) : UserPassRole.getEmptyInstance();
    }

    @Override
    public void putTo(OptionsIO paramsIO) {
        paramsIO.put(SECTION_NAME, PAR_URL, this.url);
        paramsIO.put(SECTION_NAME, PAR_DRIVER, this.driver);
        paramsIO.put(SECTION_NAME, PAR_REGISTRAR, this.registrar.toString());
        paramsIO.put(SECTION_NAME, PAR_ADMINISTRATOR, this.administrator.toString());
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = Objects.requireNonNull(url);
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String url) {
        this.driver = Objects.requireNonNull(url);
    }

    public UserPassRole getRegistrar() {
        return this.registrar;
    }

    public void setRegistrar(UserPassRole registrar) {
        this.registrar = Objects.requireNonNull(registrar);
    }

    public UserPassRole getAdministrator() {
        return this.administrator;
    }

    public void setAdministrator(UserPassRole administrator) {
        this.administrator = Objects.requireNonNull(administrator);
    }
}

