/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.appuserdb.constants;

import java.util.HashMap;
import java.util.Map;

public enum Application {
    GAMBIT_COEFF_SERVLET(1, "GambitCoefficients_Servlet"),
    TIDX_BACKEND(2, "TIDExplorer_Backend"),
    GAMBIT_EXPLORER_USERAPP(3, "GambitExplorer_UserApp"),
    GAMBIT_EXPLORER_MASTERAPP(4, "GambitExplorer_MasterApp"),
    RAYTRIX_OI_IONOGRAM_SERVLET(5, "Raytrix_ObliqIonoSynth_Servlet"),
    RAYTRIX_AOA_FF_SERVLET(6, "Raytrix_AOA_FF_Servlet"),
    TID_DETECTOR_SERVLET(7, "TID_Detector_Servlet"),
    TID_TRACKINFO_SERVLET(8, "TID_TrackInfo_Servlet"),
    TID_FINDTRACKS_SERVLET(9, "TID_FindTracks_Servlet"),
    TID_PROCESSOR_APP(10, "TID_Processor_App"),
    TID_REANALYSIS_APP(11, "TID_Reanalysis_App"),
    SKY6_APP(12, "Sky6_App"),
    IRTAM_PROCESSOR_APP(13, "IRTAM_Processor_App"),
    IRTAM_REANALYSIS_APP(14, "IRTAM_Reanalysis_App"),
    IRTAM_ANIMATOR_APP(15, "IRTAM_Animator_App"),
    GAMBIT_COEFF_LOCAL_SERVLET(16, "GambitCoeffsLocal_Servlet"),
    GAMBIT_LOCAL_NOWCAST(17, "GambitLocalNowcast_Servlet"),
    ION2PNG_PLUS_APP(18, "Ion2Png.Plus_App"),
    GAMBIT_MUF3000_MSG_SERVLET(19, "GambitMuf3000Message_Servlet"),
    MUF3000_MESSENGER_APP(20, "MUF3000_Messenger_App"),
    FASTCHAR_SERVLET(21, "FastChar_Servlet"),
    MUFS_SERVLET(22, "MUFs_Servlet"),
    DIDBASE_PORTAL_SERVLET(23, "DIDBasePortal_Servlet");

    private static final Map<Integer, Application> mapById;
    private static final Map<String, Application> mapByName;
    private final int id;
    private final String name;

    static {
        mapById = new HashMap<Integer, Application>();
        mapByName = new HashMap<String, Application>();
        Application[] applicationArray = Application.values();
        int n = applicationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Application application = applicationArray[n2];
            if (mapById.put(application.getId(), application) != null) {
                throw new RuntimeException("Design error: duplicated Id, " + application.getId());
            }
            if (mapByName.put(application.getName().toLowerCase(), application) != null) {
                throw new RuntimeException("Design error: duplicated Id, " + application.getName());
            }
            ++n2;
        }
    }

    private Application(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static Application get(int id) {
        return mapById.get(id);
    }

    public static Application get(String name) {
        return mapByName.get(name.toLowerCase());
    }
}

