/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.appuserdb.test;

import edu.uml.lgdc.appuserdb.api.LgdcRegistry;
import edu.uml.lgdc.appuserdb.type.Permission;
import java.sql.SQLException;
import java.util.Set;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestAddPermission {
    private static final String INI_FILE_NAME = "test.ini";
    private static final String PERMISSIONS_FILE_NAME = "permissions.txt";
    private static Set<Permission> newPermissions;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        LgdcRegistry.setupRegistryAsRegistrar(INI_FILE_NAME);
        newPermissions = Permission.read(PERMISSIONS_FILE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        LgdcRegistry.releaseAllResources();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void test() {
        try {
            for (Permission permission : newPermissions) {
                LgdcRegistry.addPermission(permission.getUsername(), permission.getApplication(), permission.getUserRole(), permission.getRealtimeOK(), permission.getDbCredentialsId());
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
}

