/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.appuserdb.test;

import edu.uml.lgdc.appuserdb.api.ApplicationPassport;
import edu.uml.lgdc.appuserdb.api.LgdcRegistry;
import edu.uml.lgdc.appuserdb.api.UserCredentials;
import edu.uml.lgdc.appuserdb.constants.Application;
import edu.uml.lgdc.database.ConnectionRequisites;
import edu.uml.lgdc.database.DBConnect;
import edu.uml.lgdc.database.DatabaseFarm;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLoginFromApp {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void loginToRegistryURL() throws SQLException {
        Application app = Application.get("GambitExplorer_UserApp");
        UserCredentials userCreds = new UserCredentials();
        userCreds.setUserCredentials("Tester", "D3Dm0r0Z");
        LgdcRegistry.buildDatabaseFarmsByUrl(app, userCreds, "0.0", System.getProperty("os.name"));
        Map<ApplicationPassport, DatabaseFarm> allFarms = LgdcRegistry.getDatabaseFarms(app);
        System.out.println("---- List of databases:");
        for (Map.Entry<ApplicationPassport, DatabaseFarm> oneFarm : allFarms.entrySet()) {
            DatabaseFarm farm = oneFarm.getValue();
            ApplicationPassport passport = oneFarm.getKey();
            List<DBConnect> allDatabases = farm.getAllDatabases();
            for (DBConnect connect : allDatabases) {
                ConnectionRequisites req = connect.getRequisites();
                System.out.println("Database:" + req.getURL() + "; allowed user " + passport.getUserId() + " with role = " + (Object)((Object)passport.getRole()) + "; real-time " + (passport.realtimePermitted() ? " permitted " : " not allowed"));
            }
        }
        System.out.println("---- End of list");
    }
}

