/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.appuserdb.type;

import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.security.UserPass;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Account {
    private final String username;
    private final char[] pass;
    private final String email;
    private final String contactPerson;
    private final String organization;

    public Account(String username, char[] pass, String email, String contactPerson, String organization) {
        this.username = Objects.requireNonNull(username).trim();
        this.pass = Objects.requireNonNull(pass);
        this.email = Objects.requireNonNull(email).trim();
        this.contactPerson = Objects.requireNonNull(contactPerson).trim();
        this.organization = Objects.requireNonNull(organization).trim();
        if (this.username.isEmpty()) {
            throw new IllegalArgumentException("username is empty");
        }
        if (UserPass.isUsernameContainsIllegalSymbols(this.username)) {
            throw new IllegalArgumentException("username contains illegal characters");
        }
        if (this.pass.length == 0) {
            throw new IllegalArgumentException("password is empty");
        }
        if (this.email.isEmpty()) {
            throw new IllegalArgumentException("email is empty");
        }
        if (this.contactPerson.isEmpty()) {
            throw new IllegalArgumentException("contactPerson is empty");
        }
        if (this.organization.isEmpty()) {
            throw new IllegalArgumentException("organization is empty");
        }
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPass() {
        return this.pass;
    }

    public String getEmail() {
        return this.email;
    }

    public String getContactPerson() {
        return this.contactPerson;
    }

    public String getOrganization() {
        return this.organization;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            return this.username.equalsIgnoreCase(((Account)object).username);
        }
        return false;
    }

    public int hashCode() {
        return this.username.toLowerCase().hashCode();
    }

    public boolean isIdentical(Account acc) {
        if (this == acc) {
            return true;
        }
        if (acc != null && acc.getClass() == this.getClass()) {
            return this.username.equalsIgnoreCase(acc.username) && Arrays.equals(this.pass, acc.pass) && this.email.equalsIgnoreCase(acc.email) && this.contactPerson.equalsIgnoreCase(acc.contactPerson) && this.organization.equalsIgnoreCase(this.organization);
        }
        return false;
    }

    public static Set<Account> read(String filename) throws IOException {
        File file = new File(filename);
        if (!file.isFile()) {
            throw new RuntimeException("cannot find file " + file);
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new FileReader(filename));){
            String line;
            HashSet<Account> accounts = new HashSet<Account>(256);
            int addCount = 0;
            int accLineCount = 0;
            String username = null;
            char[] pass = null;
            String email = null;
            String contactPerson = null;
            String organization = null;
            boolean searchStart = true;
            int lineCount = 0;
            while ((line = br.readLine()) != null) {
                ++lineCount;
                if (line.startsWith("#") || line.trim().isEmpty()) continue;
                if (searchStart) {
                    if (!line.startsWith("=")) continue;
                    searchStart = false;
                    continue;
                }
                if (line.startsWith("=")) {
                    if (accLineCount == 0) continue;
                    throw new RuntimeException("line #" + lineCount + ": account separation line (starts with =) at unexpected place");
                }
                line = line.trim();
                switch (accLineCount) {
                    case 0: {
                        username = line;
                        if (!UserPass.isUsernameContainsIllegalSymbols(username)) break;
                        throw new RuntimeException("line #" + lineCount + ": user name contains illegal symbol(s), only " + UserPass.allowedCharactersForUsername() + " are allowed");
                    }
                    case 1: {
                        pass = line.toCharArray();
                        break;
                    }
                    case 2: {
                        email = line;
                        break;
                    }
                    case 3: {
                        contactPerson = line;
                        break;
                    }
                    case 4: {
                        organization = line;
                        break;
                    }
                    default: {
                        throw new RuntimeException("design error");
                    }
                }
                if (++accLineCount != 5) continue;
                accounts.add(new Account(username, pass, email, contactPerson, organization));
                ++addCount;
                accLineCount = 0;
                searchStart = true;
            }
            if (accLineCount == 0) {
                if (accounts.size() == 0) {
                    Console.showWarn("no accounts found in file " + file);
                } else if (accounts.size() < addCount) {
                    Console.showWarn(String.valueOf(addCount - accounts.size()) + " duplication(s) of account(s) in file " + file);
                }
                return accounts;
            }
            throw new RuntimeException("incomplete information for last account in the list");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

