/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.comms;

import edu.uml.lgdc.comms.Communication;
import edu.uml.lgdc.comms.FramerThread;
import edu.uml.lgdc.instrument.BasicFramer;
import edu.uml.lgdc.instrument.Payload;
import edu.uml.lgdc.multithread.MSQueue;
import edu.uml.lgdc.multithread.Semaphore;
import java.io.IOException;

public class CommFramerThread
extends FramerThread {
    private Communication comm;
    private transient boolean noDelay;

    public CommFramerThread(Communication comm, MSQueue queue, boolean syncNeeded) {
        this(comm, new BasicFramer(comm.getOutputStream()), queue, syncNeeded);
    }

    public CommFramerThread(Communication comm, BasicFramer framer, MSQueue queue, boolean syncNeeded) {
        this(comm, framer, queue, null, syncNeeded);
    }

    public CommFramerThread(Communication comm, BasicFramer framer, MSQueue queue, Semaphore terminated, boolean syncNeeded) {
        super(framer, queue, terminated, syncNeeded);
        this.comm = comm;
    }

    public CommFramerThread(String framerName, Communication comm, BasicFramer framer, MSQueue queue, Semaphore terminated, boolean syncNeeded) {
        super(framerName, framer, queue, terminated, syncNeeded);
        this.comm = comm;
    }

    @Override
    protected void beforeSend(Payload payload) throws IOException {
        if (payload != null && payload.getUrgent()) {
            this.noDelay = this.comm.getNoDelayEnable();
            if (!this.noDelay && this.comm.getDelayControlEnable()) {
                this.comm.setNoDelayEnable(true);
            }
        }
        super.beforeSend(payload);
    }

    @Override
    protected void afterSend(Payload payload) throws IOException {
        super.afterSend(payload);
        if (payload != null && payload.getUrgent() && !this.noDelay && this.comm.getDelayControlEnable()) {
            this.comm.setNoDelayEnable(false);
        }
    }

    public Communication getComm() {
        return this.comm;
    }
}

