/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.comms;

import edu.uml.lgdc.math.Search;

public class ConnectionType {
    public static final int CONNECTION_TYPE_TCPIP = 0;
    public static final int CONNECTION_TYPE_SERIAL = 1;
    public static final int CONNECTION_TYPE_UDP = 2;
    public static final String[] CONNECTION_TYPE_NAMES = new String[]{"tcpip", "serial", "udp"};
    public static final int RATE_9600 = 0;
    public static final int RATE_19200 = 1;
    public static final int RATE_38400 = 2;
    public static final int RATE_57600 = 3;
    public static final int RATE_115200 = 4;
    public static final int[] RATES = new int[]{9600, 19200, 38400, 57600, 115200};

    public static String getConnectionTypeName(int ident) {
        if (ident < 0 || ident >= CONNECTION_TYPE_NAMES.length) {
            throw new IllegalArgumentException("Connection Type Ident is illegal, " + ident);
        }
        return CONNECTION_TYPE_NAMES[ident];
    }

    public static int getConnectionTypeIdent(String name, int defaultIdent) {
        int ident = Search.scanStrIgnoreCase(CONNECTION_TYPE_NAMES, name);
        if (ident < 0) {
            ident = defaultIdent;
        }
        return ident;
    }
}

