/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.comms;

import edu.uml.lgdc.comms.Communication;
import edu.uml.lgdc.project.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;

public class FileCommunication
implements Communication {
    private String filename;
    private boolean silentMode;
    private InputStream is;

    public FileCommunication(String filename) {
        this(filename, false);
    }

    public FileCommunication(String filename, boolean silentMode) {
        if (filename == null) {
            throw new IllegalArgumentException("filename is null");
        }
        if (!new File(filename).isFile()) {
            throw new IllegalArgumentException("filename is not a file");
        }
        this.filename = filename;
        this.silentMode = silentMode;
    }

    @Override
    public boolean connect() {
        return this.connect(0);
    }

    @Override
    public boolean connect(int milliSec) {
        boolean result = true;
        try {
            if (this.is != null) {
                this.is.close();
                this.is = null;
            }
            this.is = new FileInputStream(this.filename);
            if (!this.silentMode) {
                Console.showMsg("File " + this.filename + " is opened for stream input");
            }
        }
        catch (IOException e) {
            result = false;
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() {
        return null;
    }

    @Override
    public boolean getDelayControlEnable() {
        return false;
    }

    @Override
    public boolean getNoDelayEnable() throws SocketException {
        return false;
    }

    @Override
    public void setNoDelayEnable(boolean value) throws SocketException {
    }

    @Override
    public int getTimeout() throws SocketException {
        return 0;
    }

    @Override
    public void setTimeout(int milliSec) throws SocketException {
    }

    @Override
    public void close() {
        if (this.is != null) {
            try {
                this.is.close();
                if (!this.silentMode) {
                    Console.showMsg("File " + this.filename + " is closed for stream input");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.is = null;
        }
    }
}

