/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.comms;

import edu.uml.lgdc.comms.Communication;
import edu.uml.lgdc.instrument.ConnectionSettings_Ix;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.DebugParam;
import edu.uml.lgdc.time.TimeScale;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class SCCommunication
implements Communication,
SerialPortEventListener {
    private static final int OPEN_PORT_TIMEOUT_MS = 2000;
    private static final int CARRIER_LOST_TIMEOUT_MS = 2000;
    private static final int INPUT_BUF_SIZE = Short.MAX_VALUE;
    private static final int OUTPUT_BUF_SIZE = Short.MAX_VALUE;
    private ConnectionSettings_Ix settings;
    protected CommPortIdentifier portId;
    protected String commName;
    protected SerialPort serialPort;
    protected InputStream is;
    protected OutputStream os;
    protected int connectCount;
    private boolean carrierDetected;
    private boolean clearToSend;
    private boolean dataSetReady;
    private boolean frameError;
    private boolean overrunError;
    private boolean parityError;
    private boolean useInConnectThread;

    public SCCommunication(String commName, ConnectionSettings_Ix settings) {
        this.commName = commName;
        this.settings = settings;
    }

    public void setUseInConnectThread(boolean value) {
        this.useInConnectThread = value;
    }

    @Override
    public boolean connect() {
        return this.connect(0);
    }

    @Override
    public boolean connect(int milliSec) {
        boolean result;
        block17: {
            result = true;
            ++this.connectCount;
            if (!this.useInConnectThread || this.connectCount == 1) {
                try {
                    this.portId = CommPortIdentifier.getPortIdentifier((String)this.settings.getComName());
                }
                catch (NoSuchPortException e) {
                    throw new RuntimeException("No such port: " + this.settings.getComName());
                }
                if (this.portId.getPortType() != 1) {
                    throw new RuntimeException("Not a serial port: " + this.settings.getComName());
                }
                String errMsg = this.openPort();
                if (errMsg != null) {
                    throw new IllegalArgumentException("The following error occurred during opening " + this.settings.getComName() + "\n" + errMsg);
                }
                if (this.useInConnectThread) {
                    Console.showMsg("Port " + this.commName + " on " + this.settings.getComName() + ", rate = " + this.settings.getRate() + ": waiting for carrier...");
                }
                this.frameError = false;
                this.overrunError = false;
                this.parityError = false;
            }
            if (this.carrierDetected) break block17;
            if (!this.useInConnectThread) {
                Console.showError("Port " + this.commName + " on " + this.settings.getComName() + ", rate = " + this.settings.getRate() + ": not connected!");
            }
            return false;
        }
        try {
            this.serialPort.setInputBufferSize(Short.MAX_VALUE);
            this.serialPort.setOutputBufferSize(Short.MAX_VALUE);
            Console.showMsg("Port " + this.commName + " on " + this.settings.getComName() + ", rate = " + this.settings.getRate() + ": connected");
            this.connectCount = 0;
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException errMsg) {
                    // empty catch block
                }
                this.is = null;
            }
            if (this.os != null) {
                try {
                    this.os.close();
                }
                catch (IOException errMsg) {
                    // empty catch block
                }
                this.os = null;
            }
            this.is = new ControlledInputStream(this.serialPort.getInputStream());
            this.os = new ControlledOutputStream(this.serialPort.getOutputStream());
            if (DebugParam.debug) {
                boolean useRcvTimeout = this.serialPort.isReceiveTimeoutEnabled();
                boolean useRcvThreshold = this.serialPort.isReceiveThresholdEnabled();
                Console.showMsg("buf size: inp = " + this.serialPort.getInputBufferSize() + ", out = " + this.serialPort.getOutputBufferSize() + "\n" + "rcv timeout: " + (useRcvTimeout ? "ENABLED, " + this.serialPort.getReceiveTimeout() + " ms" : "DISABLED") + "\n" + "rcv threshold: " + (useRcvThreshold ? "ENABLED, " + this.serialPort.getReceiveThreshold() + " bytes" : "DISABLED"));
            }
        }
        catch (IOException e) {
            result = false;
            System.out.println(String.valueOf(this.commName) + ": " + e.toString());
        }
        return result;
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    public String getPortName() {
        return this.settings.getComName();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.os;
    }

    @Override
    public boolean getDelayControlEnable() {
        return false;
    }

    @Override
    public boolean getNoDelayEnable() throws IOException {
        return false;
    }

    @Override
    public void setNoDelayEnable(boolean value) throws IOException {
    }

    @Override
    public int getTimeout() throws IOException {
        return 0;
    }

    @Override
    public void setTimeout(int milliSec) throws IOException {
    }

    @Override
    public void close() {
        this.connectCount = 0;
        if (this.serialPort != null) {
            try {
                if (this.is != null) {
                    this.is.close();
                    this.is = null;
                }
                if (this.os != null) {
                    this.os.close();
                    this.os = null;
                }
                if (this.serialPort != null) {
                    this.serialPort.close();
                    this.serialPort = null;
                }
                Console.showMsg("Port " + this.settings.getComName() + " on " + this.settings.getRate() + " closed.");
            }
            catch (IOException e) {
                Console.printThreadStackTrace(e);
            }
        }
    }

    private String openPort() {
        String errMsg = null;
        try {
            this.serialPort = (SerialPort)this.portId.open(this.commName, 2000);
            this.carrierDetected = this.serialPort.isCD();
            this.dataSetReady = this.serialPort.isDSR();
            this.clearToSend = this.serialPort.isCTS();
            this.serialPort.addEventListener((SerialPortEventListener)this);
            this.serialPort.notifyOnCarrierDetect(true);
            this.serialPort.notifyOnCTS(true);
            this.serialPort.notifyOnDSR(true);
            this.serialPort.notifyOnFramingError(true);
            this.serialPort.notifyOnOverrunError(true);
            this.serialPort.notifyOnParityError(true);
            this.serialPort.notifyOnDataAvailable(true);
            this.serialPort.setSerialPortParams(this.settings.getRate(), 8, 1, 0);
            if (this.settings.getHardwareFlowControlEnable()) {
                this.serialPort.setFlowControlMode(3);
            }
        }
        catch (PortInUseException e) {
            errMsg = e.toString();
        }
        catch (TooManyListenersException e) {
            errMsg = e.toString();
        }
        catch (UnsupportedCommOperationException e) {
            errMsg = e.toString();
        }
        if (errMsg != null) {
            System.out.println("The following error occurred during opening " + this.portId.getName());
            System.out.println(errMsg);
        }
        return errMsg;
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 7: {
                this.overrunError = event.getNewValue();
                if (!DebugParam.debug) break;
                Console.showMsg("***ERROR: overrun = " + this.overrunError);
                break;
            }
            case 9: {
                this.frameError = event.getNewValue();
                if (!DebugParam.debug) break;
                Console.showMsg("***ERROR: frame = " + this.frameError);
                break;
            }
            case 8: {
                if (!DebugParam.debug) break;
                Console.showMsg("***ERROR: parity = " + event.getNewValue());
                break;
            }
            case 2: {
                this.parityError = event.getNewValue();
                if (!DebugParam.debug) break;
                Console.showMsg("***EVENT: Output Empty = " + this.parityError);
                break;
            }
            case 6: {
                this.carrierDetected = event.getNewValue();
                if (!this.carrierDetected) {
                    new TimeScale().getTimeInMilliSeconds();
                }
                Console.showMsg("***EVENT: Carrier Detect = " + this.carrierDetected);
                break;
            }
            case 3: {
                this.clearToSend = event.getNewValue();
                if (!DebugParam.debug) break;
                Console.showMsg("***EVENT: Clear To Send  = " + this.clearToSend);
                break;
            }
            case 4: {
                this.dataSetReady = event.getNewValue();
                if (!DebugParam.debug) break;
                Console.showMsg("***EVENT: Data Set Ready = " + this.dataSetReady);
            }
        }
    }

    private void waitForCarrier(Closeable stream) throws IOException {
        block4: {
            if (!this.carrierDetected) {
                int millisecWait = 0;
                do {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    millisecWait += 100;
                    if (this.carrierDetected) break block4;
                } while (millisecWait <= 2000);
                stream.close();
                throw new CarrierLostException();
            }
        }
    }

    private class CarrierLostException
    extends IOException {
    }

    private class ControlledInputStream
    extends InputStream {
        private InputStream delegate;
        private boolean closed = false;

        public ControlledInputStream(InputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public int read() throws IOException {
            if (this.closed) {
                throw new IllegalStateException("Attempt to read from closed input stream");
            }
            SCCommunication.this.waitForCarrier(this.delegate);
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            SCCommunication.this.waitForCarrier(this.delegate);
            return this.delegate.read(b, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
            this.closed = true;
        }
    }

    private class ControlledOutputStream
    extends OutputStream {
        private OutputStream delegate;
        private boolean closed = false;

        public ControlledOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("Attempt to write on closed output stream");
            }
            SCCommunication.this.waitForCarrier(this.delegate);
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            SCCommunication.this.waitForCarrier(this.delegate);
            this.delegate.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
            this.closed = true;
        }
    }
}

