/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.comms;

import edu.uml.lgdc.comms.Communication;
import edu.uml.lgdc.comms.UDPInputStream;
import edu.uml.lgdc.comms.UDPOutputStream;
import edu.uml.lgdc.instrument.ConnectionSettings_Ix;
import edu.uml.lgdc.project.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;

public class UDPCommunication
implements Communication {
    private ConnectionSettings_Ix settings;
    private InputStream is;
    private OutputStream os;
    private SocketAddress socketAddress;
    private DatagramSocket readSocket;
    private DatagramSocket writeSocket;

    public UDPCommunication(ConnectionSettings_Ix settings) {
        this.settings = settings;
    }

    @Override
    public boolean connect() {
        return this.connect(0);
    }

    @Override
    public boolean connect(int milliSec) {
        boolean result = true;
        try {
            if (this.readSocket != null) {
                this.readSocket.close();
                this.readSocket = null;
            }
            if (this.writeSocket != null) {
                this.writeSocket.close();
                this.writeSocket = null;
            }
            InetAddress.getByName(this.settings.getIPAddress());
            this.writeSocket = new DatagramSocket();
            int writePort = this.settings.getPort();
            if (this.settings.getIPAddress().equals("localhost")) {
                ++writePort;
            }
            this.readSocket = new DatagramSocket(this.settings.getPort());
            this.socketAddress = new InetSocketAddress(this.settings.getIPAddress(), writePort);
            this.readSocket.setSoTimeout(0);
            this.writeSocket.setSoTimeout(0);
            this.readSocket.setReceiveBufferSize(this.settings.getRcvBufferSize());
            Console.showMsg("UDP: ready to communicate with IP " + this.settings.getIPAddress() + ", Port " + this.settings.getPort());
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.is = null;
            }
            if (this.os != null) {
                try {
                    this.os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.os = null;
            }
            this.is = new UDPInputStream(this.readSocket, this.settings.getUDPMaxSize());
            this.os = new UDPOutputStream(this.writeSocket, this.socketAddress, this.settings.getUDPMaxSize());
        }
        catch (IOException e) {
            result = false;
            Console.showMsg("UDPCommunication.connect(): " + e.toString());
        }
        return result;
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.os;
    }

    @Override
    public boolean getDelayControlEnable() {
        return false;
    }

    @Override
    public boolean getNoDelayEnable() throws SocketException {
        return false;
    }

    @Override
    public void setNoDelayEnable(boolean value) throws SocketException {
    }

    @Override
    public int getTimeout() throws SocketException {
        return this.readSocket.getSoTimeout();
    }

    @Override
    public void setTimeout(int milliSec) throws SocketException {
        this.readSocket.setSoTimeout(milliSec);
        this.writeSocket.setSoTimeout(milliSec);
    }

    @Override
    public void close() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.is = null;
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.os = null;
        }
        if (this.readSocket != null) {
            if (!this.readSocket.isClosed()) {
                this.readSocket.close();
            }
            this.readSocket = null;
        }
        if (this.writeSocket != null) {
            if (!this.writeSocket.isClosed()) {
                this.writeSocket.close();
            }
            this.writeSocket = null;
        }
    }

    protected void finalize() {
        this.close();
    }
}

