/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.dashboard;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class ByteBufferUtil {
    public ByteBuffer addToByteBuffer(byte value, ByteBuffer existingBuffer) {
        ByteBuffer newBuffer = ByteBuffer.allocate(8 + existingBuffer.limit());
        newBuffer.put(existingBuffer);
        newBuffer.put(value);
        newBuffer.rewind();
        return newBuffer;
    }

    public ByteBuffer addToByteBuffer(byte[] byteArray, ByteBuffer existingBuffer) {
        ByteBuffer newBuffer = ByteBuffer.allocate(byteArray.length + existingBuffer.limit());
        newBuffer.put(existingBuffer);
        newBuffer.put(byteArray);
        newBuffer.rewind();
        return newBuffer;
    }

    public ByteBuffer addToByteBuffer(byte[] byteArray, int numOfBytes, ByteBuffer existingBuffer) {
        ByteBuffer newBuffer = ByteBuffer.allocate(numOfBytes + existingBuffer.limit());
        newBuffer.put(existingBuffer);
        int i = 0;
        while (i < numOfBytes) {
            newBuffer.put(byteArray[i]);
            ++i;
        }
        newBuffer.rewind();
        return newBuffer;
    }

    public ByteBuffer addToByteBuffer(long value, ByteBuffer existingBuffer) {
        ByteBuffer newBuffer = ByteBuffer.allocate(8 + existingBuffer.limit());
        newBuffer.put(existingBuffer);
        newBuffer.putLong(value);
        newBuffer.rewind();
        return newBuffer;
    }

    public ByteBuffer addToByteBuffer(int value, ByteBuffer existingBuffer) {
        ByteBuffer newBuffer = ByteBuffer.allocate(4 + existingBuffer.limit());
        newBuffer.put(existingBuffer);
        newBuffer.putInt(value);
        newBuffer.rewind();
        return newBuffer;
    }

    public ByteBuffer addToByteBuffer(String string, Charset charset, ByteBuffer existingBuffer) {
        ByteBuffer tempBuffer = this.addToByteBuffer(string.length(), existingBuffer);
        ByteBuffer stringBuffer = ByteBuffer.wrap(string.getBytes(charset));
        ByteBuffer newBuffer = ByteBuffer.allocate(stringBuffer.limit() + tempBuffer.limit());
        newBuffer.put(tempBuffer);
        newBuffer.put(stringBuffer);
        newBuffer.rewind();
        return newBuffer;
    }

    public ByteBuffer addToByteBuffer(boolean value, ByteBuffer existingBuffer) {
        ByteBuffer newBuffer = ByteBuffer.allocate(1 + existingBuffer.limit());
        newBuffer.put(existingBuffer);
        byte byteValue = value ? (byte)1 : 0;
        newBuffer.put(byteValue);
        newBuffer.rewind();
        return newBuffer;
    }

    public byte removeByteFromBuffer(ByteBuffer buffer) {
        int newPosition = 1;
        buffer.position(0);
        byte value = buffer.get();
        buffer.position(newPosition);
        buffer.compact();
        return value;
    }

    public byte[] removeByteArrayFromBuffer(int byteArraySize, ByteBuffer buffer) {
        int newPosition = 0;
        buffer.position(0);
        byte[] byteArray = new byte[buffer.limit()];
        if (buffer.limit() >= byteArraySize) {
            newPosition = byteArraySize * 1;
            buffer.get(byteArray);
            byteArray = Arrays.copyOfRange(byteArray, 0, byteArraySize);
        }
        buffer.position(newPosition);
        buffer.compact();
        return byteArray;
    }

    public long removeLongFromBuffer(ByteBuffer buffer) {
        int newPosition = 8;
        buffer.position(0);
        Long value = buffer.getLong();
        buffer.position(newPosition);
        buffer.compact();
        return value;
    }

    public int removeIntFromBuffer(ByteBuffer buffer) {
        int newPosition = 4;
        buffer.position(0);
        int value = buffer.getInt();
        buffer.position(newPosition);
        buffer.compact();
        return value;
    }

    public String removeStringFromBuffer(ByteBuffer buffer) {
        int stringLength;
        int newPosition = stringLength = this.removeIntFromBuffer(buffer);
        buffer.position(0);
        byte[] byteArray = new byte[stringLength];
        buffer.get(byteArray, 0, stringLength);
        buffer.position(newPosition);
        buffer.compact();
        return new String(byteArray);
    }

    public boolean removeBoolFromBuffer(ByteBuffer buffer) {
        int newPosition = 1;
        buffer.position(0);
        byte value = buffer.get();
        buffer.position(newPosition);
        buffer.compact();
        return value == 1;
    }
}

