/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.database;

import edu.uml.lgdc.fileio.FileUtils;
import edu.uml.lgdc.fileio.InputStreamOperator;
import edu.uml.lgdc.fileio.PartOfFileInputStream;
import edu.uml.lgdc.fileio.UniqueFile;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class DBUtil {
    private static final int MAX_STREAM_ARRAY_SIZE = 2000000;
    private static final int DEFAULT_BUFFER_SIZE = 200000;
    private static final short USE_FILE_FOR_BLOB = 1;
    private static final short USE_BYTE_ARRAY_FOR_BLOB = 2;
    private static final String INTERBASE_DRIVER_STR = "jdbc:interbase://";
    private static final String FIREBIRD_DRIVER_STR = "jdbc:firebirdsql://";

    public static String getAllSQLExceptions(SQLException e) {
        String str = "";
        SQLException next = e;
        while (next != null) {
            str = String.valueOf(str) + next.getMessage() + "\n";
            str = String.valueOf(str) + "Error Code: " + next.getErrorCode() + "\n";
            str = String.valueOf(str) + "SQL State: " + next.getSQLState() + "\n";
            next = next.getNextException();
        }
        return str;
    }

    public static void showSQLError(SQLException e) {
        DBUtil.showSQLError(e, null);
    }

    public static void showSQLError(SQLException e, String message) {
        message = message != null && !message.equals("") ? String.valueOf(message) + "\n" : "";
        message = String.valueOf(message) + e.getMessage() + "\n" + "Error Code: " + e.getErrorCode() + "\n" + "SQL State: " + e.getSQLState();
        Console.showError(message);
    }

    public static int writeTextFromFile(int dbFieldNumber, String fileName, long offset, int length, PreparedStatement pstmt, Charset charset) throws SQLException, IOException {
        try (InputStream inputStream = null;){
            inputStream = new PartOfFileInputStream(fileName, offset, (long)length);
            int n = DBUtil.writeTextFromInputStream(dbFieldNumber, inputStream, pstmt, length, charset);
            return n;
        }
    }

    public static int writeTextFromInputStream(int dbFieldNumber, InputStream inputStream, PreparedStatement pstmt, int length, Charset charset) throws SQLException, IOException {
        try {
            String str = FileUtils.streamToString(inputStream, charset);
            pstmt.setString(dbFieldNumber, str);
            int updated = pstmt.executeUpdate();
            inputStream.close();
            int n = updated;
            return n;
        }
        finally {
            inputStream.close();
        }
    }

    public static int writeBlobFromFileUsingOperator(InputStreamOperator oper, int dbFieldNumber, String fileName, long offset, int length, PreparedStatement pstmt) throws SQLException, IOException {
        return DBUtil.writeBlobFromFile(oper, dbFieldNumber, fileName, offset, length, pstmt);
    }

    public static int writeBlobFromFile(int dbFieldNumber, String fileName, long offset, int length, PreparedStatement pstmt) throws SQLException, IOException {
        return DBUtil.writeBlobFromFile(null, dbFieldNumber, fileName, offset, length, pstmt);
    }

    private static int writeBlobFromFile(InputStreamOperator oper, int dbFieldNumber, String fileName, long offset, int length, PreparedStatement pstmt) throws SQLException, IOException {
        InputStream inputStream = null;
        try {
            inputStream = new PartOfFileInputStream(fileName, offset, (long)length);
            if (oper != null) {
                oper.setInputStream(inputStream);
                inputStream = oper;
            }
            int n = DBUtil.writeBlobFromInputStream(dbFieldNumber, inputStream, pstmt, length);
            return n;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
            }
        }
    }

    public static int writeCompressedBlobFromFileUsingOperator(InputStreamOperator oper, int dbFieldNumber, String fileName, long offset, int length, PreparedStatement pstmt, String path) throws SQLException, IOException {
        return DBUtil.writeCompressedBlobFromFile(oper, dbFieldNumber, fileName, offset, length, pstmt, path);
    }

    public static int writeCompressedBlobFromFile(int dbFieldNumber, String fileName, long offset, int length, PreparedStatement pstmt, String path) throws SQLException, IOException {
        return DBUtil.writeCompressedBlobFromFile(null, dbFieldNumber, fileName, offset, length, pstmt, path);
    }

    private static int writeCompressedBlobFromFile(InputStreamOperator oper, int dbFieldNumber, String fileName, long offset, int length, PreparedStatement pstmt, String path) throws SQLException, IOException {
        try (InputStream inputStream = null;){
            inputStream = new PartOfFileInputStream(fileName, offset, (long)length);
            if (oper != null) {
                oper.setInputStream(inputStream);
                inputStream = oper;
            }
            int mode = length > 2000000 ? 1 : 2;
            int n = DBUtil.writeCompressedBlobFromStream(dbFieldNumber, inputStream, pstmt, mode == 1, path);
            return n;
        }
    }

    public static int writeCompressedBlobFromStream(int dbFieldNumber, InputStream input, PreparedStatement pstmt, boolean useFile, String path) throws SQLException, IOException {
        int result = -1;
        String tempFile = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        ZipOutputStream zOutputStream = null;
        try {
            int size;
            if (useFile) {
                tempFile = UniqueFile.create(path);
                outputStream = new FileOutputStream(tempFile);
            } else {
                outputStream = new ByteArrayOutputStream(200000);
            }
            zOutputStream = new ZipOutputStream(outputStream);
            zOutputStream.setLevel(9);
            zOutputStream.putNextEntry(new ZipEntry("didb"));
            FileUtils.iStream2oStream(input, zOutputStream);
            zOutputStream.closeEntry();
            zOutputStream.close();
            if (useFile) {
                inputStream = new FileInputStream(tempFile);
                size = (int)new File(tempFile).length();
            } else {
                inputStream = new ByteArrayInputStream(((ByteArrayOutputStream)outputStream).toByteArray());
                size = ((ByteArrayOutputStream)outputStream).size();
            }
            outputStream.close();
            outputStream = null;
            result = DBUtil.writeBlobFromInputStream(dbFieldNumber, inputStream, pstmt, size);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
            }
            if (zOutputStream != null) {
                try {
                    zOutputStream.close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
            }
            if (useFile && tempFile != null) {
                new File(tempFile).delete();
            }
        }
        return result;
    }

    public static int writeBlobFromInputStream(int dbFieldNumber, InputStream input, PreparedStatement pstmt, boolean useFile, String path) throws SQLException, IOException {
        int result = -1;
        String tempFile = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int size;
            if (useFile) {
                tempFile = UniqueFile.create(path);
                outputStream = new FileOutputStream(tempFile);
            } else {
                outputStream = new ByteArrayOutputStream(200000);
            }
            FileUtils.iStream2oStream(input, outputStream);
            if (useFile) {
                outputStream.close();
                inputStream = new FileInputStream(tempFile);
                size = (int)new File(tempFile).length();
            } else {
                inputStream = new ByteArrayInputStream(((ByteArrayOutputStream)outputStream).toByteArray());
                size = ((ByteArrayOutputStream)outputStream).size();
            }
            result = DBUtil.writeBlobFromInputStream(dbFieldNumber, inputStream, pstmt, size);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
            }
            if (useFile && tempFile != null) {
                new File(tempFile).delete();
            }
        }
        return result;
    }

    public static int writeBlobFromInputStream(int dbFieldNumber, InputStream inputStream, PreparedStatement pstmt, int length) throws SQLException, IOException {
        pstmt.setBinaryStream(dbFieldNumber, inputStream, length);
        return pstmt.executeUpdate();
    }

    public static String streamToFile(InputStream inputStream, String fileName) throws IOException {
        File file = new File(fileName);
        if (inputStream != null) {
            FileOutputStream outputStream = null;
            file.delete();
            try {
                outputStream = new FileOutputStream(file);
                FileUtils.iStream2oStream(inputStream, outputStream);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {}
                if (outputStream != null) {
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (IOException ex) {
                        Console.printThreadStackTrace(ex);
                    }
                }
            }
        }
        fileName = null;
        return fileName;
    }

    public static String getFileFromCompressedBlob(String fileName, InputStream inputStream) throws IOException {
        return DBUtil.streamToFile(DBUtil.getInputStreamFromCompressedBlob(inputStream), fileName);
    }

    public static InputStream getInputStreamFromCompressedBlob(InputStream inputStream) throws IOException {
        ZipInputStream zInputStream = new ZipInputStream(inputStream);
        zInputStream.getNextEntry();
        return zInputStream;
    }

    public static String changeInterbaseToFirebirdsql(String url) {
        if (url.startsWith(INTERBASE_DRIVER_STR)) {
            int pos;
            url = Character.isDigit((url = url.substring(INTERBASE_DRIVER_STR.length())).charAt((pos = url.indexOf(47)) + 1)) ? FIREBIRD_DRIVER_STR + url.substring(pos + 1).replaceFirst(":", "/") : FIREBIRD_DRIVER_STR + url;
        }
        return url;
    }

    public static String asInList(Collection<?> collection) {
        if (collection != null && collection.size() != 0) {
            Iterator<?> iter = collection.iterator();
            HashSet set = new HashSet();
            StringBuilder strB = new StringBuilder(128).append(collection.size() == 1 ? "=" : "IN (");
            boolean quoted = false;
            boolean firstElement = true;
            while (iter.hasNext()) {
                Object object = iter.next();
                if (object == null) {
                    throw new IllegalArgumentException("given collection contains nulls, " + collection);
                }
                if (!set.add(object)) continue;
                if (!firstElement) {
                    strB.append(',');
                } else {
                    quoted = object instanceof String || object instanceof TimeScale;
                    firstElement = false;
                }
                if (quoted) {
                    strB.append("'");
                }
                strB.append(object.toString());
                if (!quoted) continue;
                strB.append("'");
            }
            if (collection.size() > 1) {
                strB.append(")");
            }
            return strB.toString();
        }
        throw new IllegalArgumentException("given collection is null or empty, " + collection);
    }
}

