/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.database;

import edu.uml.lgdc.database.ConnectionRequisites;
import edu.uml.lgdc.project.settings.ContentType;
import edu.uml.lgdc.project.settings.OptionDesc;
import edu.uml.lgdc.project.settings.OptionsIO;
import edu.uml.lgdc.project.settings.SectionDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DatabaseConnectionSettings
extends SectionDescriptor {
    public static final String SECTION_NAME = "Database Connections";
    private final Map<String, ConnectionRequisites> databases = new HashMap<String, ConnectionRequisites>();
    protected final Map<String, OptionDesc> descriptor;

    public DatabaseConnectionSettings(String[] databaseNames) {
        String[] stringArray = databaseNames;
        int n = databaseNames.length;
        int n2 = 0;
        while (n2 < n) {
            String databaseName = stringArray[n2];
            this.databases.put(databaseName, ConnectionRequisites.createEmpty());
            ++n2;
        }
        this.descriptor = new HashMap<String, OptionDesc>();
        this.setDefaults();
        this.fillDescriptor();
    }

    public void setDefaults() {
    }

    public DatabaseConnectionSettings getThis() {
        return this;
    }

    @Override
    public String getName() {
        return SECTION_NAME;
    }

    @Override
    public Map<String, OptionDesc> getOptionsDescriptor() {
        return this.descriptor;
    }

    @Override
    public String[] optionRenameHook(String unknowmParamName, String valueOfUnknownParamName) {
        return null;
    }

    @Override
    protected void fillDescriptor() {
        for (Map.Entry<String, ConnectionRequisites> entry : this.databases.entrySet()) {
            this.descriptor.put(entry.getKey(), new OptionDesc((Object)entry.getValue(), ContentType.DBSPEC));
        }
    }

    @Override
    public void getFrom(OptionsIO paramsIO) {
        Iterator<Map.Entry<String, ConnectionRequisites>> iterator = this.databases.entrySet().iterator();
        while (iterator.hasNext()) {
            String strVal;
            Map.Entry<String, ConnectionRequisites> entry;
            this.databases.put(entry.getKey(), (strVal = paramsIO.get(SECTION_NAME, (entry = iterator.next()).getKey())) != null ? ConnectionRequisites.parse(strVal) : ConnectionRequisites.createEmpty());
        }
    }

    @Override
    public void putTo(OptionsIO paramsIO) {
        for (Map.Entry<String, ConnectionRequisites> entry : this.databases.entrySet()) {
            paramsIO.put(SECTION_NAME, entry.getKey(), entry.getValue().toString());
        }
    }

    public ConnectionRequisites getConnectionRequisites(String databaseName) {
        return this.databases.get(databaseName);
    }

    public void setConnectionRequisities(String databaseName, ConnectionRequisites req) {
        this.databases.put(databaseName, req);
    }
}

