/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.database;

import java.util.HashMap;
import java.util.Map;

public enum DatabaseContents {
    NONE(0L, "NONE", "No contents"),
    IONO_VI(1L, "IONO_VI", "Raw vertical incidence ionogram data"),
    SCALED_VI(2L, "SCALED_VI", "VI ionogram-derived scaled record, complete content"),
    FASTCHAR_VI(4L, "FASTCHAR_VI", "VI ionogram-derived scaled record, only a subset of characteristics"),
    DOP_VI(8L, "DOP_VI", "Raw 4-channel VI spectral data in UMS format"),
    DFT_VI(16L, "DFT_VI", "Raw 4-channel VI spectral data in legady DFT format"),
    SKY_VI(32L, "SKY_VI", "VI skymaps derived from raw VI spectral data"),
    DVL_VI(64L, "DVL_VI", "Overhead bulk velocity of plasma drift from VI skymaps"),
    TLT_VI(128L, "TLT_VI", "Tilt of overhead ionosphere from VI skymaps"),
    DOP_OI(256L, "DOP_OI", "Oblique incidence raw 4-channel spectral data in UMS format"),
    SKY_OI(512L, "SKY_OI", "OI skymaps derived from raw OI spectral data"),
    TID(1024L, "TID", "TRaveling ionospheric disturbance parameters derived from DOP_VI, DOP_OI, or TAV spectra data and signal tracks"),
    IONO_OI(2048L, "IONO_OI", "Raw oblique incidence ionogram data"),
    SCALED_OI(4096L, "SCALED_OI", "VI ionogram-derived scaled record, complete content"),
    TAV(8192L, "TAV", "Time-domain averaged RF samples"),
    IRTAM(16384L, "IRTAM", "IRTAM coefficients and 24-hour time series from SCALED_VI"),
    RPI(32768L, "RPI", "NASA Radio Plasma Imager"),
    TNT(65536L, "TNT", "AF TNT instrument");

    private static final Map<Long, DatabaseContents> MAP_BY_ID;
    private static final Map<String, DatabaseContents> MAP_BY_NAME;
    private final long id;
    private final String name;
    private final String description;

    static {
        MAP_BY_ID = new HashMap<Long, DatabaseContents>();
        MAP_BY_NAME = new HashMap<String, DatabaseContents>();
        DatabaseContents[] databaseContentsArray = DatabaseContents.values();
        int n = databaseContentsArray.length;
        int n2 = 0;
        while (n2 < n) {
            DatabaseContents contents = databaseContentsArray[n2];
            if (MAP_BY_ID.put(contents.getId(), contents) != null) {
                throw new RuntimeException("design error: duplication of id, " + contents.getId());
            }
            if (MAP_BY_NAME.put(contents.getName(), contents) != null) {
                throw new RuntimeException("design error: duplication of name, " + contents.getName());
            }
            ++n2;
        }
    }

    private DatabaseContents(long id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public long getId() {
        return this.id;
    }

    public boolean isIncluded(long allContents) {
        return (this.id & allContents) != 0L;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public static DatabaseContents get(long id) {
        return MAP_BY_ID.get(id);
    }

    public static DatabaseContents get(String name) {
        return MAP_BY_NAME.get(name.toUpperCase());
    }

    public static String toText(long allDatabaseContents) {
        String output = "";
        DatabaseContents[] databaseContentsArray = DatabaseContents.values();
        int n = databaseContentsArray.length;
        int n2 = 0;
        while (n2 < n) {
            DatabaseContents contents = databaseContentsArray[n2];
            if ((contents.id & allDatabaseContents) != 0L) {
                output = String.valueOf(output) + contents.name + " ";
            }
            ++n2;
        }
        return output;
    }
}

