/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.database;

import edu.uml.lgdc.database.DBConnect;
import edu.uml.lgdc.database.DatabaseContents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatabaseFarm {
    public static final String DIDBASE_NAME = "DIDBase";
    public static final String DOP_DB_NAME = "DOP-DB";
    public static final String TID_DB_NAME = "TID-DB";
    public static final String GAMBIT_DB_NAME = "GAMBIT-DB";
    private final List<DBConnect> connectFarm = new ArrayList<DBConnect>(5);
    private final Map<DatabaseContents, Integer> activeConnections = new HashMap<DatabaseContents, Integer>(5);
    private final Map<DatabaseContents, Integer> preferredConnections = new HashMap<DatabaseContents, Integer>(5);

    public void clear() {
        this.connectFarm.clear();
        this.activeConnections.clear();
        this.preferredConnections.clear();
    }

    public int addConnect(DBConnect connect) {
        int index = this.lookup(connect);
        if (index == -1) {
            this.connectFarm.add(connect);
            index = this.connectFarm.size() - 1;
        }
        return index;
    }

    public void activateDefaultConnections() {
        int i = 0;
        while (i < this.connectFarm.size()) {
            long allContents = this.connectFarm.get((int)i).allContents;
            DatabaseContents[] databaseContentsArray = DatabaseContents.values();
            int n = databaseContentsArray.length;
            int n2 = 0;
            while (n2 < n) {
                DatabaseContents content = databaseContentsArray[n2];
                if ((allContents & content.getId()) != 0L && !this.isActive(content)) {
                    this.activateConnection(content, i);
                }
                ++n2;
            }
            ++i;
        }
    }

    public void activateConnection(DatabaseContents content, int index) {
        if (index < 0 || index >= this.connectFarm.size()) {
            throw new IllegalArgumentException("DatabaseFarm: attempt to set missing connect #" + index + " to " + (Object)((Object)content));
        }
        DBConnect dbconnect = this.connectFarm.get(index);
        int oldIndex = this.getActiveDatabaseIndex(content);
        if (oldIndex == index) {
            return;
        }
        if (oldIndex != -1) {
            this.activeConnections.remove((Object)content);
            Integer oldIndexInteger = new Integer(oldIndex);
            this.activeConnections.values().contains(oldIndexInteger);
        }
        this.activeConnections.put(content, index);
        this.preferredConnections.put(content, dbconnect.databaseId);
    }

    public List<DBConnect> getAllDatabases() {
        return this.connectFarm;
    }

    public DBConnect getActiveDatabaseConnect(DatabaseContents content) {
        int index = this.getActiveDatabaseIndex(content);
        if (index == -1) {
            return null;
        }
        return this.connectFarm.get(index);
    }

    public int getActiveDatabaseIndex(DatabaseContents content) {
        Integer i = this.activeConnections.get((Object)content);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public boolean isActive(DatabaseContents content) {
        return this.getActiveDatabaseIndex(content) != -1;
    }

    public int lookup(DBConnect connect) {
        int i = 0;
        while (i < this.connectFarm.size()) {
            if (this.connectFarm.get(i).equals(connect)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lookupByUrl(String url) {
        int i = 0;
        while (i < this.connectFarm.size()) {
            if (this.connectFarm.get(i).getRequisites().getURL().equals(url)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Map<DatabaseContents, Integer> getActiveConnections() {
        return this.activeConnections;
    }

    public boolean isAvailable(DatabaseContents content) {
        long contentId = content.getId();
        int i = 0;
        while (i < this.connectFarm.size()) {
            long allContents = this.connectFarm.get((int)i).allContents;
            if ((allContents & contentId) != 0L) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public long getAllContents(boolean onlyActiveOnes) {
        long contentIDs = 0L;
        if (onlyActiveOnes) {
            for (Map.Entry<DatabaseContents, Integer> oneConnection : this.activeConnections.entrySet()) {
                DatabaseContents contents = oneConnection.getKey();
                contentIDs += contents.getId();
            }
        } else {
            int i = 0;
            while (i < this.connectFarm.size()) {
                contentIDs += this.connectFarm.get((int)i).allContents;
                ++i;
            }
        }
        return contentIDs;
    }

    public void close() {
        for (DBConnect dbconnect : this.connectFarm) {
            if (dbconnect == null) continue;
            dbconnect.close();
        }
    }
}

