/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.database;

import java.util.HashMap;
import java.util.Map;

public enum DatabaseURL {
    DIDB(1, "didb", "jdbc:firebirdsql", "didbase.giro.uml.edu", "org.firebirdsql.jdbc.FBDriver"),
    DRIFT(2, "drift", "jdbc:firebirdsql", "drift.giro.uml.edu", "org.firebirdsql.jdbc.FBDriver"),
    GAMBIT(3, "gambit", "jdbc:firebirdsql", "d2d.giro.uml.edu", "org.firebirdsql.jdbc.FBDriver"),
    D2D(4, "d2d", "jdbc:firebirdsql", "d2d.giro.uml.edu", "org.firebirdsql.jdbc.FBDriver"),
    TAV(5, "tav", "jdbc:firebirdsql", "d2d.giro.uml.edu", "org.firebirdsql.jdbc.FBDriver"),
    TID(6, "tid", "jdbc:firebirdsql", "tidbase.giro.uml.edu", "org.firebirdsql.jdbc.FBDriver"),
    RPI(7, "rpi", "jdbc:firebirdsql", "rpi.giro.uml.edu", "org.firebirdsql.jdbc.FBDriver"),
    TNT(8, "tnt", "jdbc:firebirdsql", "drtnt.giro.uml.edu", "org.firebirdsql.jdbc.FBDriver"),
    LOUIDB(9, "loui", "jdbc:firebirdsql", "rpi.giro.uml.edu", "org.firebirdsql.jdbc.FBDriver"),
    VTBDB(10, "vtb", "jdbc:firebirdsql", "tid.giro.uml.edu", "org.firebirdsql.jdbc.FBDriver");

    private static final Map<Integer, DatabaseURL> MAP_BY_ID;
    private static final Map<String, DatabaseURL> MAP_BY_NAME;
    private final int id;
    private final String dbName;
    private final String protocol;
    private final String host;
    private final String driverClassName;

    static {
        MAP_BY_ID = new HashMap<Integer, DatabaseURL>();
        MAP_BY_NAME = new HashMap<String, DatabaseURL>();
        DatabaseURL[] databaseURLArray = DatabaseURL.values();
        int n = databaseURLArray.length;
        int n2 = 0;
        while (n2 < n) {
            DatabaseURL databaseURL = databaseURLArray[n2];
            if (MAP_BY_ID.put(databaseURL.getId(), databaseURL) != null) {
                throw new RuntimeException("design error: duplication of id, " + databaseURL.getId());
            }
            if (MAP_BY_NAME.put(databaseURL.getDbName().toUpperCase(), databaseURL) != null) {
                throw new RuntimeException("design error: duplication of DB name, " + databaseURL.getDbName());
            }
            ++n2;
        }
    }

    private DatabaseURL(int id, String dbName, String protocol, String host, String driverClassName) {
        this.id = id;
        this.dbName = dbName;
        this.protocol = protocol;
        this.host = host;
        this.driverClassName = driverClassName;
    }

    public int getId() {
        return this.id;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getURL() {
        return String.valueOf(this.protocol) + "://" + this.host + "/" + this.dbName;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public static DatabaseURL get(int id) {
        return MAP_BY_ID.get(id);
    }

    public static DatabaseURL get(String name) {
        return MAP_BY_NAME.get(name.toUpperCase());
    }
}

