/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.database;

import edu.uml.lgdc.database.DBUtil;
import edu.uml.lgdc.time.TimeScale;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MeasurementQueryFilter {
    protected TimeScale minTime;
    protected boolean minTimeIncluded = true;
    protected TimeScale maxTime;
    protected boolean maxTimeIncluded;
    protected Set<String> stationUniqueCodes;
    protected Map<String, Set<TimeScale>> notIncludedStationTimes;

    public MeasurementQueryFilter() {
    }

    public MeasurementQueryFilter(TimeScale minTime, TimeScale maxTime) {
        this(minTime, true, maxTime, false);
    }

    public MeasurementQueryFilter(TimeScale minTime, boolean minTimeIncluded, TimeScale maxTime, boolean maxTimeIncluded) {
        this.minTime = minTime;
        this.minTimeIncluded = minTimeIncluded;
        this.maxTime = maxTime;
        this.maxTimeIncluded = maxTimeIncluded;
    }

    public boolean acceptTime(TimeScale time) {
        if (this.minTime != null && (time.before(this.minTime) || !this.minTimeIncluded && time.equals(this.minTime))) {
            return false;
        }
        return this.maxTime == null || !this.maxTime.before(time) && (this.maxTimeIncluded || !time.equals(this.maxTime));
    }

    public boolean acceptStation(String stationUniqueCode) {
        return this.stationUniqueCodes == null || this.stationUniqueCodes.contains(stationUniqueCode.toUpperCase());
    }

    public TimeScale getMinTime() {
        return this.minTime;
    }

    public void setMinTime(TimeScale minTime) {
        this.minTime = minTime;
    }

    public boolean isMinTimeIncluded() {
        return this.minTimeIncluded;
    }

    public void setMinTimeIncluded(boolean minTimeIncluded) {
        this.minTimeIncluded = minTimeIncluded;
    }

    public TimeScale getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(TimeScale maxTime) {
        this.maxTime = maxTime;
    }

    public boolean isMaxTimeIncluded() {
        return this.maxTimeIncluded;
    }

    public void setMaxTimeIncluded(boolean maxTimeIncluded) {
        this.maxTimeIncluded = maxTimeIncluded;
    }

    public Set<String> getStationUniqueCodes() {
        return this.stationUniqueCodes;
    }

    public void setStationUniqueCodes(Set<String> stationUniqueCodes) {
        if (stationUniqueCodes != null) {
            this.stationUniqueCodes = new HashSet<String>(2 * stationUniqueCodes.size(), 0.5f);
            for (String stationCode : stationUniqueCodes) {
                this.stationUniqueCodes.add(stationCode.toUpperCase());
            }
        } else {
            this.stationUniqueCodes = null;
        }
    }

    public void setStationUniqueCode(String stationUniqueCode) {
        this.stationUniqueCodes = new HashSet<String>(Arrays.asList(stationUniqueCode.toUpperCase()));
    }

    public Map<String, Set<TimeScale>> getNotIncludedStationTimes() {
        return this.notIncludedStationTimes;
    }

    public void setNotIncludedStationTimes(Map<String, Set<TimeScale>> notIncludedStationTimes) {
        if (notIncludedStationTimes != null) {
            this.notIncludedStationTimes = new HashMap<String, Set<TimeScale>>(2 * notIncludedStationTimes.size(), 0.5f);
            Set<Map.Entry<String, Set<TimeScale>>> entries = notIncludedStationTimes.entrySet();
            for (Map.Entry<String, Set<TimeScale>> entry : entries) {
                this.notIncludedStationTimes.put(entry.getKey().toUpperCase(), entry.getValue());
            }
        } else {
            this.notIncludedStationTimes = null;
        }
    }

    public StringBuilder appendNotIncludedStationTimes(StringBuilder strB, String stationCodeFildName, String TimeFieldName) {
        if (this.notIncludedStationTimes != null) {
            strB.append(" AND NOT (");
            Set<String> keys = this.notIncludedStationTimes.keySet();
            boolean stationAdded = false;
            for (String stationCode : keys) {
                Set<TimeScale> set = this.notIncludedStationTimes.get(stationCode);
                if (set == null || set.isEmpty()) continue;
                if (stationAdded) {
                    strB.append(" || ");
                } else {
                    stationAdded = true;
                }
                strB.append("(");
                strB.append(stationCodeFildName).append("='").append(stationCode).append("' AND ");
                strB.append(TimeFieldName).append(DBUtil.asInList(set));
                strB.append(")");
            }
            strB.append(")");
        }
        return strB;
    }
}

