/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.database;

import edu.uml.lgdc.database.FieldType;
import edu.uml.lgdc.database.FirebirdUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class TableRec {
    protected String tableName;
    protected String keyFieldName;
    protected String[] fieldNames;
    protected FieldType[] fieldTypes;
    protected Object[] fieldValues;

    public TableRec() {
        this.fillTableDesc();
    }

    protected TableRec(Statement statement, int ident) throws SQLException {
        this();
        this.fill(statement, ident);
    }

    protected abstract void fillTableDesc();

    protected abstract void assignFieldValues(Object[] var1);

    protected abstract void assign(TableRec var1);

    private TableRec fill(Statement statement, int ident) throws SQLException {
        String queryStr = "SELECT " + this.getAllFieldNamesListForSelect() + " FROM " + this.tableName + " WHERE " + this.keyFieldName + " = " + ident;
        Throwable throwable = null;
        Object var5_6 = null;
        try (ResultSet rs = statement.executeQuery(queryStr);){
            if (rs.next()) {
                this.fillValuesFromResultSet(rs);
                this.assignFieldValues(this.fieldValues);
            } else {
                System.out.println("Couldn't find " + this.tableName + " with id = " + ident);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this;
    }

    private String getAllFieldNamesListForSelect() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.fieldNames.length) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.fieldNames[i]);
            ++i;
        }
        return sb.toString();
    }

    private void fillValuesFromResultSet(ResultSet rs) throws SQLException {
        int i = 0;
        while (i < this.fieldNames.length) {
            switch (this.fieldTypes[i]) {
                case TYPE_INT: {
                    this.fieldValues[i] = new Integer(rs.getInt(i + 1));
                    break;
                }
                case TYPE_FLOAT: {
                    this.fieldValues[i] = new Float(rs.getFloat(i + 1));
                    break;
                }
                case TYPE_DOUBLE: {
                    this.fieldValues[i] = new Double(rs.getDouble(i + 1));
                    break;
                }
                case TYPE_STRING: {
                    this.fieldValues[i] = rs.getString(i + 1);
                    break;
                }
                case TYPE_TIMESTAMP: {
                    this.fieldValues[i] = FirebirdUtil.getTime(rs, i + 1);
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal type - " + (Object)((Object)this.fieldTypes[i]));
                }
            }
            ++i;
        }
    }
}

