/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.database;

import edu.uml.lgdc.database.FieldType;
import edu.uml.lgdc.database.FirebirdUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public abstract class TableRecs {
    protected String tableName;
    protected String keyFieldName;
    protected String orderFieldName;
    protected String[] fieldNames;
    protected FieldType[] fieldTypes;
    protected Object[] fieldValues;
    protected List<Object> recordValues = new ArrayList<Object>();

    public TableRecs() {
        this.fillTableDesc();
    }

    protected TableRecs(Statement statement, int ident) {
        this();
        this.fill(statement, ident);
    }

    protected abstract void fillTableDesc();

    protected abstract void createEmptyFieldValues();

    protected abstract void assignRecordValues();

    protected abstract void assign(TableRecs var1);

    public TableRecs fill(Statement statement, int ident) {
        String queryStr = "SELECT " + this.getAllFieldNamesListForSelect() + " FROM " + this.tableName + " WHERE " + this.keyFieldName + " = " + ident;
        if (this.orderFieldName != null) {
            queryStr = String.valueOf(queryStr) + " ORDER BY " + this.orderFieldName;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ResultSet rs = statement.executeQuery(queryStr);){
                this.recordValues.clear();
                while (rs.next()) {
                    this.createEmptyFieldValues();
                    this.fillValuesFromResultSet(rs);
                    this.recordValues.add(this.fieldValues);
                }
                this.assignRecordValues();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            System.out.println(e.toString());
        }
        return this;
    }

    private String getAllFieldNamesListForSelect() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.fieldNames.length) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.fieldNames[i]);
            ++i;
        }
        return sb.toString();
    }

    private void fillValuesFromResultSet(ResultSet rs) throws SQLException {
        int i = 0;
        while (i < this.fieldNames.length) {
            switch (this.fieldTypes[i]) {
                case TYPE_INT: {
                    this.fieldValues[i] = new Integer(rs.getInt(i + 1));
                    break;
                }
                case TYPE_FLOAT: {
                    this.fieldValues[i] = new Float(rs.getFloat(i + 1));
                    break;
                }
                case TYPE_DOUBLE: {
                    this.fieldValues[i] = new Double(rs.getDouble(i + 1));
                    break;
                }
                case TYPE_STRING: {
                    this.fieldValues[i] = rs.getString(i + 1);
                    break;
                }
                case TYPE_TIMESTAMP: {
                    this.fieldValues[i] = FirebirdUtil.getTime(rs, i + 1);
                    break;
                }
                default: {
                    System.out.println("Class TableRec: Illegal type - " + (Object)((Object)this.fieldTypes[i]));
                }
            }
            ++i;
        }
    }
}

