/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype;

import edu.uml.lgdc.datatype.AbstractByteBuffer;

public class CIOByteBuffer
extends AbstractByteBuffer {
    private byte[] buffer;
    private int in = 0;
    private int out = 0;

    public CIOByteBuffer(int bfrSize) {
        super(bfrSize);
        this.buffer = new byte[bfrSize + 1];
    }

    @Override
    public int howMany() {
        if (this.in >= this.out) {
            return this.in - this.out;
        }
        return this.in + (this.bfrSize + 1 - this.out);
    }

    @Override
    public synchronized byte read() {
        byte b = this.buffer[this.out];
        this.out = (this.out + 1) % (this.bfrSize + 1);
        return b;
    }

    @Override
    public synchronized void write(byte b) {
        this.buffer[this.in] = b;
        this.in = (this.in + 1) % (this.bfrSize + 1);
    }
}

