/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype;

public class ComparableOrderedPair<F extends Comparable<? super F>, S extends Comparable<? super S>>
implements Comparable<ComparableOrderedPair<F, S>> {
    private final F first;
    private final S second;

    public ComparableOrderedPair(F first, S second) {
        this.first = first;
        this.second = second;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComparableOrderedPair other = (ComparableOrderedPair)obj;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        return !(this.second == null ? other.second != null : !this.second.equals(other.second));
    }

    public F getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    public String toString() {
        return "[" + this.first + ", " + this.second + "]";
    }

    @Override
    public int compareTo(ComparableOrderedPair<F, S> object) {
        if (object == null) {
            throw new NullPointerException("object is null");
        }
        int comp = this.first.compareTo(object.getFirst());
        if (comp != 0) {
            return comp;
        }
        return this.second.compareTo(object.getSecond());
    }
}

