/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype;

import edu.uml.lgdc.datatype.DoubleArray;
import edu.uml.lgdc.math.Search;

public abstract class IncreasingDoubleArray
implements DoubleArray {
    @Override
    public double last() {
        if (this.size() > 0) {
            return this.element(this.size() - 1);
        }
        return Double.NaN;
    }

    @Override
    public double getMinData() {
        return this.element(0);
    }

    @Override
    public double getMaxData() {
        return this.element(this.size() - 1);
    }

    private int leftNearest(double value) {
        return this.leftNearest(value, 0, this.size() - 1);
    }

    private int leftNearest(double value, int first, int last) {
        if (Double.isNaN(value)) {
            return -1;
        }
        return Search.leftNearest(this, value, first, last);
    }

    public int closest(double value) {
        return this.closest(value, 0, this.size() - 1);
    }

    private int closest(double value, int first, int last) {
        if (Double.isNaN(value)) {
            return -1;
        }
        return Search.closest(this, value, first, last);
    }

    public int valueToIndex(double value) {
        int index = this.leftNearest(value);
        if (this.size() > 1 && value > this.element(0) && value < this.element(this.size() - 1) && this.element(index + 1) - value < value - this.element(index)) {
            ++index;
        }
        return index;
    }

    public double indexToValueCenter(int index) {
        double value = Double.MIN_VALUE;
        if (index >= 0 && index < this.size()) {
            value = ((index < this.size() - 1 ? this.element(index + 1) : this.element(index)) + this.element(index)) / 2.0;
        }
        return value;
    }

    public double indexToValueEnd(int index) {
        double value = Double.MIN_VALUE;
        if (index >= 0 && index < this.size()) {
            value = index < this.size() - 1 ? this.element(index + 1) : this.element(index);
        }
        return value;
    }

    public double indexToSegmentWidth(int index) {
        double value = Double.MIN_VALUE;
        if (index >= 0 && index < this.size()) {
            value = this.indexToValueEnd(index) - this.element(index);
        }
        return value;
    }
}

