/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype;

import edu.uml.lgdc.datatype.PoolObjectDesc;
import edu.uml.lgdc.multithread.Semaphore;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public abstract class PoolOfObjects<E> {
    private static final int DEFAULT_SIZE = 10;
    private int size;
    private final List<E> OBJECTS;
    private final List<PoolObjectDesc<E>> OBJECT_DESC;
    private final Stack<Integer> freeObjectIndexes = new Stack();
    private Semaphore semaphore;

    public PoolOfObjects() {
        this(10);
    }

    public PoolOfObjects(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.semaphore = new Semaphore(size);
        this.size = size;
        this.OBJECTS = new ArrayList(size);
        this.OBJECT_DESC = new ArrayList<PoolObjectDesc<E>>(size);
        this.init();
    }

    private void init() {
        int i = 0;
        while (i < this.size) {
            this.OBJECT_DESC.add(null);
            this.OBJECTS.add(null);
            this.freeObjectIndexes.push(this.size - 1 - i);
            ++i;
        }
    }

    protected abstract E createInstanceOfObject();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolObjectDesc<E> get() {
        try {
            this.semaphore.pend();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Stack<Integer> stack = this.freeObjectIndexes;
        synchronized (stack) {
            int index = this.freeObjectIndexes.pop();
            if (this.OBJECTS.get(index) == null) {
                this.OBJECTS.set(index, this.createInstanceOfObject());
            }
            this.initObject(this.OBJECTS.get(index));
            if (this.OBJECT_DESC.get(index) != null) {
                this.OBJECT_DESC.get((int)index).index = index;
                this.OBJECT_DESC.get((int)index).object = this.OBJECTS.get(index);
            } else {
                this.OBJECT_DESC.set(index, new PoolObjectDesc<E>(index, this.OBJECTS.get(index)));
            }
            return new PoolObjectDesc<E>(index, this.OBJECTS.get(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(PoolObjectDesc<E> desc) {
        if (desc.index < 0 || desc.index >= this.size) {
            throw new IllegalArgumentException("illegal desc.index");
        }
        if (desc.object == null) {
            throw new IllegalArgumentException("desc.object is null");
        }
        if (this.OBJECTS.get(desc.index) != desc.object) {
            throw new IllegalArgumentException("illegal descriptor");
        }
        Stack<Integer> stack = this.freeObjectIndexes;
        synchronized (stack) {
            if (this.freeObjectIndexes.indexOf(desc.index) >= 0) {
                throw new RuntimeException("object with index " + desc.index + " allready freed");
            }
            this.finalizeObject(desc.object);
            this.freeObjectIndexes.push(desc.index);
            this.semaphore.post();
        }
    }

    protected void initObject(E object) {
    }

    protected void finalizeObject(E object) {
    }
}

