/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype;

import edu.uml.lgdc.format.StrUtil;
import edu.uml.lgdc.project.Console;
import java.util.ArrayList;
import java.util.List;

public class ResultAndMsg {
    private boolean result;
    private List<String> messages;

    public ResultAndMsg(boolean result) {
        this.result = result;
        this.messages = new ArrayList<String>();
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public boolean getResult() {
        return this.result;
    }

    public void addResult(ResultAndMsg otherResult) {
        this.result = otherResult.getResult();
        this.messages.addAll(otherResult.getMsgAsList());
    }

    public void addMsg(String message) {
        this.messages.add(Console.getMsgAsString(StrUtil.textToLines(message)));
    }

    public void addWarn(String message) {
        this.messages.add(Console.getWarnAsString(StrUtil.textToLines(message)));
    }

    public void addError(String message) {
        this.messages.add(Console.getErrorAsString(StrUtil.textToLines(message)));
    }

    public void addAndShowMsg(String message) {
        this.addMsg(message);
        Console.showMsg(message);
    }

    public void addAndShowWarn(String warning) {
        this.addWarn(warning);
        Console.showWarn(warning);
    }

    public void addAndShowError(String error) {
        this.addError(error);
        Console.showError(error);
    }

    public String getAllMsgAsString() {
        String allMessages = "";
        for (String message : this.messages) {
            allMessages = String.valueOf(allMessages) + message + "\n";
        }
        return allMessages;
    }

    public List<String> getMsgAsList() {
        return this.messages;
    }

    public int getMsgNum() {
        return this.messages.size();
    }
}

