/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype;

import edu.uml.lgdc.time.TimeScale;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class RingBuffer<T extends Map<Object, Object>> {
    public static final int FLAG_UNPROCESSED = 0;
    public static final int FLAG_PROCESSED = 1;
    private final T[] buffer;
    private final int length;
    private final TimeUnit timeUnit;
    private final long bufferDuration_units;
    private final int step_units;
    private final long forecast_units;
    private final int calendarUnitIndex;
    private final int millisecondsPerUnit;
    private int startIndex;
    private TimeScale tov;
    private TimeScale midnightToday = new TimeScale();
    private TimeScale firstTime = new TimeScale();
    private TimeScale lastTime = new TimeScale();
    private TimeScale firstTime_lowerBound = new TimeScale();
    private TimeScale lastTime_upperBound = new TimeScale();
    private int processingFlag;

    public RingBuffer(Class<T> clazz, TimeUnit timeUnit, long bufferDuration_units, int step_units, long forecast_units) {
        Objects.requireNonNull(clazz);
        this.timeUnit = Objects.requireNonNull(timeUnit);
        assert (timeUnit.ordinal() >= TimeUnit.SECONDS.ordinal());
        this.bufferDuration_units = (long)step_units * (bufferDuration_units / (long)step_units);
        this.step_units = step_units;
        this.forecast_units = forecast_units;
        this.calendarUnitIndex = RingBuffer.getCalendarUnitIndex(timeUnit);
        this.millisecondsPerUnit = RingBuffer.getMillisecondsPerUnit(timeUnit);
        this.length = (int)((bufferDuration_units + this.forecast_units) / (long)this.step_units);
        this.buffer = (Map[])Array.newInstance(clazz, this.length);
        try {
            int i = 0;
            while (i < this.length) {
                this.buffer[i] = (Map)clazz.newInstance();
                ++i;
            }
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException("design error");
        }
    }

    public T getCell(TimeScale time) {
        int i = this.timeToInternalIndex(time);
        this.checkIndex(i);
        return this.buffer[i];
    }

    public T getCell(int iRelative) {
        int i = this.userIndextoInternalIndex(iRelative);
        this.checkIndex(i);
        return this.buffer[i];
    }

    public Object get(int userIndex, Object type) {
        this.checkIndex(userIndex);
        return this.buffer[this.userIndextoInternalIndex(userIndex)].get(type);
    }

    public Object get(TimeScale time, Object type) {
        int i = this.timeToInternalIndex(time);
        return i != -1 ? this.buffer[i].get(type) : null;
    }

    public Object[] get(Object type) {
        return this.get(this.startIndex, this.startIndex + this.length - 1, type);
    }

    public Object[] getTodayValues(Object type) {
        int iStart = this.timeToInternalIndex(this.midnightToday);
        int iStop = this.timeToInternalIndex(this.tov);
        if (iStart == -1 || iStop == -1) {
            return null;
        }
        return this.get(iStart, iStop, type);
    }

    public Object[] getPastValues(Object type) {
        int iStart = this.timeToInternalIndex(this.firstTime);
        int iStop = this.timeToInternalIndex(this.tov);
        if (iStart == -1 || iStop == -1) {
            return null;
        }
        return this.get(iStart, iStop, type);
    }

    private Object[] get(int internalIndex1, int internalIndex2, Object type) {
        if (internalIndex2 < internalIndex1) {
            internalIndex2 += this.length;
        }
        Object[] output = new Object[internalIndex2 - internalIndex1 + 1];
        int i = internalIndex1;
        int k = 0;
        while (i <= internalIndex2) {
            output[k] = this.buffer[i % this.length].get(type);
            ++i;
            ++k;
        }
        return output;
    }

    public TimeScale getMidnightToday() {
        return this.midnightToday;
    }

    public TimeScale getTov() {
        return this.tov;
    }

    public TimeScale getFirstTime() {
        return this.firstTime;
    }

    public TimeScale getLastTime() {
        return this.lastTime;
    }

    public int getLength() {
        return this.length;
    }

    public TimeScale getOldestObjectTime() {
        int iStart = this.timeToInternalIndex(this.firstTime);
        int iStop = this.timeToInternalIndex(this.tov);
        if (iStart == -1 || iStop == -1) {
            throw new RuntimeException("iStart and iStop has to be >= 0, but iStart is " + iStart + ", iStop is " + iStop);
        }
        if (iStop < iStart) {
            iStop += this.length;
        }
        int i = iStart;
        while (i <= iStop) {
            int k = i % this.length;
            if (!this.buffer[k].isEmpty()) {
                return this.relativeIndexToTime(this.internalndexToUserIndex(k));
            }
            ++i;
        }
        return null;
    }

    public TimeScale getRecentObjectTime() {
        int iStart = this.timeToInternalIndex(this.firstTime);
        int iStop = this.timeToInternalIndex(this.tov);
        if (iStart == -1 || iStop == -1) {
            throw new RuntimeException("iStart and iStop has to be >= 0, but iStart is " + iStart + ", iStop is " + iStop);
        }
        if (iStop < iStart) {
            iStop += this.length;
        }
        int i = iStop;
        while (i >= iStart) {
            int k = i % this.length;
            if (!this.buffer[k].isEmpty()) {
                return this.relativeIndexToTime(this.internalndexToUserIndex(k));
            }
            --i;
        }
        return null;
    }

    public boolean isEmpty() {
        T[] TArray = this.buffer;
        int n = this.buffer.length;
        int n2 = 0;
        while (n2 < n) {
            T map = TArray[n2];
            if (!map.isEmpty()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int filledCellCount() {
        int count = 0;
        int i = 0;
        while (i < this.length) {
            if (!this.buffer[i].isEmpty()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public boolean put(TimeScale time, Object type, Object object) {
        int i = this.timeToInternalIndex(time);
        if (i == -1) {
            return false;
        }
        this.buffer[i].put((Object)type, (Object)object);
        return true;
    }

    public boolean put(int userIndex, Object type, Object object) {
        this.buffer[this.userIndextoInternalIndex(userIndex)].put((Object)type, (Object)object);
        return true;
    }

    public int timeToUserIndex(TimeScale time) {
        if (!this.isValidTime(time)) {
            return -1;
        }
        int index = (int)Math.round(time.diffIn(this.calendarUnitIndex, this.firstTime) / (double)this.step_units);
        if (index == -1) {
            index = 0;
        } else if (index == this.length) {
            index = this.length - 1;
        }
        return index;
    }

    public int timeToInternalIndex(TimeScale time) {
        int index = this.timeToUserIndex(time);
        if (index != -1) {
            index = (this.startIndex + index) % this.length;
        }
        return index;
    }

    public boolean isValidTime(TimeScale time) {
        return !time.after(this.lastTime_upperBound) && !time.before(this.firstTime_lowerBound);
    }

    public TimeScale relativeIndexToTime(int i) {
        this.checkIndex(i);
        TimeScale time = new TimeScale(this.firstTime.getTimeInMillis());
        time.add(this.calendarUnitIndex, i * this.step_units);
        return time;
    }

    private int userIndextoInternalIndex(int index) {
        this.checkIndex(index);
        return (this.startIndex + index) % this.length;
    }

    private int internalndexToUserIndex(int index) {
        this.checkIndex(index);
        return index - this.startIndex + (this.startIndex > index ? this.length : 0);
    }

    private void checkIndex(int i) {
        if (i < 0 || i >= this.length) {
            throw new IllegalArgumentException("i < 0 || i >= length, i=" + i + ", length=" + this.length);
        }
    }

    public double timeGridMismatch_min(TimeScale time) {
        return this.convertTo(this.timeGridMismatch_units(time), TimeUnit.MINUTES);
    }

    public double timeGridMismatch_sec(TimeScale time) {
        return this.convertTo(this.timeGridMismatch_units(time), TimeUnit.SECONDS);
    }

    public double timeGridMismatch_units(TimeScale time) {
        double diffInUnits = time.diffIn(this.calendarUnitIndex, this.firstTime);
        return Math.abs(diffInUnits - (double)((int)(diffInUnits / (double)this.step_units) * this.step_units));
    }

    public void setTov(TimeScale newTov) {
        TimeScale newFirstTime = new TimeScale(newTov.getTimeInMillis() + (long)this.millisecondsPerUnit * ((long)this.step_units - this.bufferDuration_units));
        TimeScale newLastTime = new TimeScale(newTov.getTimeInMillis() + (long)this.millisecondsPerUnit * this.forecast_units);
        if (this.tov != null) {
            this.clearExpired(this.firstTime, newFirstTime, newLastTime);
            this.startIndex += (int)(newFirstTime.diffIn(this.calendarUnitIndex, this.firstTime) / (double)this.step_units);
            this.startIndex %= this.length;
            if (this.startIndex < 0) {
                this.startIndex += this.length;
            }
        } else {
            this.startIndex = 0;
            this.tov = new TimeScale();
        }
        this.firstTime.setTimeInMillis(newFirstTime.getTimeInMillis());
        this.firstTime_lowerBound.setTimeInMillis(this.firstTime.getTimeInMillis() - (long)(this.step_units * this.millisecondsPerUnit / 2));
        this.tov.setTimeInMillis(newTov.getTimeInMillis());
        this.lastTime.setTimeInMillis(newLastTime.getTimeInMillis());
        this.lastTime_upperBound.setTimeInMillis(this.lastTime.getTimeInMillis() + (long)(this.step_units * this.millisecondsPerUnit / 2));
        this.midnightToday.setTimeInMillis(this.tov.getTimeInMillis());
        this.midnightToday.add(13, -((int)this.tov.getTimeSinceMidnightIn(13)));
    }

    private void clearExpired(TimeScale firstTime, TimeScale newFirstTime, TimeScale newLastTime) {
        int iFirst = this.timeToInternalIndex(firstTime);
        if (newFirstTime.after(firstTime)) {
            int iNewFirst = this.timeToInternalIndex(newFirstTime);
            if (iNewFirst != -1) {
                if (iFirst != iNewFirst) {
                    if (iNewFirst < iFirst) {
                        iNewFirst += this.length;
                    }
                    int i = iFirst;
                    while (i < iNewFirst) {
                        this.buffer[i % this.length].clear();
                        ++i;
                    }
                }
            } else {
                this.clearBuffer();
            }
        } else {
            int iNewLast = this.timeToInternalIndex(newLastTime);
            if (iNewLast != -1) {
                if (iFirst <= iNewLast) {
                    iFirst += this.length;
                }
                int i = iNewLast + 1;
                while (i < iFirst) {
                    this.buffer[i % this.length].clear();
                    ++i;
                }
            } else {
                this.clearBuffer();
            }
        }
    }

    private void clearBuffer() {
        int i = 0;
        while (i < this.length) {
            this.buffer[i].clear();
            ++i;
        }
    }

    public void clear() {
        this.clearBuffer();
        this.tov = null;
    }

    public int getProcessingFlag() {
        return this.processingFlag;
    }

    public void setProcessingFlag(int processingFlag) {
        this.processingFlag = processingFlag;
    }

    public double getStep_min() {
        return this.convertTo(this.step_units, TimeUnit.MINUTES);
    }

    public int getStep_sec() {
        return (int)this.convertTo(this.step_units, TimeUnit.SECONDS);
    }

    public long getStep_ms() {
        return 1000 * this.getStep_sec();
    }

    public int getStep_units() {
        return this.step_units;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public int getCalendarUnitIndex() {
        return this.calendarUnitIndex;
    }

    private static int getCalendarUnitIndex(TimeUnit timeUnit) {
        switch (timeUnit) {
            case SECONDS: {
                return 13;
            }
            case MINUTES: {
                return 12;
            }
            case HOURS: {
                return 11;
            }
            case DAYS: {
                return 5;
            }
        }
        throw new RuntimeException("illegal TimeUnit, " + (Object)((Object)timeUnit));
    }

    private static int getMillisecondsPerUnit(TimeUnit timeUnit) {
        switch (timeUnit) {
            case SECONDS: {
                return 1000;
            }
            case MINUTES: {
                return 60000;
            }
            case HOURS: {
                return 3600000;
            }
            case DAYS: {
                return 86400000;
            }
        }
        throw new RuntimeException("illegal TimeUnit, " + (Object)((Object)timeUnit));
    }

    private static double convertToSeconds(double value_units, TimeUnit timeUnit) {
        switch (timeUnit) {
            case SECONDS: {
                return value_units;
            }
            case MINUTES: {
                return 60.0 * value_units;
            }
            case HOURS: {
                return 3600.0 * value_units;
            }
            case DAYS: {
                return 86400.0 * value_units;
            }
        }
        throw new RuntimeException("illegal TimeUnit, " + (Object)((Object)timeUnit));
    }

    private double convertTo(double value_units, TimeUnit otherTimeUnit) {
        if (this.timeUnit != otherTimeUnit) {
            switch (otherTimeUnit) {
                case SECONDS: {
                    return RingBuffer.convertToSeconds(value_units, this.timeUnit);
                }
                case MINUTES: {
                    return RingBuffer.convertToSeconds(value_units, this.timeUnit) / 60.0;
                }
                case HOURS: {
                    return RingBuffer.convertToSeconds(value_units, this.timeUnit) / 3600.0;
                }
                case DAYS: {
                    return RingBuffer.convertToSeconds(value_units, this.timeUnit) / 86400.0;
                }
            }
            throw new RuntimeException("illegal TimeUnit for ring buffer duration, " + (Object)((Object)otherTimeUnit));
        }
        return value_units;
    }
}

