/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype;

import edu.uml.lgdc.datatype.DoubleArray;

public class WrapToDoubleArray
implements DoubleArray {
    private double[] data;
    private int minIndex = 0;
    private int maxIndex = 0;
    private double minData;
    private double maxData;
    private boolean newArray;

    public WrapToDoubleArray(double[] data) {
        this(data, 0);
    }

    public WrapToDoubleArray(double[] data, int minIndex) {
        this(data, minIndex, data.length - 1);
    }

    public WrapToDoubleArray(double[] data, int minIndex, int maxIndex) {
        this.setArray(data, minIndex, maxIndex);
    }

    @Override
    public int size() {
        return this.maxIndex - this.minIndex + 1;
    }

    @Override
    public double last() {
        if (this.size() > 0) {
            return this.element(this.size() - 1);
        }
        return Double.NaN;
    }

    @Override
    public double element(int index) {
        if (index >= 0 && index <= this.maxIndex - this.minIndex) {
            return this.data[this.minIndex + index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    @Override
    public double getMinData() {
        if (this.newArray) {
            this.calcMinMax();
        }
        return this.minData;
    }

    @Override
    public double getMaxData() {
        if (this.newArray) {
            this.calcMinMax();
        }
        return this.maxData;
    }

    private void setArray(double[] data, int minIndex, int maxIndex) {
        if (minIndex < 0 || maxIndex >= data.length || minIndex > maxIndex) {
            throw new IllegalArgumentException("Illegal bounds: " + minIndex + " or " + maxIndex);
        }
        this.data = data;
        this.minIndex = minIndex;
        this.maxIndex = maxIndex;
        this.newArray = true;
    }

    protected void calcMinMax() {
        this.newArray = false;
        if (this.data.length == 0) {
            this.minData = Double.NaN;
            this.maxData = Double.NaN;
        } else {
            this.minData = Double.MAX_VALUE;
            this.maxData = Double.MIN_VALUE;
            int i = this.minIndex;
            while (i <= this.maxIndex) {
                if (this.data[i] < this.minData) {
                    this.minData = this.data[i];
                }
                if (this.data[i] > this.maxData) {
                    this.maxData = this.data[i];
                }
                ++i;
            }
        }
    }
}

