/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype;

import edu.uml.lgdc.datatype.IncreasingDoubleArray;

public class WrapToIncreasingDoubleArray
extends IncreasingDoubleArray {
    private double[] data;
    private int minIndex = 0;
    private int maxIndex = 0;

    public WrapToIncreasingDoubleArray(double[] data) {
        this(data, 0);
    }

    public WrapToIncreasingDoubleArray(double[] data, int minIndex) {
        this(data, minIndex, data.length - 1);
    }

    public WrapToIncreasingDoubleArray(double[] data, int minIndex, int maxIndex) {
        this.setArray(data, minIndex, maxIndex);
    }

    @Override
    public int size() {
        return this.maxIndex - this.minIndex + 1;
    }

    @Override
    public double element(int index) {
        if (index >= 0 && index <= this.maxIndex - this.minIndex) {
            return this.data[this.minIndex + index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    private void setArray(double[] data, int minIndex, int maxIndex) {
        if (minIndex < 0 || maxIndex >= data.length || minIndex > maxIndex) {
            throw new IllegalArgumentException("Illegal bounds: " + minIndex + " or " + maxIndex);
        }
        this.data = data;
        this.minIndex = minIndex;
        this.maxIndex = maxIndex;
    }
}

