/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype;

import edu.uml.lgdc.datatype.IncreasingFloatArray;

public class WrapToIncreasingFloatArray
extends IncreasingFloatArray {
    private float[] data;
    private int minIndex = 0;
    private int maxIndex = 0;

    public WrapToIncreasingFloatArray(float[] data) {
        this(data, 0);
    }

    public WrapToIncreasingFloatArray(float[] data, int minIndex) {
        this(data, minIndex, data.length - 1);
    }

    public WrapToIncreasingFloatArray(float[] data, int minIndex, int maxIndex) {
        this.setArray(data, minIndex, maxIndex);
    }

    @Override
    public int size() {
        return this.maxIndex - this.minIndex + 1;
    }

    @Override
    public float element(int index) {
        if (index >= 0 && index <= this.maxIndex - this.minIndex) {
            return this.data[this.minIndex + index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    private void setArray(float[] data, int minIndex, int maxIndex) {
        if (minIndex < 0 || maxIndex >= data.length || minIndex > maxIndex) {
            throw new IllegalArgumentException("Illegal bounds: " + minIndex + " or " + maxIndex);
        }
        this.data = data;
        this.minIndex = minIndex;
        this.maxIndex = maxIndex;
    }
}

