/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.field;

import edu.uml.lgdc.datatype.field.ArrayOfProFields;
import edu.uml.lgdc.datatype.field.F_ByteField;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.format.StrDecoder;
import edu.uml.lgdc.format.StrUtil;
import edu.uml.lgdc.project.IllegalDataFieldException;

public abstract class ArrayOfBytes
extends ArrayOfProFields<F_ByteField> {
    protected ArrayOfBytes(String mnemonic, String name, int length) {
        super(mnemonic, name, new F_ByteField(), length);
    }

    public byte[] byteValues() {
        int size = this.getSize();
        byte[] values = new byte[size];
        int i = 0;
        while (i < size) {
            values[i] = ((Integer)((F_ByteField)this.getProField(i)).get()).byteValue();
            ++i;
        }
        return values;
    }

    public String strValue() {
        return StrUtil.trimRight(StrDecoder.runISO_8859_1(this.byteValues()));
    }

    public void put(byte[] values) {
        if (values == null) {
            if (this.getSize() > 0) {
                throw new IllegalArgumentException("values is null but Array size > 0");
            }
            this.setValueSet();
            return;
        }
        if (values.length != this.getSize()) {
            throw new IllegalArgumentException("size of values is different from Array size");
        }
        int i = 0;
        while (i < values.length) {
            ((F_ByteField)this.getProField(i)).put(values[i]);
            ++i;
        }
        this.setValueSet();
    }

    public void put(String strValue) {
        if (strValue == null) {
            this.put((byte[])null);
        } else {
            if (strValue.length() > this.getSize()) {
                strValue = StrUtil.trimRight(strValue);
            }
            if (strValue.length() < this.getSize()) {
                strValue = FC.padRight(strValue, this.getSize());
            } else if (strValue.length() > this.getSize()) {
                throw new IllegalArgumentException("strValue  is longer than Array size");
            }
            this.put(strValue.getBytes());
        }
    }

    @Override
    public String extract(byte[] data, int byteOffset, int bitOffset) throws IllegalDataFieldException {
        String errMsg = super.extract(data, byteOffset, bitOffset);
        if (errMsg == null) {
            errMsg = this.check();
        }
        return errMsg;
    }
}

