/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.field;

import edu.uml.lgdc.datatype.field.DoubleField;
import edu.uml.lgdc.datatype.field.IntegerField;
import edu.uml.lgdc.datatype.field.LongField;
import edu.uml.lgdc.datatype.field.NumericField;
import edu.uml.lgdc.datatype.field.ProField;
import edu.uml.lgdc.datatype.field.ProFieldCollection;
import edu.uml.lgdc.project.IllegalDataFieldException;
import java.util.Arrays;
import java.util.Vector;

public class ArrayOfProFields<E extends ProField>
extends ProFieldCollection {
    private static final String MSG_WRONG_COMP_TYPE = "Component type is not an instance of class NumericField";
    private Vector<E> proFields = null;
    private boolean[] arrayValuesSet = null;
    private int countSet = 0;
    private int size = 0;
    private boolean arrayPacked = false;
    private boolean aligned = true;
    private int lengthInBits = 0;
    private boolean lengthCalculated = false;
    private E component;

    public ArrayOfProFields(String mnemonic, String name, E component) {
        this(mnemonic, name, component, 0);
    }

    public ArrayOfProFields(String mnemonic, String name, E component, int size) {
        this(mnemonic, name, component, size, false);
    }

    public ArrayOfProFields(String mnemonic, String name, E component, int size, boolean packed) {
        this.mnemonic = mnemonic;
        this.name = name;
        this.component = component;
        this.arrayPacked = packed || !((ProField)component).getAligned();
        this.setArraySize(size);
    }

    public int hashCode() {
        int code = this.mnemonic.hashCode();
        int maxToHash = 3;
        if (this.size > 0) {
            code += ((ProField)this.proFields.get(0)).hashCode();
            if (this.size > 1) {
                int step = (this.size - 1) / 3;
                if (step == 0) {
                    step = 1;
                }
                int i = step;
                while (i < this.size) {
                    code += ((ProField)this.proFields.get(i)).hashCode();
                    i += step;
                }
            }
        }
        return code;
    }

    public void setAligned(boolean aligned) {
        this.aligned = aligned;
    }

    @Override
    public ArrayOfProFields<E> clone() {
        ArrayOfProFields obj = null;
        obj = (ArrayOfProFields)super.clone();
        if (this.proFields != null) {
            obj.proFields = new Vector();
            int i = 0;
            while (i < this.proFields.size()) {
                obj.proFields.add(((ProField)this.proFields.get(i)).clone());
                ++i;
            }
        }
        return obj;
    }

    public boolean equals(Object obj) {
        boolean equaled = false;
        if (obj != null && this.getClass().isInstance(obj)) {
            ArrayOfProFields fa = (ArrayOfProFields)obj;
            if (this.proFields.size() == fa.proFields.size()) {
                equaled = true;
                int i = 0;
                while (i < this.proFields.size()) {
                    if (!((ProField)fa.proFields.elementAt(i)).equals(this.proFields.elementAt(i))) {
                        equaled = false;
                        break;
                    }
                    ++i;
                }
            }
        }
        return equaled;
    }

    @Override
    public boolean isFiller() {
        return ((ProField)this.component).isFiller();
    }

    @Override
    public boolean getAligned() {
        return this.aligned;
    }

    @Override
    public void setValueSet() {
        this.valueSet = true;
    }

    @Override
    public boolean isValueSet() {
        return this.valueSet;
    }

    @Override
    public void clearValue() {
        this.valueSet = false;
        this.arrayValuesSet = null;
        this.lengthCalculated = false;
    }

    @Override
    public Object get() {
        this.checkValueSet();
        Object[] objValues = new Object[this.size];
        int i = 0;
        while (i < this.size) {
            objValues[i] = ((ProField)this.proFields.elementAt(i)).get();
            ++i;
        }
        return objValues;
    }

    @Override
    public void put(Object object) {
        if (object == null) {
            this.setArraySize(0);
            this.size = 0;
            this.initProFields();
            this.valueSet = true;
            return;
        }
        if (ArrayOfProFields.class.isInstance(object)) {
            object = ((ProField)object).get();
        }
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("Value is not array");
        }
        if (!object.getClass().getComponentType().isPrimitive()) {
            Object[] array = (Object[])object;
            this.setArraySize(array.length);
            int i = 0;
            while (i < this.size) {
                ((ProField)this.proFields.elementAt(i)).put(array[i]);
                ++i;
            }
        } else {
            int i;
            String name = object.getClass().getComponentType().getName();
            double[] doubleArray = null;
            int[] intArray = null;
            long[] longArray = null;
            float[] floatArray = null;
            short[] shortArray = null;
            byte[] byteArray = null;
            int len = -1;
            if (name.equals("int")) {
                intArray = (int[])object;
                len = intArray.length;
            } else if (name.equals("double")) {
                doubleArray = (double[])object;
                len = doubleArray.length;
            } else if (name.equals("long")) {
                longArray = (long[])object;
                len = longArray.length;
            } else if (name.equals("short")) {
                shortArray = (short[])object;
                len = shortArray.length;
                if (len == this.size) {
                    intArray = new int[this.size];
                    i = 0;
                    while (i < this.size) {
                        intArray[i] = shortArray[i];
                        ++i;
                    }
                    name = "int";
                }
            } else if (name.equals("byte")) {
                byteArray = (byte[])object;
                len = byteArray.length;
                if (len == this.size) {
                    intArray = new int[this.size];
                    i = 0;
                    while (i < this.size) {
                        intArray[i] = byteArray[i];
                        ++i;
                    }
                    name = "int";
                }
            } else if (name.equals("float")) {
                floatArray = (float[])object;
                len = floatArray.length;
                if (len == this.size) {
                    doubleArray = new double[this.size];
                    i = 0;
                    while (i < this.size) {
                        doubleArray[i] = floatArray[i];
                        ++i;
                    }
                    name = "double";
                }
            } else {
                throw new RuntimeException("Illegal component type: " + name);
            }
            this.setArraySize(len);
            if (name.equals("int")) {
                i = 0;
                while (i < this.size) {
                    ((ProField)this.proFields.elementAt(i)).put(new Integer(intArray[i]));
                    ++i;
                }
            } else if (name.equals("double")) {
                i = 0;
                while (i < this.size) {
                    ((ProField)this.proFields.elementAt(i)).put(new Double(doubleArray[i]));
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.size) {
                    ((ProField)this.proFields.elementAt(i)).put(new Long(longArray[i]));
                    ++i;
                }
            }
        }
        this.valueSet = true;
    }

    protected void add(E field) {
        this.add(field, this.size - 1);
    }

    public void add(E field, int index) {
        if (this.proFields == null) {
            this.proFields = new Vector();
        }
        if (index < -1 || index >= this.proFields.size()) {
            throw new IllegalArgumentException("index is illegal, " + index);
        }
        if (index + 1 == this.proFields.size()) {
            this.proFields.add(field);
        } else {
            this.proFields.insertElementAt(field, index + 1);
        }
        if (this.proFields.size() == 1) {
            this.setValueSet();
        }
        ++this.size;
        this.lengthCalculated = false;
    }

    public void delete(int index) {
        if (this.proFields == null) {
            this.proFields = new Vector();
        }
        if (index < 0 || index >= this.proFields.size()) {
            throw new IllegalArgumentException("index is illegal, " + index);
        }
        this.proFields.removeElementAt(index);
        --this.size;
        this.lengthCalculated = false;
    }

    @Override
    public String check() {
        String errMsg = null;
        int index = -1;
        int i = 0;
        while (i < this.size) {
            errMsg = ((ProField)this.proFields.elementAt(i)).check();
            if (errMsg != null) {
                index = i;
                break;
            }
            ++i;
        }
        if (errMsg != null) {
            errMsg = String.valueOf(errMsg) + "\n" + this.getName() + "[" + index + "]";
        }
        return errMsg;
    }

    @Override
    public String textExport(int level, String indention) {
        String out = super.textExport(level, indention);
        int i = 0;
        while (i < this.size) {
            out = level == 2 || level == 3 ? String.valueOf(out) + ((ProField)this.proFields.elementAt(i)).textExport(level, indention) + "[" + i + "]" : String.valueOf(out) + "\n" + indention + " Element[" + i + "]: " + ((ProField)this.proFields.elementAt(i)).textExport(level, indention);
            ++i;
        }
        return out;
    }

    @Override
    public String check(Object objValue) {
        if (objValue == null) {
            return null;
        }
        if (!objValue.getClass().isArray()) {
            throw new IllegalArgumentException("Value is not array");
        }
        Object[] array = (Object[])objValue;
        String errMsg = null;
        int i = 0;
        while (i < array.length) {
            errMsg = ((ProField)this.component).check(array[i]);
            if (errMsg != null) {
                errMsg = String.valueOf(errMsg) + "\n" + this.getName() + "[" + i + "]";
                break;
            }
            ++i;
        }
        return errMsg;
    }

    @Override
    public String extract(byte[] data, int byteOffset, int bitOffset) throws IllegalDataFieldException {
        String errMsg = null;
        this.lengthCalculated = false;
        int i = 0;
        while (i < this.size) {
            errMsg = ((ProField)this.proFields.elementAt(i)).extract(data, byteOffset, bitOffset);
            if (errMsg != null) {
                errMsg = String.valueOf(errMsg) + "\n" + this.getName() + "[" + i + "]";
                break;
            }
            int len = ((ProField)this.proFields.elementAt(i)).getLengthInBits();
            bitOffset = !this.arrayPacked ? 8 * ((bitOffset + len + 8 - 1) / 8) : (bitOffset += len);
            byteOffset += bitOffset / 8;
            bitOffset -= 8 * (bitOffset / 8);
            ++i;
        }
        if (errMsg == null) {
            this.valueSet = true;
            this.arrayValuesSet = null;
            this.calculateLength();
        }
        return errMsg;
    }

    @Override
    public void pack(byte[] data, int byteOffset, int bitOffset) throws IllegalDataFieldException {
        this.checkValueSet();
        this.lengthCalculated = false;
        int i = 0;
        while (i < this.size) {
            ((ProField)this.proFields.elementAt(i)).pack(data, byteOffset, bitOffset);
            int len = ((ProField)this.proFields.elementAt(i)).getLengthInBits();
            bitOffset = !this.arrayPacked ? 8 * ((bitOffset + len + 8 - 1) / 8) : (bitOffset += len);
            byteOffset += bitOffset / 8;
            bitOffset -= 8 * (bitOffset / 8);
            ++i;
        }
        this.calculateLength();
    }

    @Override
    public int getLengthInBits() {
        this.checkValueSet();
        if (!this.lengthCalculated) {
            this.calculateLength();
        }
        return this.lengthInBits;
    }

    @Override
    public int getMinLengthInBits() {
        return this.getMinLengthInBits(this.size);
    }

    public int getMinLengthInBits(int size) {
        return this.getLengthInBits(size, ((ProField)this.component).getMinLengthInBits());
    }

    @Override
    public int getMaxLengthInBits() {
        return this.getMaxLengthInBits(this.size);
    }

    public int getMaxLengthInBits(int size) {
        return this.getLengthInBits(size, ((ProField)this.component).getMaxLengthInBits());
    }

    @Override
    public void calcOffset(int byteOffset, int bitOffset) {
        if (this.proFields == null) {
            return;
        }
        int i = 0;
        while (i < this.size) {
            ProField proField = (ProField)this.proFields.elementAt(i);
            if (proField != null) {
                proField.calcOffset(byteOffset, bitOffset);
            }
            ++i;
        }
    }

    @Override
    public String getMnemonicOfUnset(String mnemSoFar) {
        if (this.isValueSet()) {
            return null;
        }
        int k = -1;
        int i = 0;
        while (i < this.size) {
            if (!((ProField)this.proFields.elementAt(i)).isValueSet()) {
                k = i;
                break;
            }
            ++i;
        }
        if (!mnemSoFar.equals("")) {
            mnemSoFar = String.valueOf(mnemSoFar) + ".";
        }
        if (k >= 0) {
            mnemSoFar = String.valueOf(mnemSoFar) + this.getMnemonic() + "[" + k + "]";
            return ((ProField)this.proFields.elementAt(k)).getMnemonicOfUnset(mnemSoFar);
        }
        return String.valueOf(mnemSoFar) + this.getMnemonic();
    }

    public E getComponent() {
        return this.component;
    }

    public void setArray(int size, boolean packed) {
        this.arrayPacked = packed || !((ProField)this.component).getAligned();
        this.setArraySize(size);
    }

    public void setArraySize(int size) {
        this.size = size;
        this.initProFields();
        this.valueSet = size <= 0;
        this.arrayValuesSet = null;
        this.lengthCalculated = false;
    }

    public void changeArraySize(int size) {
        if (size == 0 || this.size == 0) {
            this.setArraySize(size);
        } else if (size < this.size) {
            this.proFields.setSize(size);
            if (this.arrayValuesSet != null) {
                boolean[] newArrayValuesSet = Arrays.copyOf(this.arrayValuesSet, size);
                this.countSet = 0;
                int i = 0;
                while (i < size) {
                    if (newArrayValuesSet[i]) {
                        ++this.countSet;
                    }
                    ++i;
                }
                if (this.countSet < size) {
                    this.valueSet = false;
                    this.arrayValuesSet = newArrayValuesSet;
                } else {
                    this.arrayValuesSet = null;
                    this.countSet = 0;
                    this.valueSet = true;
                }
            }
            this.size = size;
        } else if (size > this.size) {
            int i = this.size;
            while (i < size) {
                this.proFields.addElement(((ProField)this.component).clone());
                ((ProField)this.proFields.elementAt(i)).clearValue();
                ++i;
            }
            this.arrayValuesSet = this.arrayValuesSet != null ? Arrays.copyOf(this.arrayValuesSet, size) : new boolean[size];
            this.valueSet = false;
            this.size = size;
        }
    }

    public Vector<E> getProFields() {
        return this.proFields;
    }

    public void setProFields(Vector<E> proFields) {
        this.proFields = proFields;
    }

    public E getProField(int index) {
        if (index < 0 || index >= this.proFields.size()) {
            throw new IllegalArgumentException("illegal index, " + index);
        }
        return (E)((ProField)this.proFields.elementAt(index));
    }

    public int getSize() {
        if (this.proFields != null) {
            return this.proFields.size();
        }
        return 0;
    }

    public double[] doubleValues() {
        this.checkValueSet();
        this.checkComponentType();
        double[] values = new double[this.size];
        if (DoubleField.class.isInstance(this.component)) {
            int i = 0;
            while (i < this.size) {
                values[i] = (Double)((ProField)this.proFields.elementAt(i)).get();
                ++i;
            }
        } else if (LongField.class.isInstance(this.component)) {
            int i = 0;
            while (i < this.size) {
                values[i] = ((Long)((ProField)this.proFields.elementAt(i)).get()).longValue();
                ++i;
            }
        } else if (IntegerField.class.isInstance(this.component)) {
            int i = 0;
            while (i < this.size) {
                values[i] = ((Integer)((ProField)this.proFields.elementAt(i)).get()).intValue();
                ++i;
            }
        } else {
            throw new RuntimeException("Unknown NumericField type: " + this.component.getClass().getName());
        }
        return values;
    }

    public long[] longValues() {
        this.checkValueSet();
        this.checkComponentType();
        long[] values = new long[this.size];
        if (DoubleField.class.isInstance(this.component)) {
            int i = 0;
            while (i < this.size) {
                values[i] = (long)((Double)((ProField)this.proFields.elementAt(i)).get()).doubleValue();
                ++i;
            }
        } else if (LongField.class.isInstance(this.component)) {
            int i = 0;
            while (i < this.size) {
                values[i] = (Long)((ProField)this.proFields.elementAt(i)).get();
                ++i;
            }
        } else if (IntegerField.class.isInstance(this.component)) {
            int i = 0;
            while (i < this.size) {
                values[i] = ((Integer)((ProField)this.proFields.elementAt(i)).get()).intValue();
                ++i;
            }
        } else {
            throw new RuntimeException("Unknown NumericField type: " + this.component.getClass().getName());
        }
        return values;
    }

    public int[] intValues() {
        this.checkValueSet();
        this.checkComponentType();
        int[] values = new int[this.size];
        if (DoubleField.class.isInstance(this.component)) {
            int i = 0;
            while (i < this.size) {
                values[i] = (int)((Double)((ProField)this.proFields.elementAt(i)).get()).doubleValue();
                ++i;
            }
        } else if (LongField.class.isInstance(this.component)) {
            int i = 0;
            while (i < this.size) {
                values[i] = (int)((Long)((ProField)this.proFields.elementAt(i)).get()).longValue();
                ++i;
            }
        } else if (IntegerField.class.isInstance(this.component)) {
            int i = 0;
            while (i < this.size) {
                values[i] = (Integer)((ProField)this.proFields.elementAt(i)).get();
                ++i;
            }
        } else {
            throw new RuntimeException("Unknown NumericField type: " + this.component.getClass().getName());
        }
        return values;
    }

    public void put(int index, Object value) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.lengthCalculated = false;
        ((ProField)this.proFields.elementAt(index)).put(value);
        if (!this.valueSet) {
            if (this.arrayValuesSet == null) {
                this.arrayValuesSet = new boolean[this.size];
                this.countSet = 0;
            }
            if (!this.arrayValuesSet[index]) {
                this.arrayValuesSet[index] = true;
                ++this.countSet;
                if (this.countSet == this.size) {
                    this.valueSet = true;
                    this.arrayValuesSet = null;
                }
            }
        }
    }

    public void put(int index, int value) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.checkComponentType();
        this.lengthCalculated = false;
        ((NumericField)this.proFields.elementAt(index)).put(value);
        if (!this.valueSet) {
            if (this.arrayValuesSet == null) {
                this.arrayValuesSet = new boolean[this.size];
                this.countSet = 0;
            }
            if (this.arrayValuesSet[index]) {
                this.arrayValuesSet[index] = true;
                ++this.countSet;
                if (this.countSet == this.size) {
                    this.valueSet = true;
                    this.arrayValuesSet = null;
                }
            }
        }
    }

    public void put(double[] values) {
        this.checkComponentType();
        if (this.size != (values != null ? values.length : 0)) {
            throw new IllegalArgumentException("Different lengths of arrays");
        }
        int i = 0;
        while (i < this.size) {
            ((NumericField)this.proFields.elementAt(i)).put(values[i]);
            ++i;
        }
        this.valueSet = true;
        this.arrayValuesSet = null;
    }

    public void put(long[] values) {
        this.checkComponentType();
        if (this.size != (values != null ? values.length : 0)) {
            throw new IllegalArgumentException("Different lengths of arrays");
        }
        int i = 0;
        while (i < this.size) {
            ((NumericField)this.proFields.elementAt(i)).put(values[i]);
            ++i;
        }
        this.valueSet = true;
        this.arrayValuesSet = null;
    }

    public void put(int[] values) {
        this.checkComponentType();
        if (this.size != (values != null ? values.length : 0)) {
            throw new IllegalArgumentException("Different lengths of arrays");
        }
        int i = 0;
        while (i < this.size) {
            ((NumericField)this.proFields.elementAt(i)).put(values[i]);
            ++i;
        }
        this.valueSet = true;
        this.arrayValuesSet = null;
    }

    public long longValue(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.checkComponentType();
        return ((NumericField)this.proFields.elementAt(index)).longValue();
    }

    public int intValue(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.checkComponentType();
        return (int)((NumericField)this.proFields.elementAt(index)).longValue();
    }

    public String check(double[] values) {
        if (values == null) {
            return null;
        }
        this.checkComponentType();
        String errMsg = null;
        int i = 0;
        while (i < values.length) {
            errMsg = ((NumericField)this.component).check(values[i]);
            if (errMsg != null) {
                errMsg = String.valueOf(errMsg) + "\n" + this.getName() + "[" + i + "]";
                break;
            }
            ++i;
        }
        return errMsg;
    }

    private void calculateLength() {
        int bitOffset = 0;
        int i = 0;
        while (i < this.size - 1) {
            int len = ((ProField)this.proFields.elementAt(i)).getLengthInBits();
            bitOffset = !this.arrayPacked ? 8 * ((bitOffset + len + 8 - 1) / 8) : (bitOffset += len);
            ++i;
        }
        if (this.size > 0) {
            bitOffset += ((ProField)this.proFields.elementAt(this.size - 1)).getLengthInBits();
        }
        this.lengthInBits = bitOffset;
        this.lengthCalculated = true;
    }

    private int getLengthInBits(int size, int len) {
        int lenLast = len;
        if (!this.arrayPacked) {
            len = 8 * ((len + 8 - 1) / 8);
        }
        if (size > 1) {
            return (size - 1) * len + lenLast;
        }
        if (size == 1) {
            return lenLast;
        }
        return 0;
    }

    private void checkComponentType() {
        if (!NumericField.class.isInstance(this.component)) {
            throw new RuntimeException(MSG_WRONG_COMP_TYPE);
        }
    }

    private void initProFields() {
        this.proFields = new Vector();
        int i = 0;
        while (i < this.size) {
            this.proFields.addElement(((ProField)this.component).clone());
            ((ProField)this.proFields.elementAt(i)).clearValue();
            ++i;
        }
    }
}

