/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.field;

import edu.uml.lgdc.datatype.field.InternalType;
import edu.uml.lgdc.project.IllegalDataFieldException;

public class Bits {
    private static final int MAX_BYTES_BIN_INTEGER = 8;
    private static final int MAX_BITS = 64;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double extractInt(InternalType intType, byte[] data, int byteOffset, int bitOffset, int length) throws IllegalDataFieldException {
        if (!intType.isIntegerBinaryNumber()) {
            throw new IllegalArgumentException("illegal internal type, " + (Object)((Object)intType));
        }
        long value = 0L;
        int restOfFieldLength = length;
        int thisSliceByteOffset = byteOffset;
        int thisSliceBitOffset = bitOffset;
        int thisSliceBitLength = 0;
        while (restOfFieldLength > 0) {
            if ((thisSliceBitOffset += thisSliceBitLength) == 8) {
                thisSliceBitOffset = 0;
                ++thisSliceByteOffset;
            }
            thisSliceBitLength = Math.min(8 - thisSliceBitOffset, restOfFieldLength);
            value |= (long)(Bits.getMasked(data[thisSliceByteOffset], thisSliceBitOffset, thisSliceBitLength) & 0xFF) << restOfFieldLength - thisSliceBitLength;
            restOfFieldLength -= thisSliceBitLength;
        }
        if (!intType.isUnsigned()) {
            if ((data[byteOffset] & 128 >>> bitOffset) == 0) return value;
            if (intType == InternalType.I_TYPE_INT) {
                bitOffset = 64 - length;
                value = value << bitOffset >> bitOffset;
                return value;
            } else {
                if (intType != InternalType.I_TYPE_SMINT) throw new RuntimeException("Illegal integer internal type, " + (Object)((Object)intType));
                value &= (long)(~(1 << length - 1));
                value = -value;
            }
            return value;
        } else {
            if (length != 64) return value;
            throw new IllegalDataFieldException("Too big for unsigned (more than 2^63-1)");
        }
    }

    public static void packInt(InternalType intType, double val, byte[] data, int byteOffset, int bitOffset, int length) throws IllegalDataFieldException {
        if (!intType.isIntegerBinaryNumber()) {
            throw new IllegalArgumentException("illegal internal type, " + (Object)((Object)intType));
        }
        long value = (long)val;
        if (intType == InternalType.I_TYPE_SMINT && value < 0L) {
            value = -value;
            value |= (long)(1 << length - 1);
        }
        int restOfFieldLength = length;
        int resultSliceByteOffset = byteOffset + (bitOffset + length - 1) / 8;
        int resultSliceBitOffset = (bitOffset + length - 1) % 8;
        int thisSliceBitLength = 0;
        while (restOfFieldLength > 0) {
            if ((resultSliceBitOffset -= thisSliceBitLength) == -1) {
                resultSliceBitOffset = 7;
                --resultSliceByteOffset;
            }
            thisSliceBitLength = Math.min(resultSliceBitOffset + 1, restOfFieldLength);
            byte piece = (byte)(value & (-1L << thisSliceBitLength ^ 0xFFFFFFFFFFFFFFFFL));
            if (resultSliceBitOffset - thisSliceBitLength + 1 == 0) {
                data[resultSliceByteOffset] = 0;
            }
            Bits.putMasked(piece, data, resultSliceByteOffset, resultSliceBitOffset - thisSliceBitLength + 1, thisSliceBitLength);
            value >>= thisSliceBitLength;
            restOfFieldLength -= thisSliceBitLength;
        }
        if (intType.isUnsigned() && length == 64) {
            throw new IllegalDataFieldException("Too big for unsigned (more than 2^63-1)");
        }
    }

    public static byte getMasked(byte data, int offset, int length) {
        return (byte)(((long)data & (-1L << length ^ 0xFFFFFFFFFFFFFFFFL) << offset) >>> offset);
    }

    public static void putMasked(byte value, byte[] data, int index, int offset, int length) {
        data[index] = (byte)((long)data[index] & ((-1L << length ^ 0xFFFFFFFFFFFFFFFFL) << offset ^ 0xFFFFFFFFFFFFFFFFL) | (long)(value << offset));
    }
}

