/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.field;

import edu.uml.lgdc.datatype.field.Bits;
import edu.uml.lgdc.datatype.field.ExternalType;
import edu.uml.lgdc.datatype.field.InternalType;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.format.StrDecoder;
import edu.uml.lgdc.format.StrUtil;
import edu.uml.lgdc.math.Search;
import edu.uml.lgdc.project.IllegalDataFieldException;
import edu.uml.lgdc.quantities.U_code;
import edu.uml.lgdc.quantities.U_count;
import edu.uml.lgdc.quantities.U_number;
import edu.uml.lgdc.quantities.Units;

public abstract class FieldDesc {
    private static final int MAX_BYTES_BIN_INTEGER = 8;
    private static final long MAX_NUMBER = Long.MAX_VALUE;
    private static final long MIN_NUMBER = Long.MIN_VALUE;
    private static final String MAX_NUMBER_STR = "9223372036854775807";
    private static final String MIN_NUMBER_STR = "-9223372036854775808";
    private static final int MAX_LENGTH_OF_POSITIVE_ASCII_CODED_DECIMAL = "9223372036854775807".length();
    private static final int MAX_LENGTH_OF_NEGATIVE_ASCII_CODED_DECIMAL = "-9223372036854775808".length();
    private static final int NUMBER_OF_BYTES_PER_FLOAT = 4;
    private static final int NUMBER_OF_BYTES_PER_DOUBLE = 8;
    private String name;
    private String description;
    private String mnemonic;
    private Units iUnits;
    private int wholeBytesLength = 1;
    private int extraBitsLength = 0;
    private InternalType iType = InternalType.I_TYPE_UINT;
    private boolean aligned = true;
    private ExternalType eType = ExternalType.E_TYPE_LONG;
    private Units eUnits;
    private double intMinVal;
    private double extMinVal;
    private boolean minValWasSet = false;
    private double intMinPossibleVal;
    private double intMaxVal;
    private double extMaxVal;
    private boolean maxValWasSet = false;
    private double intMaxPossibleVal;
    private double[] set;
    private double[] extSet;
    private String[] strSet;
    private boolean strLengthRestricted = false;
    private int maxStrLength = -1;
    private double[] codes;
    private double[] doubleValues;
    private String[] stringValues;
    private String[] strCodes;
    private String[] strValues;
    private double userFactor = 1.0;
    private double factor = 1.0;
    private int numberOfErrors = 0;
    private String[] errMes;

    protected FieldDesc(String name) {
        this(name, U_count.get());
    }

    protected FieldDesc(String name, Units iUnits) {
        this(name, iUnits, InternalType.I_TYPE_UINT);
    }

    protected FieldDesc(String name, Units iUnits, InternalType iType) {
        this(name, iUnits, iType, 1);
    }

    protected FieldDesc(String name, Units iUnits, InternalType iType, int wholeBytesLength) {
        this(name, iUnits, iType, wholeBytesLength, 0);
    }

    protected FieldDesc(String name, Units iUnits, InternalType iType, int wholeBytesLength, int extraBitsLength) {
        this(name, iUnits, iType, wholeBytesLength, extraBitsLength, "");
    }

    protected FieldDesc(String name, Units iUnits, InternalType iType, int wholeBytesLength, int extraBitsLength, String mnemonic) {
        this(name, iUnits, iType, wholeBytesLength, extraBitsLength, mnemonic, true);
    }

    protected FieldDesc(String name, Units iUnits, InternalType iType, int wholeBytesLength, int extraBitsLength, String mnemonic, boolean aligned) {
        this(name, iUnits, iType, wholeBytesLength, extraBitsLength, mnemonic, aligned, "");
    }

    protected FieldDesc(String name, Units iUnits, InternalType iType, int wholeBytesLength, int extraBitsLength, String mnemonic, boolean aligned, String description) {
        this.name = name;
        this.iUnits = iUnits;
        this.iType = iType;
        this.wholeBytesLength = wholeBytesLength;
        this.extraBitsLength = extraBitsLength;
        this.mnemonic = mnemonic;
        this.aligned = aligned;
        this.description = description;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof FieldDesc) {
            FieldDesc fd = (FieldDesc)object;
            return this.mnemonic.equals(fd.mnemonic) && (this.eUnits == fd.eUnits || this.eUnits != null && this.eUnits.equals(fd.eUnits));
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.mnemonic) + (this.eUnits != null ? ":" + this.eUnits.getName() : "");
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getName() {
        return this.name;
    }

    public Units getIntUnits() {
        return this.iUnits;
    }

    public InternalType getIntType() {
        return this.iType;
    }

    public int getWholeBytesLength() {
        return this.wholeBytesLength;
    }

    public int getExtraBitsLength() {
        return this.extraBitsLength;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public boolean getAligned() {
        return this.aligned;
    }

    public String getDescription() {
        return this.description;
    }

    public Units getExtUnits() {
        return this.eUnits;
    }

    public ExternalType getExtType() {
        return this.eType;
    }

    public double getMinValue() {
        return this.extMinVal;
    }

    public double getIntMinValue() {
        return this.intMinVal;
    }

    public boolean isMinValueWasSet() {
        return this.minValWasSet;
    }

    public double getMaxValue() {
        return this.extMaxVal;
    }

    public double getIntMaxValue() {
        return this.intMaxVal;
    }

    public boolean isMaxValueWasSet() {
        return this.maxValWasSet;
    }

    public boolean isStrLengthRestricted() {
        return this.strLengthRestricted;
    }

    public int getMaxStrLength() {
        return this.maxStrLength;
    }

    public boolean isSetSet() {
        if (this.isNumber()) {
            return this.set != null;
        }
        return this.strSet != null;
    }

    public boolean isCodeWasSet() {
        if (this.isNumber()) {
            return this.codes != null;
        }
        return this.strCodes != null;
    }

    public double[] getSet() {
        return this.set;
    }

    public String[] getStrSet() {
        return this.strSet;
    }

    public double[] getCodes() {
        return this.codes;
    }

    public String[] getStrCodes() {
        return this.strCodes;
    }

    public double[] getDoubleValues() {
        return this.doubleValues;
    }

    public String[] getStringValues() {
        return this.stringValues;
    }

    public String[] getStrValues() {
        return this.strValues;
    }

    protected void setIntUnits(Units value) {
        this.iUnits = value;
    }

    protected void setIntType(InternalType value) {
        this.iType = value;
    }

    protected void setWholeBytesLength(int value) {
        this.wholeBytesLength = value;
    }

    protected void setExtraBitsLength(int value) {
        this.extraBitsLength = value;
    }

    protected void setMnemonic(String value) {
        this.mnemonic = value;
    }

    protected void setAligned(boolean value) {
        this.aligned = value;
    }

    protected void setDescription(String value) {
        this.description = value;
    }

    protected void setExtUnits(Units value) {
        this.eUnits = value;
    }

    protected void setExtType(ExternalType value) {
        this.eType = value;
    }

    protected void setMinMaxVal(double minValue, double maxValue) {
        this.setMinVal(minValue);
        this.setMaxVal(maxValue);
    }

    protected void setMinVal(double value) {
        this.extMinVal = value;
        this.minValWasSet = true;
    }

    public void setMaxVal(double value) {
        this.extMaxVal = value;
        this.maxValWasSet = true;
    }

    protected void setMaxStrLength(int maxStrLength) {
        this.maxStrLength = maxStrLength;
        this.strLengthRestricted = true;
    }

    protected void setSet(int[] set) {
        if (set == null) {
            this.set = null;
        } else {
            this.set = new double[set.length];
            int i = 0;
            while (i < set.length) {
                this.set[i] = set[i];
                ++i;
            }
        }
    }

    protected void setSet(long[] set) {
        if (set == null) {
            this.set = null;
        } else {
            this.set = new double[set.length];
            int i = 0;
            while (i < set.length) {
                this.set[i] = set[i];
                ++i;
            }
        }
    }

    protected void setSet(double[] set) {
        this.set = set;
    }

    protected void setStrSet(String[] set) {
        this.strSet = set;
    }

    protected void setCodesValues(int[] codes, double[] values) {
        this.setCodes(codes);
        this.doubleValues = values;
    }

    protected void setCodesValues(long[] codes, double[] values) {
        this.setCodes(codes);
        this.doubleValues = values;
    }

    protected void setCodesValues(int[] codes, int[] values) {
        this.setCodes(codes);
        this.doubleValues = new double[values.length];
        int i = 0;
        while (i < values.length) {
            this.doubleValues[i] = values[i];
            ++i;
        }
    }

    protected void setCodesNames(int[] codes, String[] values) {
        this.setCodes(codes);
        this.stringValues = values;
    }

    protected void setCodesNames(long[] codes, String[] values) {
        this.setCodes(codes);
        this.stringValues = values;
    }

    protected void setCodesValues(double[] codes, double[] values) {
        this.codes = codes;
        this.doubleValues = values;
    }

    protected void setCodesNames(double[] codes, String[] values) {
        this.codes = codes;
        this.stringValues = values;
    }

    private void setCodes(int[] codes) {
        if (codes == null) {
            this.codes = null;
        } else {
            this.codes = new double[codes.length];
            int i = 0;
            while (i < codes.length) {
                this.codes[i] = codes[i];
                ++i;
            }
        }
    }

    private void setCodes(long[] codes) {
        if (codes == null) {
            this.codes = null;
        } else {
            this.codes = new double[codes.length];
            int i = 0;
            while (i < codes.length) {
                this.codes[i] = codes[i];
                ++i;
            }
        }
    }

    protected void setCodesNames(String[] codes, String[] values) {
        this.strCodes = codes;
        this.strValues = values;
    }

    protected void setFactor(double value) {
        this.userFactor = value;
    }

    protected void checkInit() {
        if (this.name == null || this.name.length() == 0) {
            throw new IllegalArgumentException("name is null or empty");
        }
        if (!this.isString() && this.wholeBytesLength < 0) {
            throw new IllegalArgumentException("wholeBytesLength is less than 0");
        }
        if (!this.isString() && this.extraBitsLength < 0) {
            throw new IllegalArgumentException("extraBitsLength is less than 0");
        }
        if (!this.isString() && this.wholeBytesLength == 0 && this.extraBitsLength == 0) {
            throw new IllegalArgumentException("Both wholeBytesLength and extraBitsLength are zero");
        }
        if (this.extraBitsLength >= 8) {
            throw new IllegalArgumentException("extraBitsLength >= 7");
        }
        if (this.isFloatingBinaryNumber()) {
            if (this.iType == InternalType.I_TYPE_FLOAT && (this.wholeBytesLength != 4 || this.extraBitsLength != 0)) {
                throw new IllegalArgumentException("For Float field wholeBytesLength should be 4 and extraBitsLength = 0");
            }
            if (this.iType == InternalType.I_TYPE_DOUBLE && (this.wholeBytesLength != 8 || this.extraBitsLength != 0)) {
                throw new IllegalArgumentException("For Double field wholeBytesLength should be 8 and extraBitsLength = 0");
            }
        }
        if (!this.isIntegerBinaryNumber()) {
            if (this.extraBitsLength > 0) {
                throw new IllegalArgumentException("Length of field should be multiple byte length except for binary integer number fields");
            }
            if (!this.aligned) {
                throw new IllegalArgumentException("Field should be aligned to byte boundary except for binary integer number fields");
            }
        }
        if (this.isIntegerBinaryNumber()) {
            if (this.wholeBytesLength == 8 && this.extraBitsLength > 0) {
                throw new IllegalArgumentException("extraBitsLength is > 0 when wholeBytesLength is 8");
            }
            if (this.wholeBytesLength == 8 && this.isUnsigned()) {
                throw new IllegalArgumentException("Can not keep unsigned 8-bytes integer");
            }
            if (this.getLengthInBits() == 1 && !this.isUnsigned()) {
                throw new IllegalArgumentException("1-bit field should be unsigned");
            }
        }
        if (this.mnemonic == null) {
            this.mnemonic = "";
        }
        if (this.description == null) {
            this.description = "";
        }
        if (this.isNumber()) {
            if (this.eType != ExternalType.E_TYPE_LONG && this.eType != ExternalType.E_TYPE_DOUBLE) {
                throw new IllegalArgumentException("eType is illegal (" + (Object)((Object)this.eType) + ") for number");
            }
            if (this.iUnits == null) {
                this.iUnits = U_number.get();
            }
            if (this.eUnits == null && this.iUnits != U_code.get()) {
                this.eUnits = this.iUnits;
            }
        } else if (this.isString()) {
            if (this.iUnits != null && this.iUnits != U_code.get()) {
                throw new IllegalArgumentException("iUnits can be either null or U_code (but is " + this.iUnits.getName() + ") for String type");
            }
            this.eUnits = null;
        }
        int length = this.getLengthInBits();
        switch (this.iType) {
            case I_TYPE_UINT: {
                this.intMinPossibleVal = 0.0;
                this.intMaxPossibleVal = -1L << length ^ 0xFFFFFFFFFFFFFFFFL;
                break;
            }
            case I_TYPE_INT: {
                this.intMaxPossibleVal = -1L << length - 1 ^ 0xFFFFFFFFFFFFFFFFL;
                this.intMinPossibleVal = -this.intMaxPossibleVal - 1.0;
                break;
            }
            case I_TYPE_SMINT: {
                this.intMaxPossibleVal = -1L << length - 1 ^ 0xFFFFFFFFFFFFFFFFL;
                this.intMinPossibleVal = -this.intMaxPossibleVal;
                break;
            }
            case I_TYPE_FLOAT: {
                this.intMinPossibleVal = -3.4028234663852886E38;
                this.intMaxPossibleVal = 3.4028234663852886E38;
                break;
            }
            case I_TYPE_DOUBLE: {
                this.intMinPossibleVal = -1.7976931348623157E308;
                this.intMaxPossibleVal = Double.MAX_VALUE;
                break;
            }
            case I_TYPE_UNSIGNED_ASCII_CODED_DECIMAL: {
                this.intMinPossibleVal = 0.0;
                this.intMaxPossibleVal = this.wholeBytesLength < MAX_LENGTH_OF_POSITIVE_ASCII_CODED_DECIMAL ? (long)Math.pow(10.0, length) - 1L : Long.MAX_VALUE;
                break;
            }
            case I_TYPE_SIGNED_ASCII_CODED_DECIMAL: {
                this.intMaxPossibleVal = this.wholeBytesLength < MAX_LENGTH_OF_POSITIVE_ASCII_CODED_DECIMAL ? (double)((long)Math.pow(10.0, length) - 1L) : 9.223372036854776E18;
                if (this.wholeBytesLength < MAX_LENGTH_OF_NEGATIVE_ASCII_CODED_DECIMAL) {
                    this.intMinPossibleVal = 1L - (long)Math.pow(10.0, length);
                    break;
                }
                this.intMinPossibleVal = -9.223372036854776E18;
                break;
            }
        }
        if (this.iUnits == null || this.iUnits != U_code.get()) {
            if (this.isNumber()) {
                if (!this.iUnits.isComparable(this.eUnits)) {
                    throw new IllegalArgumentException("iUnits and eUnits are incomparable, " + this.iUnits.getName() + " and " + this.eUnits.getName());
                }
                if ((this.minValWasSet || this.maxValWasSet) && this.set != null) {
                    throw new IllegalArgumentException("Only one of minVal, maxVal, set, or code can be set");
                }
                if (this.minValWasSet && this.maxValWasSet && this.extMinVal > this.extMaxVal) {
                    throw new IllegalArgumentException("extMminVal > extMaxVal, " + this.extMinVal + ">" + this.extMaxVal);
                }
                if (this.set != null && !this.checkArray(this.set)) {
                    throw new IllegalArgumentException("set is out of range");
                }
            }
        } else if (this.isNumber()) {
            if (this.codes == null || this.codes.length == 0) {
                throw new IllegalArgumentException("codes is null");
            }
            if (this.doubleValues == null && this.stringValues == null) {
                throw new IllegalArgumentException("code values is null");
            }
            if (this.doubleValues != null && this.codes.length != this.doubleValues.length) {
                throw new IllegalArgumentException("codes.length != doubleValues.length");
            }
            if (this.stringValues != null && this.codes.length != this.stringValues.length) {
                throw new IllegalArgumentException("codes.length != stringValues.length");
            }
            if (this.stringValues != null && this.eUnits != null) {
                throw new IllegalArgumentException("External units should not be given for string code values");
            }
            if (this.minValWasSet || this.maxValWasSet || this.set != null) {
                throw new IllegalArgumentException("Only one of minVal, maxVal, set, or code can be set");
            }
            if (!this.checkArray(this.codes)) {
                throw new IllegalArgumentException("codes is out of range");
            }
        } else if (this.isString()) {
            if (this.strCodes == null || this.strCodes.length == 0) {
                throw new IllegalArgumentException("strCodes is null");
            }
            if (this.strValues == null) {
                throw new IllegalArgumentException("strValues is null");
            }
            if (this.strCodes.length != this.strValues.length) {
                throw new IllegalArgumentException("codes.length != strValues.length");
            }
            if (this.strSet != null) {
                throw new IllegalArgumentException("Only one of strCodes or strValues can be set");
            }
        }
        if (this.isNumber()) {
            this.factor = this.eUnits == null ? 1.0 : this.eUnits.getFactor() / this.iUnits.getFactor();
            this.factor *= this.userFactor;
            if (!this.minValWasSet) {
                this.intMinVal = this.intMinPossibleVal;
                this.extMinVal = this.factor * this.intMinVal;
            }
            if (!this.maxValWasSet) {
                this.intMaxVal = this.intMaxPossibleVal;
                this.extMaxVal = this.factor * this.intMaxVal;
            }
            if (this.iUnits == null || this.iUnits != U_code.get()) {
                if (this.minValWasSet && (this.intMinVal < this.intMinPossibleVal || this.intMinVal > this.intMaxPossibleVal)) {
                    throw new IllegalArgumentException("minVal is out of range");
                }
                if (this.maxValWasSet && (this.intMaxVal < this.intMinPossibleVal || this.intMaxVal > this.intMaxPossibleVal)) {
                    throw new IllegalArgumentException("maxVal is out of range");
                }
            }
        }
        if (this.isNumber()) {
            if (this.iUnits != null && this.iUnits == U_code.get() || this.set != null) {
                if (this.factor == 1.0) {
                    this.numberOfErrors = 1;
                    this.errMes = new String[]{"Field " + this.name + " is illegal, #Val#"};
                } else {
                    this.numberOfErrors = 2;
                    this.errMes = new String[]{"Internal value of field " + this.name + " is illegal, #intVal#", "External value of field " + this.name + " is illegal, #extVal#"};
                }
            } else if (this.factor == 1.0) {
                this.numberOfErrors = 1;
                this.errMes = new String[]{"Field " + this.name + " is out of range, #Val#"};
            } else {
                this.numberOfErrors = 2;
                this.errMes = new String[]{"Internal value of field " + this.name + " is out of range, #intVal#", "External value of field " + this.name + " is out of range, #extVal#"};
            }
        } else {
            this.numberOfErrors = 1;
            this.errMes = this.iUnits != null && this.iUnits == U_code.get() || this.set != null ? new String[]{"String field " + this.name + " is illegal, #Val#"} : new String[]{"String field " + this.name + " is too long, #Val#"};
        }
        if (this.iType == InternalType.I_TYPE_UNSIGNED_ASCII_CODED_DECIMAL || this.iType == InternalType.I_TYPE_SIGNED_ASCII_CODED_DECIMAL) {
            String[] tmp = new String[this.errMes.length + 2];
            int i = this.errMes.length - 1;
            while (i >= 0) {
                tmp[i + 2] = this.errMes[i];
                --i;
            }
            tmp[0] = "Length of encoded string is too big, field " + this.name;
            tmp[1] = "Illegal symbols in field " + this.name;
            this.errMes = tmp;
        }
        if (this.set != null) {
            this.extSet = new double[this.set.length];
            int i = 0;
            while (i < this.set.length) {
                this.extSet[i] = this.factor * this.set[i];
                ++i;
            }
        }
        this.intMinVal = this.extMinVal / this.factor;
        this.intMaxVal = this.extMaxVal / this.factor;
    }

    public String[] getNames() {
        if (this.isNumber()) {
            if (this.codes != null) {
                if (this.stringValues != null) {
                    return this.stringValues;
                }
                return FieldDesc.doubleArrayToStringArray(this.doubleValues);
            }
            if (this.set != null) {
                return FieldDesc.doubleArrayToStringArray(this.extSet);
            }
            return FieldDesc.doubleArrayToStringArray(this.getRangeValuesAsDoubleArray());
        }
        if (this.isString()) {
            if (this.strCodes != null) {
                return this.strValues;
            }
            if (this.strSet != null) {
                return this.strSet;
            }
            return null;
        }
        return null;
    }

    public double getIntValueByIndex(int index) {
        if (!this.isNumber()) {
            throw new RuntimeException("This method has to be used only for Number types");
        }
        if (this.codes != null) {
            return this.codes[index];
        }
        if (this.set != null) {
            return this.set[index];
        }
        return this.intMinVal + (double)index;
    }

    public String getStrIntValueByIndex(int index) {
        if (!this.isString()) {
            throw new RuntimeException("This method has to be used only for String types");
        }
        if (this.strCodes != null) {
            return this.strCodes[index];
        }
        if (this.strSet != null) {
            return this.strSet[index];
        }
        return null;
    }

    public double getExtValueByIndex(int index) {
        if (!this.isNumber()) {
            throw new RuntimeException("This method has to be used only for Number types");
        }
        if (this.codes != null) {
            if (this.stringValues != null) {
                return this.codes[index];
            }
            return this.doubleValues[index];
        }
        if (this.set != null) {
            return this.extSet[index];
        }
        return this.get((long)this.intMinVal + (long)index);
    }

    public String getStrExtValueByIndex(int index) {
        if (!this.isString()) {
            throw new RuntimeException("This method has to be used only for String types");
        }
        if (this.strCodes != null) {
            return this.strValues[index];
        }
        if (this.strSet != null) {
            return this.strSet[index];
        }
        return null;
    }

    public int getIndexByIntValue(double value) {
        if (!this.isNumber()) {
            throw new RuntimeException("This method has to be used only for Number types");
        }
        if (this.iUnits != null && this.iUnits == U_code.get()) {
            return Search.scan(this.codes, value);
        }
        if (this.set != null) {
            return Search.scan(this.set, value);
        }
        if (!this.isFloatingBinaryNumber()) {
            return (int)(value - this.intMinVal);
        }
        throw new RuntimeException("field name '" + this.name + "', this method can not be applied to continuum");
    }

    public int getIndexByIntValue(String value) {
        if (!this.isString()) {
            throw new RuntimeException("This method has to be used only for String types");
        }
        if (this.iUnits != null && this.iUnits == U_code.get()) {
            return Search.scanStr(this.strCodes, value);
        }
        if (this.strSet != null) {
            return Search.scanStr(this.strSet, value);
        }
        return -1;
    }

    public int getIndexByExtValue(double extValue) {
        if (!this.isNumber()) {
            throw new RuntimeException("This method has to be used only for Number types");
        }
        return this.getIndexByIntValue(this.getInt(extValue));
    }

    public int getIndexByExtValue(String extValue) {
        if (!this.isString()) {
            throw new RuntimeException("This method has to be used only for String types");
        }
        return this.getIndexByIntValue(this.getInt(extValue));
    }

    private static String[] doubleArrayToStringArray(double[] values) {
        String[] strValues = new String[values.length];
        int i = 0;
        while (i < values.length) {
            strValues[i] = FC.doubleToString(values[i], 8, true);
            ++i;
        }
        return strValues;
    }

    private double[] getRangeValuesAsDoubleArray() {
        if (this.isFloatingBinaryNumber() && this.codes == null && this.set == null) {
            throw new RuntimeException("field name '" + this.name + "', this method can not be applied to continuum");
        }
        int dim = (int)(this.extMaxVal - this.extMinVal + 1.0);
        double[] values = new double[dim];
        int i = 0;
        while (i < dim) {
            values[i] = this.extMinVal + (double)i;
            ++i;
        }
        return values;
    }

    public double extractInt(byte[] data, int byteOffset) throws IllegalDataFieldException {
        return this.extractInt(data, byteOffset, 0);
    }

    protected double extractInt(byte[] data, int byteOffset, int bitOffset) throws IllegalDataFieldException {
        if (!this.isBinaryNumber()) {
            throw new RuntimeException("Field " + this.name + " is not a binary field");
        }
        if (this.isFloatingBinaryNumber()) {
            return this.extractFloatingInt(data, byteOffset, bitOffset);
        }
        return Bits.extractInt(this.iType, data, byteOffset, bitOffset, this.getLengthInBits());
    }

    protected double extractFloatingInt(byte[] data, int byteOffset, int bitOffset) throws IllegalDataFieldException {
        if (!this.isFloatingBinaryNumber()) {
            throw new RuntimeException("field " + this.name + ", is not a floating binary field");
        }
        if (bitOffset != 0) {
            throw new IllegalArgumentException("field " + this.name + ", parameter " + bitOffset + " should be 0 for floating binary field");
        }
        if (this.iType == InternalType.I_TYPE_DOUBLE) {
            return FC.bytes2Double(data, byteOffset);
        }
        return FC.bytes2Float(data, byteOffset);
    }

    protected void packInt(double val, byte[] data, int byteOffset, int bitOffset) throws IllegalDataFieldException {
        if (!this.isBinaryNumber()) {
            throw new RuntimeException("Field " + this.name + " is not a binary field");
        }
        if (this.isFloatingBinaryNumber()) {
            this.packFloatingInt(val, data, byteOffset, bitOffset);
            return;
        }
        Bits.packInt(this.iType, val, data, byteOffset, bitOffset, this.getLengthInBits());
    }

    protected void packFloatingInt(double value, byte[] data, int byteOffset, int bitOffset) throws IllegalDataFieldException {
        if (!this.isFloatingBinaryNumber()) {
            throw new RuntimeException("FieldDesc.packFloatingInt: field " + this.name + ", is not a floating " + "binary field");
        }
        if (bitOffset != 0) {
            throw new IllegalArgumentException("FieldDesc.packFloatingInt: field " + this.name + ", parameter " + bitOffset + " should be 0 for floating binary field");
        }
        if (this.iType == InternalType.I_TYPE_DOUBLE) {
            FC.convertDouble2Bytes(value, data, byteOffset);
        } else {
            FC.convertFloat2Bytes((float)value, data, byteOffset);
        }
    }

    protected String checkEncodedNumber(byte[] data, int byteOffset) {
        char c;
        if (!this.isEncodedNumber()) {
            throw new RuntimeException("Field " + this.name + " is not an encoded number field");
        }
        String errMsg = null;
        String asciiStr = StrUtil.trimLeft(StrDecoder.runISO_8859_1(data, byteOffset, this.wholeBytesLength));
        boolean positive = true;
        if (this.iType == InternalType.I_TYPE_SIGNED_ASCII_CODED_DECIMAL && ((c = asciiStr.charAt(0)) == '-' || c == '+')) {
            asciiStr = asciiStr.substring(1);
            if (c == '-') {
                positive = false;
            }
        }
        asciiStr = StrUtil.trimLeft(asciiStr, '0');
        if (positive && (asciiStr.length() > MAX_LENGTH_OF_POSITIVE_ASCII_CODED_DECIMAL || asciiStr.length() == MAX_LENGTH_OF_POSITIVE_ASCII_CODED_DECIMAL && asciiStr.compareTo(MAX_NUMBER_STR) == 1)) {
            errMsg = "Encoded number of field " + this.name + " is to big for converting to binary";
        } else if (!positive && (asciiStr.length() > MAX_LENGTH_OF_NEGATIVE_ASCII_CODED_DECIMAL || asciiStr.length() == MAX_LENGTH_OF_NEGATIVE_ASCII_CODED_DECIMAL && asciiStr.compareTo(MIN_NUMBER_STR) == 1)) {
            errMsg = "Encoded number of field " + this.name + " is to big for converting to binary";
        } else if (!StrUtil.isOnlyDigits(asciiStr)) {
            errMsg = "Encoded number of field " + this.name + " contains not digits";
        }
        return errMsg;
    }

    protected long decodeNumber(byte[] data, int byteOffset) {
        if (!this.isEncodedNumber()) {
            throw new RuntimeException("Field " + this.name + " is not an encoded number field");
        }
        return FC.StringToInteger(StrDecoder.runISO_8859_1(data, byteOffset, this.wholeBytesLength));
    }

    protected void EncodeNumber(int value, byte[] data, int byteOffset) {
        if (!this.isEncodedNumber()) {
            throw new RuntimeException("Field " + this.name + " is not an encoded number field");
        }
        String str = FC.IntegerToString(value);
        str = FC.padLeft(str, this.wholeBytesLength, '0');
        System.arraycopy(str.getBytes(), 0, data, byteOffset, str.length());
    }

    public String checkInt(byte[] data, int byteOffset) throws IllegalDataFieldException {
        return this.checkInt(data, byteOffset, 0);
    }

    public String checkInt(byte[] data, int byteOffset, int bitOffset) throws IllegalDataFieldException {
        return this.checkInt(this.extractInt(data, byteOffset, bitOffset));
    }

    public String checkInt(double intValue) {
        if (!this.isNumber()) {
            throw new RuntimeException("This method has to be used only for Number types");
        }
        boolean ok = this.iUnits != null && this.iUnits == U_code.get() ? Search.scan(this.codes, intValue) >= 0 : (this.set == null ? intValue >= this.intMinVal && intValue <= this.intMaxVal : Search.scan(this.set, intValue) >= 0);
        return ok ? null : "Internal value, " + intValue + ", for field " + this.name + " is illegal";
    }

    public String checkInt(String intValue) {
        if (!this.isString()) {
            throw new RuntimeException("This method has to be used only for String types");
        }
        boolean ok = true;
        if (this.iUnits != null && this.iUnits == U_code.get()) {
            ok = Search.scanStr(this.strCodes, intValue) >= 0;
        } else if (this.strSet != null) {
            ok = Search.scanStr(this.strSet, intValue) >= 0;
        } else if (this.strLengthRestricted) {
            ok = intValue.length() <= this.maxStrLength;
        }
        return ok ? null : "Internal value, " + intValue + ", for field " + this.name + " is illegal";
    }

    public String checkExt(double extValue) {
        if (!this.isNumber()) {
            throw new RuntimeException("This method has to be used only for Number types");
        }
        boolean ok = false;
        if (this.iUnits != null && this.iUnits == U_code.get()) {
            ok = this.doubleValues != null ? Search.scan(this.doubleValues, extValue) >= 0 : Search.scan(this.codes, extValue) >= 0;
        } else if (this.set == null) {
            ok = extValue >= this.extMinVal && extValue <= this.extMaxVal;
        } else {
            boolean bl = ok = Search.scan(this.extSet, extValue) >= 0;
        }
        if (ok) {
            return null;
        }
        return "External value, " + extValue + ", for field " + this.name + " is illegal";
    }

    public String checkExt(String extValue) {
        if (!this.isString()) {
            throw new RuntimeException("This method has to be used only for String types");
        }
        String errMsg = "External value, " + extValue + ", for field " + this.name + " is illegal";
        if (this.iUnits != null && this.iUnits == U_code.get() ? Search.scanStr(this.strValues, extValue) < 0 : (this.strSet != null ? Search.scanStr(this.strSet, extValue) < 0 : this.strLengthRestricted && extValue.length() > this.maxStrLength)) {
            return errMsg;
        }
        return null;
    }

    protected double get(double intValue) {
        if (!this.isNumber()) {
            throw new RuntimeException("This method has to be used only for Number types");
        }
        if (this.iUnits != null && this.iUnits == U_code.get()) {
            if (this.doubleValues != null) {
                return this.doubleValues[Search.scan(this.codes, intValue)];
            }
            return intValue;
        }
        if (this.set != null) {
            return this.extSet[Search.scan(this.set, intValue)];
        }
        return intValue * this.factor;
    }

    protected String get(String intValue) {
        if (!this.isString()) {
            throw new RuntimeException("This method has to be used only for String types");
        }
        if (this.iUnits != null && this.iUnits == U_code.get()) {
            return this.strValues[Search.scanStr(this.strCodes, intValue)];
        }
        return intValue;
    }

    public double getInt(long extValue) {
        if (!this.isNumber()) {
            throw new RuntimeException("This method has to be used only for number types");
        }
        if (this.iUnits != null && this.iUnits == U_code.get()) {
            if (this.doubleValues != null) {
                int index = Search.scan(this.doubleValues, (double)extValue);
                if (index >= 0) {
                    return this.codes[index];
                }
                throw new IllegalArgumentException("illegal value, " + extValue);
            }
            return extValue;
        }
        if (this.set != null) {
            int index = Search.scan(this.extSet, (double)extValue);
            if (index >= 0) {
                return this.set[index];
            }
            throw new IllegalArgumentException("illegal value, " + extValue);
        }
        return (double)extValue / this.factor;
    }

    public double getInt(double extValue) {
        if (!this.isNumber()) {
            throw new RuntimeException("This method has to be used only for number types");
        }
        if (this.iUnits != null && this.iUnits == U_code.get()) {
            if (this.doubleValues != null) {
                return this.codes[Search.scan(this.doubleValues, extValue)];
            }
            return extValue;
        }
        if (this.set != null) {
            return this.set[Search.scan(this.extSet, extValue)];
        }
        return extValue / this.factor;
    }

    public String getInt(String extValue) {
        if (!this.isString()) {
            throw new RuntimeException("This method has to be used only for String types");
        }
        if (this.iUnits != null && this.iUnits == U_code.get()) {
            return this.strCodes[Search.scanStr(this.strValues, extValue)];
        }
        return extValue;
    }

    public long getNumberOfValues() {
        if (this.isNumber() && !this.isFloatingBinaryNumber()) {
            if (!this.isFloatingBinaryNumber() || this.codes != null || this.set != null) {
                if (this.iUnits != null && this.iUnits == U_code.get()) {
                    return this.codes.length;
                }
                if (this.set != null) {
                    return this.set.length;
                }
                return (int)(this.intMaxVal - this.intMinVal + 1.0);
            }
            throw new RuntimeException("field name '" + this.name + "', this method can not be applied to continuum");
        }
        if (this.isString()) {
            return this.strCodes.length;
        }
        return 0L;
    }

    public int getLengthInBits() {
        return 8 * this.wholeBytesLength + this.extraBitsLength;
    }

    public boolean isUnsigned() {
        return this.iType.isUnsigned();
    }

    public boolean isIntegerBinaryNumber() {
        return this.iType.isIntegerBinaryNumber();
    }

    public boolean isFloatingBinaryNumber() {
        return this.iType.isFloatingBinaryNumber();
    }

    public boolean isBinaryNumber() {
        return this.iType.isBinaryNumber();
    }

    public boolean isEncodedNumber() {
        return this.iType.isEncodedNumber();
    }

    public boolean isNumber() {
        return this.iType.isNumber();
    }

    public boolean isString() {
        return this.iType.isString();
    }

    public int getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public String getError(int errCode) {
        if (errCode < 0 || errCode > this.numberOfErrors) {
            throw new IllegalArgumentException("errCode is out of range");
        }
        if (errCode > 0) {
            return this.errMes[errCode - 1];
        }
        return "No error";
    }

    public String getError(int errCode, long intValue) {
        if (!this.isNumber()) {
            throw new RuntimeException("This method has to be used only for Number types");
        }
        String mes = this.getError(errCode);
        mes = mes.replaceAll("#intVal#", "" + intValue);
        mes = mes.replaceAll("#Val#", "" + intValue);
        return mes;
    }

    public String getError(int errCode, double extValue) {
        if (!this.isNumber()) {
            throw new RuntimeException("This method has to be used only for Number types");
        }
        String mes = this.getError(errCode);
        mes = mes.replaceAll("#extVal#", "" + extValue);
        mes = mes.replaceAll("#Val#", "" + extValue);
        return mes;
    }

    public String getError(int errCode, double extValue, long intValue) {
        if (!this.isNumber()) {
            throw new RuntimeException("This method has to be used only for Number types");
        }
        String mes = this.getError(errCode);
        mes = mes.replaceAll("#intVal#", "" + intValue);
        mes = mes.replaceAll("#extVal#", "" + extValue);
        mes = mes.replaceAll("#Val#", "" + intValue);
        return mes;
    }

    public String getError(int errCode, String extValue) {
        if (!this.isString()) {
            throw new RuntimeException("This method has to be used only for String types");
        }
        String mes = this.getError(errCode);
        mes = mes.replaceAll("#Val#", extValue);
        return mes;
    }

    private boolean checkArray(double[] values) {
        if (!this.isNumber()) {
            throw new RuntimeException("This method has to be used only for Number types");
        }
        boolean result = true;
        int i = 0;
        while (i < values.length) {
            if (values[i] < this.intMinPossibleVal || values[i] > this.intMaxPossibleVal) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }
}

