/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.field;

import edu.uml.lgdc.datatype.field.DoubleField;
import edu.uml.lgdc.datatype.field.ExternalType;
import edu.uml.lgdc.datatype.field.FieldDesc;
import edu.uml.lgdc.datatype.field.LongField;
import edu.uml.lgdc.datatype.field.NumericField;
import edu.uml.lgdc.datatype.field.ProField;
import edu.uml.lgdc.project.IllegalDataFieldException;

public class IntegerField
extends NumericField {
    private int intValue;

    public IntegerField(FieldDesc fieldDesc) {
        super(fieldDesc);
        this.checkFieldDesc();
    }

    public IntegerField(FieldDesc fieldDesc, int value) {
        super(fieldDesc);
        this.checkFieldDesc();
        this.put(value);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof IntegerField) {
            IntegerField field = (IntegerField)obj;
            if (this.valueSet && field.valueSet && this.intValue == field.intValue) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object get() {
        this.checkValueSet();
        return new Integer(this.intValue);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void put(Object obj) {
        err = 0;
        if (!IntegerField.class.isInstance(obj) && !LongField.class.isInstance(obj) && !DoubleField.class.isInstance(obj)) ** GOTO lbl7
        if (!((ProField)obj).isValueSet()) {
            err = 2;
        } else {
            obj = ((ProField)obj).get();
lbl7:
            // 2 sources

            if (Integer.class.isInstance(obj)) {
                this.intValue = (Integer)obj;
            } else if (Long.class.isInstance(obj)) {
                this.intValue = (int)((Long)obj).longValue();
            } else if (Double.class.isInstance(obj)) {
                this.intValue = (int)((Double)obj).doubleValue();
            } else {
                err = 1;
            }
        }
        if (err == 1) {
            throw new RuntimeException("Not an Integer, Long or Double type");
        }
        if (err == 2) {
            throw new RuntimeException("Value is not set");
        }
        this.valueSet = true;
    }

    @Override
    public String check(Object objValue) {
        if (Integer.class.isInstance(objValue)) {
            return this.check((Integer)objValue);
        }
        if (Long.class.isInstance(objValue)) {
            return this.check((Long)objValue);
        }
        if (Double.class.isInstance(objValue)) {
            return this.check((Double)objValue);
        }
        throw new RuntimeException("Not an Integer, Long or Double type");
    }

    @Override
    public String extract(byte[] data, int byteOffset, int bitOffset) throws IllegalDataFieldException {
        double internalVal = -2.147483648E9;
        String errMsg = null;
        if (this.fieldDesc.isBinaryNumber()) {
            internalVal = this.fieldDesc.extractInt(data, byteOffset, bitOffset);
        } else {
            errMsg = this.fieldDesc.checkEncodedNumber(data, byteOffset);
            if (errMsg == null) {
                internalVal = this.fieldDesc.decodeNumber(data, byteOffset);
            }
        }
        if (errMsg == null) {
            errMsg = this.fieldDesc.checkInt(internalVal);
        }
        if (errMsg == null) {
            this.intValue = (int)this.fieldDesc.get(internalVal);
            this.valueSet = true;
        }
        return errMsg;
    }

    @Override
    public void pack(byte[] data, int byteOffset, int bitOffset) throws IllegalDataFieldException {
        this.checkValueSet();
        if (this.fieldDesc.isBinaryNumber()) {
            this.fieldDesc.packInt(this.fieldDesc.getInt(this.intValue), data, byteOffset, bitOffset);
        } else {
            this.fieldDesc.EncodeNumber((int)this.fieldDesc.getInt(this.intValue), data, byteOffset);
        }
    }

    public int intValue() {
        this.checkValueSet();
        return this.intValue;
    }

    public void put(int value) {
        this.intValue = value;
        this.valueSet = true;
    }

    public String check(int value) {
        return this.fieldDesc.checkExt(value);
    }

    @Override
    public long longValue() {
        this.checkValueSet();
        return this.intValue;
    }

    @Override
    public double doubleValue() {
        this.checkValueSet();
        return this.intValue;
    }

    @Override
    public void put(long value) {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("value is too big for integer, " + value);
        }
        this.put((int)value);
    }

    @Override
    public void put(double value) {
        if (value < -2.147483648E9 || value > 2.147483647E9) {
            throw new IllegalArgumentException("value is too big for integer, " + value);
        }
        this.put((int)value);
    }

    @Override
    public String check(long value) {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            return "value is too big for integer, " + value;
        }
        return this.check((int)value);
    }

    @Override
    public String check(double value) {
        if (value < -2.147483648E9 || value > 2.147483647E9) {
            return "value is too big for integer, " + value;
        }
        return this.check((int)value);
    }

    public int hashCode() {
        return this.intValue;
    }

    private void checkFieldDesc() {
        if (this.fieldDesc.getExtType() != ExternalType.E_TYPE_LONG) {
            throw new RuntimeException("External type should be Long for Integer Field");
        }
        if (this.fieldDesc.getMaxValue() > 2.147483647E9 || this.fieldDesc.getMinValue() < -2.147483648E9) {
            throw new RuntimeException("Value can not be more than integer type container is able to fit");
        }
    }
}

