/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.geom;

import edu.uml.lgdc.datatype.geom.R3;
import edu.uml.lgdc.datatype.geom.SetR3Analytical;
import edu.uml.lgdc.datatype.geom.SetR3Finite;
import edu.uml.lgdc.math.ExtMath;
import java.util.Objects;

public class Plane3D
extends SetR3Analytical {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_UNDEF = 1;
    public static final int TYPE_EMPTY = 2;
    public static final String[] TYPE_NAME = new String[]{"NORMAL_LINE", "UNDEFINED_LINE", "EMPTY_LINE"};
    private static final double SMALL_NUMBER = 1.0E-7;
    private double a;
    private double b;
    private double c;
    private double d;
    private R3 point1;
    private R3 point2;
    private R3 point3;
    private R3 point;
    private R3 normalVector;
    private int type = 1;

    public Plane3D(double a, double b, double c, double d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.normalize();
    }

    public Plane3D(R3 point1, R3 point2, R3 point3) {
        this(point1, R3.vecProduct(R3.subtract(point2, point1), R3.subtract(point3, point1)));
        if (this.type == 0) {
            this.point = null;
            this.normalVector = null;
            this.point1 = point1;
            this.point2 = point2;
            this.point3 = point3;
        }
    }

    public Plane3D(R3 point, R3 normalVector) {
        double length = normalVector.length();
        if (!ExtMath.areClose(length, 0.0, 1.0E-7)) {
            R3 normalUnit = R3.scalar(1.0 / length, normalVector);
            this.a = normalUnit.getX();
            this.b = normalUnit.getY();
            this.c = normalUnit.getZ();
            this.d = -(normalUnit.getX() * point.getX() + normalUnit.getY() * point.getY() + normalUnit.getZ() * point.getX());
            this.normalize();
            this.point = point;
            this.normalVector = normalVector;
        } else {
            this.type = 1;
            this.a = 0.0;
            this.b = 0.0;
            this.c = 0.0;
            this.d = 0.0;
        }
    }

    public int getType() {
        return this.type;
    }

    public double calcValueAtPoint(R3 p) {
        return this.a * p.getX() + this.b * p.getY() + this.c * p.getZ() + this.d;
    }

    @Override
    public boolean contains(Object element) {
        if (element instanceof R3) {
            return this.contains((R3)element);
        }
        return false;
    }

    @Override
    public boolean includes(Object object) {
        Objects.requireNonNull(object);
        boolean result = false;
        if (this.type == 0) {
            if (object instanceof SetR3Analytical) {
                if (object instanceof Plane3D) {
                    result = this.includes((Plane3D)object);
                }
            } else if (object instanceof SetR3Finite) {
                result = super.includes((SetR3Finite)object);
            } else if (object instanceof R3) {
                result = this.contains((R3)object);
            } else {
                throw new IllegalArgumentException("illegal type: " + object.getClass().getName());
            }
        }
        return result;
    }

    protected boolean contains(R3 point) {
        return ExtMath.areClose(this.calcValueAtPoint(point), 0.0, 1.0E-7);
    }

    protected boolean includes(Plane3D plane) {
        return this.equals(plane);
    }

    @Override
    public double distance(R3 p) {
        if (!this.contains(p)) {
            if (this.type == 0) {
                return Math.abs(this.calcValueAtPoint(p));
            }
            if (this.type == 2) {
                return Double.MAX_VALUE;
            }
            return Double.NaN;
        }
        return 0.0;
    }

    private void normalize() {
        if (this.a != 0.0 || this.b != 0.0 || this.c != 0.0) {
            this.type = 0;
            double temp = Math.sqrt(this.a * this.a + this.b * this.b + this.c * this.c);
            this.a /= temp;
            this.b /= temp;
            this.c /= temp;
            this.d /= temp;
            if (this.a < 0.0) {
                this.a = -this.a;
                this.b = -this.b;
                this.c = -this.c;
                this.d = -this.d;
            } else if (this.a == 0.0) {
                if (this.b < 0.0) {
                    this.b = -this.b;
                    this.c = -this.c;
                    this.d = -this.d;
                } else if (this.b == 0.0 && this.c < 0.0) {
                    this.c = -this.c;
                    this.d = -this.d;
                }
            }
        } else if (this.d != 0.0) {
            this.type = 2;
            this.d = 1.0;
        } else {
            this.type = 1;
        }
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                if (this.point1 != null) {
                    return "3-point-plane-constructor:" + this.point1 + "-" + this.point2 + this.point3;
                }
                if (this.point != null) {
                    return "point-and-normal-vector-plane-constructor:" + this.point + "-" + this.normalVector;
                }
                return "generic-plane-constructor:(" + this.a + "," + this.b + "," + this.c + "," + this.d + ")";
            }
            case 1: 
            case 2: {
                return TYPE_NAME[this.type];
            }
        }
        throw new RuntimeException("design error: plane type " + this.type + " is illegal");
    }
}

