/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.geom;

import edu.uml.lgdc.datatype.Metricable;
import edu.uml.lgdc.datatype.geom.Line2D;
import edu.uml.lgdc.datatype.geom.Rn;
import edu.uml.lgdc.math.Search;
import edu.uml.lgdc.math.WholeGridLineInterpolation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

public class R2
extends Rn
implements Metricable<R2> {
    private static final long serialVersionUID = 8578624300677500886L;
    public static final int ROUNDTRIP_FORWARD = 0;
    public static final int ROUNDTRIP_BACKWARD = 1;
    public static final int ROUNDTRIP_IMPOSSIBLE = 2;
    private static final double MAX_GAP = 1.0;

    public R2() {
        this(0.0, 0.0);
    }

    public R2(R2 r2) {
        this(r2.getX(), r2.getY());
    }

    public R2(Point point) {
        this((double)point.x, (double)point.y);
    }

    public R2(double[] coords) {
        super(R2.checkCoords(coords)[0], R2.checkCoords(coords)[1]);
    }

    private static double[] checkCoords(double[] coords) {
        if (coords == null) {
            throw new IllegalArgumentException("coords is null");
        }
        if (coords.length != 2) {
            throw new IllegalArgumentException("coords.length != 2, is " + coords.length);
        }
        return coords;
    }

    public R2(double x, double y) {
        super(x, y);
    }

    public double getX() {
        return this.get(0);
    }

    public double getY() {
        return this.get(1);
    }

    @Override
    public double dist(R2 point) {
        return R2.subtract(this, point).length();
    }

    public void setX(double x) {
        this.set(0, x);
    }

    public void setY(double y) {
        this.set(1, y);
    }

    public Point getP() {
        return new Point((int)Math.round(this.getX()), (int)Math.round(this.getY()));
    }

    public R2 setTo(R2 r2) {
        this.setTo(r2.getX(), r2.getY());
        return this;
    }

    public R2 setTo(double x, double y) {
        super.setTo(x, y);
        return this;
    }

    @Override
    public R2 inverse() {
        super.inverse();
        return this;
    }

    public static R2 inverse(R2 v) {
        return new R2(v).inverse();
    }

    public R2 add(R2 v) {
        super.add(v);
        return this;
    }

    public static R2 add(R2 v1, R2 v2) {
        return new R2(v1).add(v2);
    }

    public R2 add(Point v) {
        this.setX(this.getX() + (double)v.x);
        this.setY(this.getY() + (double)v.y);
        return this;
    }

    @Override
    public R2 scalar(double factor) {
        super.scalar(factor);
        return this;
    }

    public static R2 scalar(R2 v, double factor) {
        return new R2(v).scalar(factor);
    }

    public R2 subtract(R2 v) {
        return this.add(new R2(v).inverse());
    }

    public static R2 subtract(R2 v1, R2 v2) {
        return new R2(v2).inverse().add(v1);
    }

    public R2 shift(R2 v) {
        return this.add(v);
    }

    public R2 shiftX(double shiftValue) {
        this.shiftAlongAxis(0, shiftValue);
        return this;
    }

    public R2 shiftY(double shiftValue) {
        this.shiftAlongAxis(1, shiftValue);
        return this;
    }

    public double phaseAngle() {
        return R2.phaseAngle(this.getX(), this.getY());
    }

    @Override
    public R2 normalize() {
        super.normalize();
        return this;
    }

    public static R2 normalize(R2 v) {
        return new R2(v).normalize();
    }

    public double betweenAngle(R2 v) {
        return super.betweenAngle(v);
    }

    public double rotationAngle(R2 v) {
        double angle = v.phaseAngle() - this.phaseAngle();
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public void flip(R2 p) {
        this.rotate(2.0 * this.rotationAngle(p));
    }

    public double dotProduct(R2 vector) {
        return this.scalarProduct(vector);
    }

    public double scalarProduct(R2 vector) {
        return super.scalarProduct(vector);
    }

    public R2 rotate(double angle) {
        double sin = Math.sin(-angle);
        double cos = Math.cos(-angle);
        return this.applyLinearOperator(cos, sin, -sin, cos);
    }

    public R2 mirror() {
        this.setTo(this.getY(), this.getX());
        return this;
    }

    public R2 applyLinearOperator(double a11, double a12, double a21, double a22) {
        super.applyLinearOperator(new double[][]{{a11, a12}, {a21, a22}});
        return this;
    }

    public static Rectangle getRectangle(Point origin, R2 mainDirection, R2 acrossDirection, int mainLength, int acrossLength) {
        R2 p1 = new R2(origin);
        R2 p2 = new R2(acrossDirection);
        R2 p3 = new R2(mainDirection);
        R2 p4 = new R2(acrossDirection);
        p2.scalar(acrossLength - 1).add(p1);
        p3.scalar(mainLength - 1);
        p4.scalar(acrossLength - 1).add(p3).add(p1);
        p3.add(p1);
        return R2.getRectangle(p1.getP(), p2.getP(), p3.getP(), p4.getP());
    }

    public static Rectangle getRectangle(Point p1, Point p2, Point p3, Point p4) {
        int xMin = Math.min(Math.min(p1.x, p2.x), Math.min(p3.x, p4.x));
        int yMin = Math.min(Math.min(p1.y, p2.y), Math.min(p3.y, p4.y));
        int xMax = Math.max(Math.max(p1.x, p2.x), Math.max(p3.x, p4.x));
        int yMax = Math.max(Math.max(p1.y, p2.y), Math.max(p3.y, p4.y));
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    public static Rectangle checkRectangle(Point p1, Point p2, Point p3, Point p4) {
        int y;
        Object[] points = new Point[]{p1, p2, p3, p4};
        int x = Math.min(Math.min(p1.x, p2.x), Math.min(p3.x, p4.x));
        int ind = Search.scan(points, (Object)new Point(x, y = Math.min(Math.min(p1.y, p2.y), Math.min(p3.y, p4.y))));
        if (ind < 0) {
            return null;
        }
        Object minXminY = points[ind];
        x = Math.max(Math.max(p1.x, p2.x), Math.max(p3.x, p4.x));
        y = Math.min(Math.min(p1.y, p2.y), Math.min(p3.y, p4.y));
        ind = Search.scan(points, (Object)new Point(x, y));
        if (ind < 0) {
            return null;
        }
        Object maxXminY = points[ind];
        x = Math.min(Math.min(p1.x, p2.x), Math.min(p3.x, p4.x));
        y = Math.max(Math.max(p1.y, p2.y), Math.max(p3.y, p4.y));
        ind = Search.scan(points, (Object)new Point(x, y));
        if (ind < 0) {
            return null;
        }
        Object minXmaxY = points[ind];
        x = Math.max(Math.max(p1.x, p2.x), Math.max(p3.x, p4.x));
        y = Math.max(Math.max(p1.y, p2.y), Math.max(p3.y, p4.y));
        ind = Search.scan(points, (Object)new Point(x, y));
        if (ind < 0) {
            return null;
        }
        if (((Point)minXminY).x == ((Point)maxXminY).x && ((Point)minXminY).y != ((Point)minXmaxY).y && (p1.y > ((Point)minXminY).y && p1.y < ((Point)minXmaxY).y || p2.y > ((Point)minXminY).y && p2.y < ((Point)minXmaxY).y || p3.y > ((Point)minXminY).y && p3.y < ((Point)minXmaxY).y || p4.y > ((Point)minXminY).y && p4.y < ((Point)minXmaxY).y)) {
            return null;
        }
        if (((Point)minXminY).y == ((Point)minXmaxY).y && ((Point)minXminY).x != ((Point)maxXminY).x && (p1.x > ((Point)minXminY).x && p1.x < ((Point)maxXminY).x || p2.x > ((Point)minXminY).x && p2.x < ((Point)maxXminY).x || p3.x > ((Point)minXminY).x && p3.x < ((Point)maxXminY).x || p4.x > ((Point)minXminY).x && p4.x < ((Point)maxXminY).x)) {
            return null;
        }
        return new Rectangle((Point)minXminY, new Dimension(((Point)maxXminY).x - ((Point)minXminY).x, ((Point)minXmaxY).y - ((Point)minXminY).y));
    }

    public static double phaseAngle(double x, double y) {
        double phase = Math.atan2(y, x);
        if (phase < 0.0) {
            phase += Math.PI * 2;
        }
        return phase;
    }

    public static double getFractureWithBetweenInterpolation(R2[] curve, int index) {
        return R2.getFractureWithBetweenInterpolation(curve, curve.length, index);
    }

    public static double getFractureWithBetweenInterpolation(R2[] curve, int length, int ind) {
        double fracture;
        double fracture1 = fracture = 1.5707963267948966;
        int minLength = 2;
        if (ind <= 0 || ind >= length - 1) {
            return Math.toDegrees(fracture + fracture1);
        }
        double x1 = curve[ind].getX();
        double y1 = curve[ind].getY();
        double x2 = curve[ind + 1].getX();
        double y2 = curve[ind + 1].getY();
        WholeGridLineInterpolation line = new WholeGridLineInterpolation(x1, y1, x2, y2);
        int lineLength = line.getInterpolationLength();
        int ind1 = ind;
        int ind2 = ind + lineLength + 1;
        R2[] interpolatedCurve = new R2[length + lineLength];
        int i = 0;
        while (i <= ind1) {
            interpolatedCurve[i] = new R2(curve[i]);
            ++i;
        }
        line.fillLineArray(interpolatedCurve, ind1 + 1);
        i = 0;
        while (i < length - (ind + 1)) {
            interpolatedCurve[ind2 + i] = new R2(curve[ind + 1 + i]);
            ++i;
        }
        length = interpolatedCurve.length;
        int len = 8;
        int len1_1 = Math.min(ind1 + 1, len);
        int len1_2 = Math.min(length - ind1 - 1, len);
        int len2_1 = Math.min(ind2 + 1, len);
        int len2_2 = Math.min(length - ind2 - 1, len);
        if (!(len1_1 >= minLength && len1_2 >= minLength || len2_1 >= minLength && len2_2 >= minLength)) {
            return Math.toDegrees(fracture + fracture1);
        }
        if (len1_1 >= minLength && len1_2 >= minLength) {
            fracture = R2.getAngleBetweenSeries(interpolatedCurve, ind1 - len1_1 + 1, len1_1, ind1 + 1, len1_2);
        }
        if (len2_1 >= minLength && len2_2 >= minLength) {
            fracture1 = R2.getAngleBetweenSeries(interpolatedCurve, ind2 - len2_1 + 1, len2_1, ind2 + 1, len2_2);
        }
        return Math.toDegrees(fracture + fracture1);
    }

    public static double getFracture(R2[] curve, int length, int ind, int windowLength) {
        if (ind < windowLength - 1 || ind > length - windowLength - 1) {
            return 0.0;
        }
        return R2.getAngleBetweenSeries(curve, ind - windowLength + 1, windowLength, ind + 1, windowLength);
    }

    public static double getAngleBetweenSeries(R2[] series1, R2[] series2) {
        Line2D sLine1 = Line2D.leastSquareFitting(series1);
        Line2D sLine2 = Line2D.leastSquareFitting(series2);
        R2 v1 = sLine1.direction(series1[0], series1[series1.length - 1]);
        R2 v2 = sLine2.direction(series2[0], series2[series2.length - 1]);
        return v1.betweenAngle(v2);
    }

    public static double getAngleBetweenSeries(R2[] series, int start1, int length1, int start2, int length2) {
        Line2D sLine1 = Line2D.leastSquareFitting(series, start1, length1);
        Line2D sLine2 = Line2D.leastSquareFitting(series, start2, length2);
        R2 v1 = sLine1.direction(series[start1], series[start1 + length1 - 1]);
        R2 v2 = sLine2.direction(series[start2], series[start2 + length2 - 1]);
        return v1.betweenAngle(v2);
    }

    public static double getSeriesSlope(R2[] series) {
        return R2.getSeriesSlope(series, 0, series.length);
    }

    public static double getSeriesSlope(R2[] series, int start, int length) {
        Line2D sLine = Line2D.leastSquareFitting(series, start, length);
        R2 v = sLine.direction(series[start], series[start + length - 1]);
        return v.phaseAngle();
    }

    public static R2[] interpolateGapsAlongCurve(R2[] p) {
        return R2.interpolateGapsAlongCurve(p, 1.0);
    }

    public static R2[] interpolateGapsAlongCurve(R2[] p, double maxAdmittableGap) {
        ArrayList<R2> list = new ArrayList<R2>(p.length + Math.max(p.length / 10, 10));
        list.add(p[0]);
        int i = 1;
        while (i < p.length) {
            int stepsQty = (int)Math.ceil(p[i].dist(p[i - 1]) / maxAdmittableGap - 1.0);
            if (stepsQty > 0) {
                double xValue = p[i - 1].getX();
                double yValue = p[i - 1].getY();
                double xStep = (p[i].getX() - p[i - 1].getX()) / (double)(stepsQty + 1);
                double yStep = (p[i].getY() - p[i - 1].getY()) / (double)(stepsQty + 1);
                int j = 0;
                while (j < stepsQty) {
                    list.add(new R2(xValue += xStep, yValue += yStep));
                    ++j;
                }
            }
            list.add(p[i]);
            ++i;
        }
        return list.toArray(new R2[list.size()]);
    }

    public static R2[] getWholeXForXStrictMonotonic(R2[] points) {
        ArrayList<R2> tmp = new ArrayList<R2>(points.length);
        int nextOutIndex = (int)Math.round(points[0].getX());
        double leftXFloatIndex = -1.0;
        double leftYFloatIndex = -1.0;
        boolean leftExists = false;
        int i = 0;
        while (i < points.length) {
            double nextXFloatIndex = points[i].getX();
            double nextYFloatIndex = points[i].getY();
            if (nextXFloatIndex >= (double)nextOutIndex) {
                double tangent;
                if (leftExists) {
                    tangent = (nextYFloatIndex - leftYFloatIndex) / (nextXFloatIndex - leftXFloatIndex);
                    while ((double)nextOutIndex <= nextXFloatIndex) {
                        tmp.add(new R2((double)nextOutIndex, leftYFloatIndex + tangent * ((double)nextOutIndex - leftXFloatIndex)));
                        ++nextOutIndex;
                    }
                } else {
                    if (points.length > 1) {
                        tangent = (points[i + 1].getY() - nextYFloatIndex) / (points[i + 1].getX() - nextXFloatIndex);
                        tmp.add(new R2((double)nextOutIndex, nextYFloatIndex + tangent * ((double)nextOutIndex - nextXFloatIndex)));
                    } else {
                        tmp.add(new R2((double)nextOutIndex, nextYFloatIndex));
                    }
                    ++nextOutIndex;
                }
            }
            leftXFloatIndex = nextXFloatIndex;
            leftYFloatIndex = nextYFloatIndex;
            leftExists = true;
            ++i;
        }
        return tmp.toArray(new R2[tmp.size()]);
    }

    public static int roundTrip(R2[] points, int center, int first, int last) {
        int inc;
        if (points == null) {
            throw new IllegalArgumentException("points == null");
        }
        if (first < 0 || last < 0 || center < 0 || first >= points.length || last >= points.length || center >= points.length) {
            throw new IllegalArgumentException("first, last, or/and center is out of point.length, " + first + "," + last + "," + center + ", " + points.length);
        }
        if (center >= first && center <= last) {
            throw new IllegalArgumentException("center >= first && center <= last, " + center + " >= " + first + " && " + center + " <= " + last);
        }
        double MAX_ANGLE = 6.283285307179586;
        if (!points[center].isZero()) {
            R2[] tmpArr = points;
            points = new R2[Math.abs(last - first) + 1];
            int i = 0;
            while (i < points.length) {
                points[i] = ((R2)tmpArr[first + i].clone()).subtract(tmpArr[center]);
                ++i;
            }
            first = 0;
            last = points.length - 1;
            inc = 1;
        } else {
            inc = first <= last ? 1 : -1;
        }
        double sum = 0.0;
        if (last <= first + 1) {
            return 0;
        }
        sum = 0.0;
        int i = first;
        while (i < last) {
            if ((sum += points[i].rotationAngle(points[i + 1])) >= 6.283285307179586) break;
            i += inc;
        }
        if (sum < 6.283285307179586 && (sum += points[last].rotationAngle(points[first])) < 6.283285307179586) {
            return 0;
        }
        sum = 0.0;
        i = first;
        while (i < last) {
            double angle = -points[i].rotationAngle(points[i + 1]);
            if (angle < 0.0) {
                angle += Math.PI * 2;
            }
            if ((sum += angle) >= 6.283285307179586) break;
            ++i;
        }
        if (sum < 6.283285307179586) {
            double angle = -points[last].rotationAngle(points[first]);
            if (angle < 0.0) {
                angle += Math.PI * 2;
            }
            if ((sum += angle) < 6.283285307179586) {
                return 1;
            }
        }
        return 2;
    }

    public static double linearInter(double x, R2 p1, R2 p2) {
        return R2.linearInter(x, p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static double linearInter(double x, double x1, double y1, double x2, double y2) {
        if (x1 != x2) {
            return y1 + (x - x1) * ((y2 - y1) / (x2 - x1));
        }
        return Double.NaN;
    }

    public static double linearInter(double x, double[] xArr, double[] yArr) {
        return R2.linearInter(x, xArr, yArr, 0, xArr.length);
    }

    public static double linearInter(double x, double[] xArr, double[] yArr, int start, int length) {
        int ind = Search.leftNearest(xArr, x, start, start + length - 1);
        if (ind >= 0) {
            if (ind == start + length - 1) {
                --ind;
            }
        } else {
            ind = start;
        }
        return R2.linearInter(x, xArr[ind], yArr[ind], xArr[ind + 1], yArr[ind + 1]);
    }

    public static double linearInterSquare(double x1, double x2, double[] xArr, double[] yArr) {
        return R2.linearInterSquare(x1, x2, xArr, yArr, 0, xArr.length);
    }

    public static double linearInterSquare(double x1, double x2, double[] xArr, double[] yArr, int start, int length) {
        double square;
        int to;
        int from;
        int i1 = Search.leftNearest(xArr, x1, start, start + length - 1);
        int i2 = Search.leftNearest(xArr, x2, start, start + length - 1);
        if (i1 >= 0) {
            from = i1 + 1;
            if (i1 == start + length - 1) {
                --i1;
                from = 999999999;
            }
        } else {
            i1 = start;
            from = start;
        }
        if (i2 >= 0) {
            to = i2;
            if (i2 == start + length - 1) {
                --i2;
            }
        } else {
            i2 = start;
            to = -1;
        }
        double y1 = R2.linearInter(x1, xArr[i1], yArr[i1], xArr[i1 + 1], yArr[i1 + 1]);
        double y2 = R2.linearInter(x2, xArr[i2], yArr[i2], xArr[i2 + 1], yArr[i2 + 1]);
        if (to > from) {
            square = (xArr[from] - x1) * (y1 + yArr[from]) / 2.0 + (x2 - xArr[to]) * (yArr[to] + y2) / 2.0;
            int i = from;
            while (i < to) {
                square += (xArr[i + 1] - xArr[i]) * (yArr[i] + yArr[i + 1]) / 2.0;
                ++i;
            }
        } else {
            square = (x2 - x1) * (y1 + y2) / 2.0;
        }
        return square;
    }
}

