/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.geom;

import edu.uml.lgdc.datatype.Metricable;
import edu.uml.lgdc.datatype.geom.R2;
import edu.uml.lgdc.datatype.geom.Rn;

public class R3
extends Rn
implements Metricable<R3> {
    private static final long serialVersionUID = 957152309872389757L;

    public R3() {
        this(0.0, 0.0, 0.0);
    }

    public R3(R3 point) {
        this(point.getX(), point.getY(), point.getZ());
    }

    public R3(double[] coords) {
        super(R3.checkCoords(coords)[0], R3.checkCoords(coords)[1], R3.checkCoords(coords)[2]);
    }

    private static double[] checkCoords(double[] coords) {
        if (coords == null) {
            throw new IllegalArgumentException("coords is null");
        }
        if (coords.length != 3) {
            throw new IllegalArgumentException("coords.length != 3, is " + coords.length);
        }
        return coords;
    }

    public R3(double x, double y, double z) {
        super(x, y, z);
    }

    @Override
    public double dist(R3 point) {
        return R3.subtract(this, point).length();
    }

    public double getX() {
        return this.get(0);
    }

    public void setX(double x) {
        this.set(0, x);
    }

    public double getY() {
        return this.get(1);
    }

    public void setY(double y) {
        this.set(1, y);
    }

    public double getZ() {
        return this.get(2);
    }

    public void setZ(double z) {
        this.set(2, z);
    }

    public R3 setTo(R3 p) {
        this.setTo(p.getX(), p.getY(), p.getZ());
        return this;
    }

    public R3 setTo(double x, double y, double z) {
        super.setTo(x, y, z);
        return this;
    }

    @Override
    public R3 inverse() {
        super.inverse();
        return this;
    }

    public static R3 inverse(R3 v) {
        return new R3(v).inverse();
    }

    public R3 add(R3 vector) {
        super.add(vector);
        return this;
    }

    public static R3 add(R3 vector1, R3 vector2) {
        return new R3(vector1).add(vector2);
    }

    @Override
    public R3 scalar(double factor) {
        super.scalar(factor);
        return this;
    }

    public static R3 scalar(double factor, R3 vector) {
        return new R3(vector).scalar(factor);
    }

    public R3 subtract(R3 v) {
        R3 inversed = new R3(v).inverse();
        return this.add(inversed);
    }

    public static R3 subtract(R3 vector1, R3 vector2) {
        return new R3(vector2).inverse().add(vector1);
    }

    public R3 shift(R3 vector) {
        return this.add(vector);
    }

    public R3 shiftX(double shiftValue) {
        this.shiftAlongAxis(0, shiftValue);
        return this;
    }

    public R3 shiftY(double shiftValue) {
        this.shiftAlongAxis(1, shiftValue);
        return this;
    }

    public R3 shiftZ(double shiftValue) {
        this.shiftAlongAxis(2, shiftValue);
        return this;
    }

    public double getAzimuth() {
        return R2.phaseAngle(this.getX(), this.getY());
    }

    public double getPolar() {
        if (this.length() > 0.0) {
            return Math.acos(this.getZ() / this.length());
        }
        return Double.NaN;
    }

    public static R3 sphericalToR3(double radius, double azimuth_rad, double zenith_rad) {
        double sinZen = Math.sin(zenith_rad);
        double x = radius * sinZen * Math.cos(azimuth_rad);
        double y = radius * sinZen * Math.sin(azimuth_rad);
        double z = radius * Math.cos(zenith_rad);
        return new R3(x, y, z);
    }

    public double[] getSpherical() {
        double radius = this.length();
        double azimuth_rad = this.getAzimuth();
        double zenith_rad = Math.acos(this.getZ() / radius);
        return new double[]{radius, azimuth_rad, zenith_rad};
    }

    @Override
    public R3 normalize() {
        super.normalize();
        return this;
    }

    public static R3 normalize(R3 vector) {
        return new R3(vector).normalize();
    }

    public double betweenAngle(R3 v) {
        return super.betweenAngle(v);
    }

    public double dotProduct(R3 vector) {
        return this.scalarProduct(vector);
    }

    public static double dotProduct(R3 v1, R3 v2) {
        return R3.scalarProduct(v1, v2);
    }

    public double scalarProduct(R3 vector) {
        return super.scalarProduct(vector);
    }

    public static double scalarProduct(R3 vector1, R3 vector2) {
        return vector1.scalarProduct(vector2);
    }

    public R3 vecProduct(R3 vector) {
        double tempX = this.getX();
        double tempY = this.getY();
        double tempZ = this.getZ();
        this.setX(tempY * vector.getZ() - tempZ * vector.getY());
        this.setY(tempZ * vector.getX() - tempX * vector.getZ());
        this.setZ(tempX * vector.getY() - tempY * vector.getX());
        return this;
    }

    public static R3 vecProduct(R3 v1, R3 v2) {
        return new R3(v1).vecProduct(v2);
    }

    public R3 applyLinearOperator(double a11, double a12, double a13, double a21, double a22, double a23, double a31, double a32, double a33) {
        super.applyLinearOperator(new double[][]{{a11, a12, a13}, {a21, a22, a23}, {a31, a32, a33}});
        return this;
    }
}

