/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.geom;

import edu.uml.lgdc.datatype.geom.AbstractSet;
import edu.uml.lgdc.datatype.geom.DefaultEquivalence;
import edu.uml.lgdc.datatype.geom.Equivalence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SetFinite
implements AbstractSet {
    protected List<Object> elements;
    private Equivalence equivalence;

    public SetFinite() {
        this(new ArrayList<Object>());
    }

    public SetFinite(List<Object> elements) {
        this.setElements(elements);
        this.setEquivalence(new DefaultEquivalence(this));
    }

    public SetFinite(Object theOnlyElement) {
        ArrayList<Object> elements = new ArrayList<Object>(Arrays.asList(theOnlyElement));
        this.setElements(elements);
        this.setEquivalence(new DefaultEquivalence(this));
    }

    public SetFinite(SetFinite set) {
        this.setElements(set);
        this.setEquivalence(new DefaultEquivalence(this));
    }

    public void setElements(List<Object> elements) {
        List<Object> list = this.cloneList(elements);
        this.reduce(list);
        this.elements = list;
    }

    public void setElements(SetFinite set) {
        this.setElements(set.getElementsAsList());
    }

    public void setEquivalence(Equivalence equiv) {
        this.equivalence = equiv;
    }

    public int quantity() {
        return this.elements.size();
    }

    public Object get(int pos) {
        return this.elements.get(pos);
    }

    @Override
    public boolean contains(Object element) {
        return this.elements.contains(element);
    }

    public boolean contains(SetFinite set) {
        boolean result = true;
        int i = 0;
        while (i < set.quantity()) {
            if (!this.contains(set.get(i))) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    public boolean equals(SetFinite set) {
        return this.contains(set) && set.contains(this);
    }

    public SetFinite add(Object element) {
        return SetFinite.add(this, element);
    }

    public void delete(Object element) {
        this.elements.remove(element);
    }

    public void delete(int position) {
        this.elements.remove(position);
    }

    public SetFinite add(SetFinite otherSet) {
        return SetFinite.add(this, otherSet);
    }

    public SetFinite common(SetFinite otherSet) {
        return SetFinite.common(this, otherSet);
    }

    public SetFinite notCommon(SetFinite otherSet) {
        return SetFinite.notCommon(this, otherSet);
    }

    public List<Object> divide() {
        ArrayList<Object> sets = new ArrayList<Object>();
        SetFinite theRest = new SetFinite(this);
        while (theRest.quantity() > 0) {
            SetFinite equivSet = null;
            equivSet = this.equivalence.addEquivalent(theRest.get(0));
            sets.add(equivSet);
            theRest.notCommon(equivSet);
        }
        return sets;
    }

    public static SetFinite add(SetFinite set1, SetFinite set2) {
        int i = 0;
        while (i < set2.quantity()) {
            SetFinite.add(set1, set2.get(i));
            ++i;
        }
        return set1;
    }

    public static SetFinite common(SetFinite set1, SetFinite set2) {
        int i = 0;
        while (i < set1.quantity()) {
            if (!set2.contains(set1.get(i))) {
                set1.delete(i);
                continue;
            }
            ++i;
        }
        return set1;
    }

    public static SetFinite notCommon(SetFinite set1, SetFinite set2) {
        int i = 0;
        while (i < set1.quantity()) {
            if (set2.contains(set1.get(i))) {
                set1.delete(i);
                continue;
            }
            ++i;
        }
        return set1;
    }

    public static SetFinite add(SetFinite set, Object element) {
        if (!set.contains(element)) {
            set.getElementsAsList().add(element);
        }
        return set;
    }

    public static SetFinite union(SetFinite set1, SetFinite set2) {
        SetFinite set = new SetFinite(set1);
        return SetFinite.add(set, set2);
    }

    public static SetFinite intersect(SetFinite set1, SetFinite set2) {
        SetFinite set = new SetFinite(set1);
        return SetFinite.common(set, set2);
    }

    public static SetFinite subtract(SetFinite set1, SetFinite set2) {
        SetFinite set = new SetFinite(set1);
        return SetFinite.notCommon(set, set2);
    }

    public static SetFinite difference(SetFinite set1, SetFinite set2) {
        return SetFinite.union(SetFinite.subtract(set1, set2), SetFinite.subtract(set2, set1));
    }

    private List<Object> getElementsAsList() {
        return this.elements;
    }

    private List<Object> cloneList(List<Object> list) {
        ArrayList<Object> newList = new ArrayList<Object>(list.size());
        int i = 0;
        while (i < list.size()) {
            newList.add(list.get(i));
            ++i;
        }
        return newList;
    }

    private void reduce(List<Object> list) {
        int i = 0;
        while (i < list.size() - 1) {
            Object obj = list.get(i);
            int j = i + 1;
            while (j < list.size()) {
                if (obj.equals(list.get(j))) {
                    list.remove(j);
                    continue;
                }
                ++j;
            }
            ++i;
        }
    }
}

