/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.geom;

import edu.uml.lgdc.datatype.geom.Line2D;
import edu.uml.lgdc.datatype.geom.LineSegment2D;
import edu.uml.lgdc.datatype.geom.R2;
import edu.uml.lgdc.datatype.geom.SetR2Analytical;
import edu.uml.lgdc.datatype.geom.SetR2StraightSets;
import edu.uml.lgdc.math.ExtMath;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;

public class ZigzagLine2D
extends SetR2Analytical {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_POINT = 1;
    private static final double SMALL_NUMBER = 1.0E-11;
    private R2[] vs;
    private SetR2StraightSets sets;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private int type;
    private double length = -1.0;

    public ZigzagLine2D(R2[] p) {
        this(p, 0);
    }

    public ZigzagLine2D(R2[] p, int start) {
        this(p, start, p.length - start);
    }

    public ZigzagLine2D(R2[] p, int start, int length) {
        this.normalize(p, start, length);
        this.createStraightSets();
    }

    @Override
    public boolean contains(Object element) {
        return this.sets.contains(element);
    }

    @Override
    public boolean includes(Object object) {
        return this.sets.includes(object);
    }

    public double getLength() {
        if (this.length < 0.0) {
            double length = 0.0;
            if (this.type == 0) {
                int i = 0;
                while (i < this.vs.length - 1) {
                    length += this.vs[i].dist(this.vs[i + 1]);
                    ++i;
                }
            }
            this.length = length;
        }
        return this.length;
    }

    @Override
    public double distance(R2 p) {
        double dist = Double.MAX_VALUE;
        if (this.type == 0) {
            int i = 0;
            while (i < this.vs.length - 1) {
                LineSegment2D seg = new LineSegment2D(this.vs[i], this.vs[i + 1]);
                dist = Math.min(dist, seg.distance(p));
                ++i;
            }
        } else {
            dist = p.dist(this.vs[0]);
        }
        return dist;
    }

    public SetR2StraightSets getSets() {
        return this.sets;
    }

    public Set<Object> intersection(Line2D sLine) {
        return this.sets.intersection(sLine);
    }

    public Set<Object> intersection(LineSegment2D segment) {
        return this.sets.intersection(segment);
    }

    public Set<Object> intersection(ZigzagLine2D zLine) {
        return this.sets.intersection(zLine.getSets());
    }

    public int qtyOfVertices() {
        return this.vs.length;
    }

    public R2 getVertex(int i) {
        return this.vs[i];
    }

    public LineSegment2D getSegment(int i) {
        return new LineSegment2D(this.vs[i], this.vs[i + 1]);
    }

    public int hashCode() {
        int hashcode = this.vs[0].hashCode();
        int i = 1;
        while (i < this.vs.length) {
            hashcode = 31 * hashcode + this.vs[i].hashCode();
            ++i;
        }
        return hashcode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            return Arrays.equals(this.vs, ((ZigzagLine2D)object).vs);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        R2[] r2Array = this.vs;
        int n = this.vs.length;
        int n2 = 0;
        while (n2 < n) {
            R2 vertex = r2Array[n2];
            if (sb.length() > 0) {
                sb.append("-");
            }
            sb.append(vertex);
            ++n2;
        }
        return sb.toString();
    }

    private void normalize(R2[] p, int start, int length) {
        R2 pCurr = p[start];
        this.xMin = pCurr.getX();
        this.xMax = pCurr.getX();
        this.yMin = pCurr.getY();
        this.yMax = pCurr.getY();
        LinkedList<R2> vertList = new LinkedList<R2>();
        vertList.add(new R2(pCurr));
        int i = start + 1;
        while (i < start + length) {
            if (!ExtMath.areClose(p[i].getX(), pCurr.getX(), 1.0E-11) || !ExtMath.areClose(p[i].getY(), pCurr.getY(), 1.0E-11)) {
                pCurr = p[i];
                vertList.add(new R2(pCurr));
                if (pCurr.getX() < this.xMin) {
                    this.xMin = pCurr.getX();
                } else if (pCurr.getX() > this.xMax) {
                    this.xMax = pCurr.getX();
                }
                if (pCurr.getY() < this.yMin) {
                    this.yMin = pCurr.getY();
                } else if (pCurr.getY() > this.yMax) {
                    this.yMax = pCurr.getY();
                }
            }
            ++i;
        }
        this.vs = vertList.toArray(new R2[vertList.size()]);
        int uniqueQty = this.vs.length;
        boolean reverseOrder = false;
        int i2 = 0;
        while (i2 < uniqueQty / 2) {
            if (this.vs[uniqueQty - 1 - i2].getX() < this.vs[i2].getX()) {
                reverseOrder = true;
            } else if (this.vs[i2].getX() == this.vs[uniqueQty - 1 - i2].getX() && this.vs[uniqueQty - 1 - i2].getY() < this.vs[i2].getY()) {
                reverseOrder = true;
            }
            if (reverseOrder) break;
            ++i2;
        }
        if (reverseOrder) {
            i2 = 0;
            while (i2 < uniqueQty / 2) {
                pCurr = this.vs[i2];
                this.vs[i2] = this.vs[uniqueQty - 1 - i2];
                this.vs[uniqueQty - 1 - i2] = pCurr;
                ++i2;
            }
        }
        this.type = 0;
        if (uniqueQty == 1) {
            this.type = 1;
        }
    }

    private void createStraightSets() {
        Object[] seg = new LineSegment2D[this.vs.length - 1];
        int i = 0;
        while (i < seg.length) {
            seg[i] = new LineSegment2D(this.vs[i], this.vs[i + 1]);
            ++i;
        }
        this.sets = new SetR2StraightSets(seg);
    }
}

