/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.fileio;

import edu.uml.lgdc.fileio.Mask;
import edu.uml.lgdc.fileio.MaskBuilder;
import edu.uml.lgdc.fileio.MaskInterface;
import edu.uml.lgdc.time.TimeScale;

public abstract class DateMask
extends Mask {
    protected TimeScale date = null;
    private int year;
    private int month;
    private int dayOfMonth;
    private int dayOfYear;
    private int hr;
    private int min;
    private int sec;
    private long definedStartTime;
    private long definedEndTime;
    private int lastMatchedLength = -1;

    public DateMask() {
    }

    public DateMask(MaskInterface mi) {
        this.mi = mi;
    }

    public DateMask(final Mask mask) {
        this.mi = new MaskInterface(){

            @Override
            public int firstMatch(String str) {
                return mask.firstMatch(str);
            }

            @Override
            public int nextMatch(String str) {
                return mask.nextMatch(str);
            }
        };
    }

    @Override
    public int firstMatch(String str) {
        this.lastMatchedLength = super.firstMatch(str);
        if (this.lastMatchedLength >= 0 && !this.extractDate()) {
            this.lastMatchedLength = this.nextMatch(str);
        }
        return this.lastMatchedLength;
    }

    @Override
    public int nextMatch(String str) {
        if (this.lastMatchedLength == -1) {
            return this.lastMatchedLength;
        }
        this.lastMatchedLength = super.nextMatch(str);
        while (this.lastMatchedLength >= 0 && !this.extractDate()) {
            this.lastMatchedLength = super.nextMatch(str);
        }
        return this.lastMatchedLength;
    }

    public final TimeScale getDate() {
        return this.date;
    }

    public final TimeScale[] getDateRange() {
        return new TimeScale[]{new TimeScale(this.definedStartTime), new TimeScale(this.definedEndTime)};
    }

    public final int getRangeInSec() {
        return (int)((this.definedEndTime - this.definedStartTime) / 1000L);
    }

    protected abstract int extractYear();

    protected abstract int extractMonth();

    protected abstract int extractDayOfMonth();

    protected abstract int extractDayOfYear();

    protected abstract int extractHour();

    protected abstract int extractMinute();

    protected abstract int extractSecond();

    protected boolean extractDate() {
        this.year = this.extractYear();
        this.month = this.extractMonth();
        this.dayOfMonth = this.extractDayOfMonth();
        this.dayOfYear = this.extractDayOfYear();
        this.hr = this.extractHour();
        this.min = this.extractMinute();
        this.sec = this.extractSecond();
        this.date = TimeScale.createFromFields(this.year, this.month, this.dayOfMonth, this.dayOfYear, this.hr, this.min, this.sec);
        if (this.date == null) {
            return false;
        }
        this.definedStartTime = this.date.getTimeInMilliSeconds();
        this.definedEndTime = this.month == -1 && this.dayOfYear == -1 ? this.date.endOfYear().getTimeInMilliSeconds() : (this.dayOfYear == -1 && (this.month == -1 || this.dayOfMonth == -1) ? this.date.endOfMonth().getTimeInMilliSeconds() : (this.hr == -1 ? this.date.endOfDay().getTimeInMilliSeconds() : (this.min == -1 ? this.date.endOfHour().getTimeInMilliSeconds() : (this.sec == -1 ? this.date.endOfMinute().getTimeInMilliSeconds() : this.definedStartTime))));
        return this.date != null;
    }

    public boolean isInInterval(TimeScale startTime, TimeScale endTime) {
        if (startTime != null && this.definedEndTime < startTime.getTimeInMilliSeconds()) {
            return false;
        }
        return endTime == null || this.definedStartTime <= endTime.getTimeInMilliSeconds();
    }

    public static DateMask createDateMask(final Mask[] masks, final int dateMaskInd) {
        return new DateMask(MaskBuilder.exactArrayOfMasksMask(masks)){

            @Override
            protected int extractYear() {
                return ((DateMask)masks[dateMaskInd]).extractYear();
            }

            @Override
            protected int extractMonth() {
                return ((DateMask)masks[dateMaskInd]).extractMonth();
            }

            @Override
            protected int extractDayOfMonth() {
                return ((DateMask)masks[dateMaskInd]).extractDayOfMonth();
            }

            @Override
            protected int extractDayOfYear() {
                return ((DateMask)masks[dateMaskInd]).extractDayOfYear();
            }

            @Override
            protected int extractHour() {
                return ((DateMask)masks[dateMaskInd]).extractHour();
            }

            @Override
            protected int extractMinute() {
                return ((DateMask)masks[dateMaskInd]).extractMinute();
            }

            @Override
            protected int extractSecond() {
                return ((DateMask)masks[dateMaskInd]).extractSecond();
            }
        };
    }
}

